/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.jmx.MxServiceQuery;
import org.hyperic.hq.product.jmx.MxUtil;

class MxObjectNameQuery
extends MxServiceQuery {
    private String type;
    private Map props;
    private ArrayList names;

    MxObjectNameQuery() {
    }

    void setType(String type) {
        this.type = type;
    }

    public MxServiceQuery cloneInstance() {
        MxObjectNameQuery query = (MxObjectNameQuery)super.cloneInstance();
        query.type = this.type;
        query.props = this.props;
        query.names = this.names;
        return query;
    }

    protected String getProperty(String name) {
        return this.getServerDetector().getTypeProperty(this.type, name);
    }

    private StringBuffer appendComma(StringBuffer buf) {
        char c = buf.charAt(buf.length() - 1);
        if (c != ',' && c != ':') {
            buf.append(',');
        }
        return buf;
    }

    private boolean isAutoValue(String val) {
        return val.startsWith("%") && val.endsWith("%");
    }

    private ObjectName getObjectNameProperty() {
        ObjectName oName;
        String name = this.getProperty("OBJECT_NAME");
        if (name == null) {
            String msg = this.type + " service did not define property " + "OBJECT_NAME";
            throw new IllegalArgumentException(msg);
        }
        name = MxUtil.expandObjectName(name, this.getServerDetector().getConfig());
        this.names = new ArrayList();
        try {
            oName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            String msg = this.type + " service defined malformed " + "OBJECT_NAME" + "=" + name;
            throw new IllegalArgumentException(msg);
        }
        Hashtable<String, String> props = oName.getKeyPropertyList();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!this.isAutoValue(val)) continue;
            this.names.add(key);
        }
        return oName;
    }

    public String getMBeanClass() {
        return this.getProperty("MBEAN_CLASS");
    }

    public String getObjectNameFilter() {
        return this.getProperty("OBJECT_NAME_FILTER");
    }

    public String getQueryName() {
        ObjectName name = this.getObjectNameProperty();
        StringBuffer buf = new StringBuffer();
        buf.append(name.getDomain()).append(":");
        boolean isPattern = false;
        this.props = name.getKeyPropertyList();
        Iterator it = this.props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (this.isAutoValue(val)) {
                this.props.put(key, "*");
                isPattern = true;
                continue;
            }
            buf.append(key).append('=').append(val);
            if (!it.hasNext()) continue;
            this.appendComma(buf);
        }
        if (isPattern) {
            this.appendComma(buf).append('*');
        }
        return buf.toString();
    }

    public boolean apply(ObjectName name) {
        Hashtable<String, String> props = name.getKeyPropertyList();
        if (this.props.size() != props.size()) {
            return false;
        }
        for (Map.Entry entry : this.props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String compare = (String)props.get(key);
            if (compare == null) {
                return false;
            }
            if (val.equals("*") || val.equals(compare)) continue;
            return false;
        }
        return true;
    }

    public String getServiceResourceType() {
        return this.getServerDetector().getTypeNameProperty(this.type);
    }

    public Properties getResourceConfig() {
        ObjectName name = this.getObjectName();
        Properties config = new Properties();
        for (String key : this.props.keySet()) {
            String val;
            if (!this.props.get(key).equals("*") || (val = name.getKeyProperty(key)) == null) continue;
            config.setProperty(key, val);
        }
        return config;
    }

    public String getName() {
        ObjectName oName = this.getObjectName();
        if (oName == null) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        Iterator it = this.names.iterator();
        while (it.hasNext()) {
            name.append(oName.getKeyProperty((String)it.next()));
            if (!it.hasNext()) continue;
            name.append(' ');
        }
        return name.toString();
    }

    public boolean hasControl() {
        ProductPluginManager ppm = (ProductPluginManager)this.getServerDetector().getManager().getParent();
        ControlPlugin plugin = ppm.getControlPlugin(this.type);
        return plugin != null;
    }
}

