/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.hq.product.jmx.MxControlPlugin;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class MxServerControlPlugin
extends ServerControlPlugin {
    private String objectName;
    private List actions;
    private static final List ACTIONS = Arrays.asList("start", "stop", "restart");

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.actions = super.getActions();
        if (this.actions.size() == 0) {
            this.actions = ACTIONS;
        }
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.objectName = MxControlPlugin.configureObjectName(this);
    }

    public List getActions() {
        return this.actions;
    }

    protected boolean isBackgroundCommand() {
        return false;
    }

    protected String[] getArgs(String action) {
        Object[] args = new String[]{action};
        String cmdline = this.getTypeProperty(action + ".args");
        if (cmdline != null) {
            cmdline = Metric.translate(cmdline, this.getConfig());
            Object[] opts = StringUtil.explodeQuoted((String)cmdline);
            return (String[])ArrayUtil.combine((Object[])args, (Object[])opts);
        }
        return args;
    }

    protected String getObjectName() {
        return this.objectName;
    }

    protected int invokeMethod(String objectName, String operation, String[] args) {
        MxControlPlugin.invokeMethod(this, objectName, operation, args);
        return this.getResult();
    }

    protected int invokeMethod(String objectName, String operation) {
        return this.invokeMethod(objectName, operation, new String[0]);
    }

    protected int invokeMethod(String operation) {
        return this.invokeMethod(this.getObjectName(), operation);
    }

    protected int invokeMethod(String operation, String[] args) {
        return this.invokeMethod(this.getObjectName(), operation, args);
    }

    public void doAction(String action, String[] args) throws PluginException {
        if (action.equals("start")) {
            this.start();
        } else if (action.equals("restart")) {
            this.restart();
        } else {
            int status = this.invokeMethod(this.getObjectName(), action, args);
            if (status != 0 && action.equals("stop")) {
                this.stop();
            }
        }
    }

    public int start() {
        int status = this.doCommand(this.getArgs("start"));
        if (status == 0) {
            this.setMessage("start executed successfully");
        }
        return status;
    }

    public int stop() {
        int status = this.doCommand(this.getArgs("stop"));
        if (status == 0) {
            this.setMessage("stop executed successfully");
        }
        return status;
    }

    public int restart() {
        int stopStatus = this.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int startStatus = this.start();
        if (startStatus == 0 && stopStatus == 0) {
            this.setMessage("restart executed successfully");
            return 0;
        }
        if (startStatus != 0 && stopStatus != 0) {
            this.setMessage("restart failed");
        } else if (startStatus == 0 && stopStatus != 0) {
            this.setMessage("stop failed but start succeeded");
        } else if (startStatus != 0 && stopStatus == 0) {
            this.setMessage("stop succeeded but start failed");
        }
        return -1;
    }
}

