/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MBeanUtil;
import org.hyperic.hq.product.jmx.MxCompositeData;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.config.ConfigResponse;

public class MxUtil {
    static final String PTQL_PREFIX = "ptql:";
    public static final String PROP_JMX_URL = "jmx.url";
    public static final String PROP_JMX_PORT = "jmx.port";
    public static final String PROP_JMX_USERNAME = "jmx.username";
    public static final String PROP_JMX_PASSWORD = "jmx.password";
    public static final String PROP_JMX_PROVIDER_PKGS = "jmx.provider.pkgs";
    private static final String STATS_PREFIX = "Stats.";
    private static final String COMPOSITE_PREFIX = "Composite.";
    private static final Log log = LogFactory.getLog(MxUtil.class);
    private static HashMap cache = new HashMap();
    private static final Map<JMXConnectorKey, JMXConnector> mbeanConns = new HashMap<JMXConnectorKey, JMXConnector>();

    static String expandObjectName(String name) {
        int ix = name.indexOf("*");
        if (ix == -1) {
            return name;
        }
        StringBuffer objectName = new StringBuffer();
        ix = name.indexOf(58);
        if (ix != -1) {
            objectName.append(name.substring(0, ix + 1));
            name = name.substring(ix + 1);
        }
        StringTokenizer tok = new StringTokenizer(name, ",");
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            if (pair.equals("*")) {
                objectName.append(pair);
                break;
            }
            ix = pair.indexOf("=");
            if (ix == -1) {
                throw new IllegalArgumentException(name);
            }
            String key = pair.substring(0, ix);
            String val = pair.substring(ix + 1);
            if (val.equals("*")) {
                val = "%" + key + "%";
            }
            objectName.append(key).append('=').append(val);
            if (!tok.hasMoreTokens()) continue;
            objectName.append(',');
        }
        return objectName.toString();
    }

    static String expandObjectName(String name, ConfigResponse config) {
        return Metric.translate(MxUtil.expandObjectName(name), config);
    }

    static String expandObjectName(String name, Properties config) {
        return Metric.translate(MxUtil.expandObjectName(name), config);
    }

    private static MetricInvalidException invalidObjectName(String name, Exception e) {
        String msg = "Malformed ObjectName [" + name + "]";
        return new MetricInvalidException(msg, e);
    }

    private static MetricUnreachableException unreachable(Properties props, Exception e) {
        String msg = "Can't connect to MBeanServer url [" + props.getProperty(PROP_JMX_URL) + "] " + "port [" + props.getProperty(PROP_JMX_PORT) + "] " + "username [" + props.getProperty(PROP_JMX_USERNAME) + "]: " + e;
        return new MetricUnreachableException(msg, e);
    }

    private static MetricNotFoundException objectNotFound(String name, Exception e) {
        String msg = "ObjectName not found [" + name + "]: " + e;
        return new MetricNotFoundException(msg, e);
    }

    private static MetricNotFoundException attributeNotFound(String object, String name, Exception e) {
        String msg = "Attribute not found [" + object + ":" + name + "]: " + e;
        return new MetricNotFoundException(msg, e);
    }

    private static PluginException error(String name, Exception e) {
        String msg = "Invocation error [" + name + "]: " + e;
        return new PluginException(msg, e);
    }

    private static PluginException invalidURL(Properties props, Exception e) {
        String msg = "Malformed URL: [" + props.getProperty(PROP_JMX_URL) + "]";
        return new PluginException(msg, e);
    }

    private static PluginException error(String name, Exception e, String method) {
        String msg = "Method '" + method + "' invocation error [" + name + "]: " + e;
        return new PluginException(msg, e);
    }

    static Double getJSR77Statistic(MBeanServerConnection mServer, ObjectName objName, String attribute) throws MalformedURLException, MalformedObjectNameException, IOException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, PluginException {
        long value;
        Boolean provider = (Boolean)mServer.getAttribute(objName, "statisticsProvider");
        if (provider == null || !provider.booleanValue()) {
            String msg = objName + " does not provide statistics";
            throw new PluginException(msg);
        }
        Stats stats = (Stats)mServer.getAttribute(objName, "stats");
        if (stats == null) {
            throw new PluginException(objName + " has no stats");
        }
        String statName = attribute.substring(STATS_PREFIX.length());
        Statistic stat = stats.getStatistic(statName);
        if (stat == null) {
            String msg = "Statistic '" + statName + "' not found [" + objName + "]";
            throw new AttributeNotFoundException(msg);
        }
        if (stat instanceof CountStatistic) {
            value = ((CountStatistic)stat).getCount();
        } else if (stat instanceof RangeStatistic) {
            value = ((RangeStatistic)stat).getCurrent();
        } else if (stat instanceof TimeStatistic) {
            long count = ((TimeStatistic)stat).getCount();
            value = count == 0L ? 0L : ((TimeStatistic)stat).getTotalTime() / count;
        } else {
            String msg = "Unsupported statistic type [" + statName.getClass().getName() + " for [" + objName + ":" + attribute + "]";
            throw new MetricInvalidException(msg);
        }
        if (statName.equals("UpTime")) {
            value = System.currentTimeMillis() - value;
        }
        return new Double(value);
    }

    static Object getCompositeMetric(MBeanServerConnection mServer, ObjectName objName, String attribute) throws MalformedURLException, MalformedObjectNameException, IOException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, PluginException {
        String name = attribute.substring(COMPOSITE_PREFIX.length());
        int ix = name.indexOf(46);
        if (ix == -1) {
            throw new MetricInvalidException("Missing composite key");
        }
        String attr = name.substring(0, ix);
        String key = name.substring(ix + 1);
        Object obj = mServer.getAttribute(objName, attr);
        if (obj instanceof CompositeData) {
            return MxCompositeData.getValue((CompositeData)obj, key);
        }
        throw new MetricInvalidException("Not CompositeData");
    }

    static Object getValue(Metric metric) throws MetricNotFoundException, MetricInvalidException, MetricUnreachableException, PluginException {
        String objectName = Metric.decode(metric.getObjectName());
        String attribute = metric.getAttributeName();
        Properties config = metric.getProperties();
        try {
            return MxUtil.getValue(config, objectName, attribute);
        }
        catch (MalformedURLException e) {
            throw MxUtil.invalidURL(metric.getProperties(), e);
        }
        catch (MalformedObjectNameException e) {
            throw MxUtil.invalidObjectName(objectName, e);
        }
        catch (IOException e) {
            MxUtil.removeMBeanConnector(config);
            if (metric.isAvail()) {
                return new Double(0.0);
            }
            throw MxUtil.unreachable(metric.getProperties(), e);
        }
        catch (MBeanException e) {
            throw MxUtil.error(metric.toString(), e);
        }
        catch (AttributeNotFoundException e) {
            if (metric.isAvail()) {
                return new Double(1.0);
            }
            throw MxUtil.attributeNotFound(objectName, metric.getAttributeName(), e);
        }
        catch (InstanceNotFoundException e) {
            if (metric.isAvail()) {
                return new Double(0.0);
            }
            throw MxUtil.objectNotFound(objectName, e);
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause2;
            Throwable cause1 = e.getCause();
            if (cause1 instanceof InvocationTargetException && (cause2 = cause1.getCause()) instanceof InstanceNotFoundException) {
                throw MxUtil.objectNotFound(objectName, (InstanceNotFoundException)cause2);
            }
            throw e;
        }
        catch (ReflectionException e) {
            throw MxUtil.error(metric.toString(), e);
        }
        catch (RuntimeException e) {
            if (metric.isAvail()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (cause instanceof AttributeNotFoundException) {
                        return new Double(1.0);
                    }
                    if (!(cause instanceof InstanceNotFoundException)) continue;
                    return new Double(0.0);
                }
            }
            throw e;
        }
    }

    private static void removeMBeanConnector(Properties config) {
        String jmxUrl = config.getProperty(PROP_JMX_URL);
        if (cache.get(jmxUrl) != null) {
            log.debug((Object)("Removing (stale) cached connection for: " + jmxUrl));
            MxUtil.disconnect(jmxUrl);
        }
    }

    static String getUrlFromPid(String ptql) throws IOException {
        String address;
        long pid;
        Sigar sigar = new Sigar();
        try {
            pid = new ProcessFinder(sigar).findSingleProcess(ptql);
            Class<?> caddrLinkClass = Class.forName("sun.management.ConnectorAddressLink");
            Method importFrom = caddrLinkClass.getMethod("importFrom", Integer.TYPE);
            address = (String)importFrom.invoke(caddrLinkClass, new Integer((int)pid));
        }
        catch (ClassNotFoundException e) {
            String jvm = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            throw new IOException(ptql + " " + e.getMessage() + " not supported by " + jvm);
        }
        catch (InvocationTargetException e) {
            throw new IOException(ptql + " " + e.getCause());
        }
        catch (Exception e) {
            throw new IOException(ptql + " " + e);
        }
        finally {
            sigar.close();
        }
        if (address == null) {
            throw new IOException("Unable to determine jmx.url using vmid=" + pid + ".  Server must be started with: " + "-Dcom.sun.management.jmxremote");
        }
        log.debug((Object)(PTQL_PREFIX + ptql + " resolved to vmid=" + pid + ", " + PROP_JMX_URL + "=" + address));
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXConnector getCachedMBeanConnector(Properties config) throws MalformedURLException, IOException {
        String jmxUrl = config.getProperty(PROP_JMX_URL);
        String user = config.getProperty(PROP_JMX_USERNAME);
        String pass = config.getProperty(PROP_JMX_PASSWORD);
        JMXConnectorKey key = new JMXConnectorKey(jmxUrl, user, pass);
        JMXConnector rtn = null;
        Map<JMXConnectorKey, JMXConnector> map = mbeanConns;
        synchronized (map) {
            rtn = mbeanConns.get(key);
            if (rtn == null) {
                rtn = MxUtil.getMBeanConnector(config);
                mbeanConns.put(key, rtn);
            }
            try {
                rtn.getMBeanServerConnection();
            }
            catch (IOException e) {
                MxUtil.close(rtn);
                rtn = MxUtil.getMBeanConnector(config);
                mbeanConns.put(key, rtn);
            }
        }
        final JMXConnector c = rtn;
        InvocationHandler handler = new InvocationHandler(){
            private final JMXConnector conn;
            {
                this.conn = c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close")) {
                    return null;
                }
                JMXConnector jMXConnector = this.conn;
                synchronized (jMXConnector) {
                    return method.invoke((Object)this.conn, args);
                }
            }
        };
        return (JMXConnector)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{JMXConnector.class}, handler);
    }

    public static JMXConnector getMBeanConnector(Properties config) throws MalformedURLException, IOException {
        JMXServiceURL url;
        String proto;
        String jmxUrl = config.getProperty(PROP_JMX_URL);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String user = config.getProperty(PROP_JMX_USERNAME);
        String pass = config.getProperty(PROP_JMX_PASSWORD);
        map.put("jmx.remote.credentials", new String[]{user, pass});
        String providerPackages = config.getProperty(PROP_JMX_PROVIDER_PKGS);
        if (providerPackages != null) {
            map.put("jmx.remote.protocol.provider.pkgs", providerPackages);
        }
        if (jmxUrl == null) {
            throw new MalformedURLException("jmx.url==null");
        }
        if (jmxUrl.startsWith(PTQL_PREFIX)) {
            jmxUrl = MxUtil.getUrlFromPid(jmxUrl.substring(PTQL_PREFIX.length()));
        }
        if ((proto = (url = new JMXServiceURL(jmxUrl)).getProtocol()).equals("t3") || proto.equals("t3s")) {
            map.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            map.put("java.naming.security.principal", user);
            map.put("java.naming.security.credentials", pass);
        }
        JMXConnector connector = JMXConnectorFactory.connect(url, map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created new JMXConnector url=" + url + ", classloader=" + Thread.currentThread().getContextClassLoader()));
        }
        return connector;
    }

    private static void disconnect(String jmxUrl) {
        Object obj = cache.remove(jmxUrl);
        if (obj != null) {
            JMXConnector connector = ((ConnectorInstance)obj).connector;
            MxUtil.close(connector);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closed previous connector (" + MxUtil.address(connector) + ") for: " + jmxUrl));
            }
        }
    }

    private static JMXConnector connect(Properties config, String jmxUrl, String jmxUsername, String jmxPassword) throws IOException {
        MxUtil.disconnect(jmxUrl);
        JMXConnector connector = MxUtil.getMBeanConnector(config);
        cache.put(jmxUrl, new ConnectorInstance(connector, jmxUsername, jmxPassword));
        log.debug((Object)("Opened new connector (" + MxUtil.address(connector) + ") for: " + jmxUrl));
        return connector;
    }

    private static String address(Object obj) {
        return "@" + Integer.toHexString(obj.hashCode());
    }

    private static String mask(String val) {
        return val.replaceAll(".", "*");
    }

    private static String diff(String old, String cur) {
        return "'" + old + "'->'" + cur + "'";
    }

    public static MBeanServerConnection getMBeanServer(Properties config) throws MalformedURLException, IOException {
        JMXConnector connector;
        String jmxUrl = config.getProperty(PROP_JMX_URL);
        String jmxUsername = config.getProperty(PROP_JMX_USERNAME, "");
        String jmxPassword = config.getProperty(PROP_JMX_PASSWORD, "");
        boolean isCached = false;
        ConnectorInstance instance = (ConnectorInstance)cache.get(jmxUrl);
        if (instance != null) {
            boolean passwordChanged;
            connector = instance.connector;
            String username = instance.username;
            String password = instance.password;
            boolean usernameChanged = !username.equals(jmxUsername);
            boolean bl = passwordChanged = !password.equals(jmxPassword);
            if (usernameChanged || passwordChanged) {
                if (log.isDebugEnabled()) {
                    String diff = "";
                    if (usernameChanged) {
                        diff = diff + "user:" + MxUtil.diff(username, jmxUsername);
                    }
                    if (passwordChanged) {
                        if (diff.length() != 0) {
                            diff = diff + ",";
                        }
                        diff = diff + "pass:" + MxUtil.diff(MxUtil.mask(password), MxUtil.mask(jmxPassword));
                    }
                    log.debug((Object)("Credentials changed (" + diff + ") reconnecting cached connection for: " + jmxUrl));
                }
                connector = MxUtil.connect(config, jmxUrl, jmxUsername, jmxPassword);
            } else {
                isCached = true;
            }
        } else {
            connector = MxUtil.connect(config, jmxUrl, jmxUsername, jmxPassword);
            log.debug((Object)("Caching connector for: " + jmxUrl));
        }
        try {
            return connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            if (isCached) {
                log.debug((Object)("Reconnecting cached connection for: " + jmxUrl));
                connector = MxUtil.connect(config, jmxUrl, jmxUsername, jmxPassword);
                return connector.getMBeanServerConnection();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Properties config, String objectName, String attribute) throws MalformedURLException, MalformedObjectNameException, IOException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, PluginException {
        ObjectName objName = new ObjectName(objectName);
        JMXConnector connector = null;
        try {
            connector = MxUtil.getCachedMBeanConnector(config);
            if (attribute.startsWith(STATS_PREFIX)) {
                Double d = MxUtil.getJSR77Statistic(connector.getMBeanServerConnection(), objName, attribute);
                return d;
            }
            if (attribute.startsWith(COMPOSITE_PREFIX)) {
                Object object = MxUtil.getCompositeMetric(connector.getMBeanServerConnection(), objName, attribute);
                return object;
            }
            Object object = connector.getMBeanServerConnection().getAttribute(objName, attribute);
            return object;
        }
        finally {
            MxUtil.close(connector);
        }
    }

    private static Object setAttribute(MBeanServerConnection mServer, ObjectName obj, String name, Object value) throws MetricUnreachableException, MetricNotFoundException, PluginException, ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        if (name.startsWith("set")) {
            name = name.substring(3);
        }
        Attribute attr = new Attribute(name, value);
        try {
            mServer.setAttribute(obj, attr);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException(e.getMessage(), e);
        }
        catch (InvalidAttributeValueException e) {
            throw new ReflectionException(e);
        }
        return null;
    }

    private static Object getAttribute(MBeanServerConnection mServer, ObjectName obj, String name) throws MetricUnreachableException, MetricNotFoundException, PluginException, ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        if (name.startsWith("get")) {
            name = name.substring(3);
        }
        try {
            return mServer.getAttribute(obj, name);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException(e.getMessage(), e);
        }
    }

    public static Object invoke(Properties config, String objectName, String method, Object[] args, String[] sig) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        JMXConnector connector = null;
        try {
            connector = MxUtil.getMBeanConnector(config);
            MBeanServerConnection mServer = connector.getMBeanServerConnection();
            ObjectName obj = new ObjectName(objectName);
            MBeanInfo info = mServer.getMBeanInfo(obj);
            if (sig.length == 0) {
                MBeanUtil.OperationParams params = MBeanUtil.getOperationParams(info, method, args);
                if (params.isAttribute) {
                    if (method.startsWith("set")) {
                        Object object = MxUtil.setAttribute(mServer, obj, method, params.arguments[0]);
                        return object;
                    }
                    Object object = MxUtil.getAttribute(mServer, obj, method);
                    return object;
                }
                sig = params.signature;
                args = params.arguments;
            }
            Object object = mServer.invoke(obj, method, args, sig);
            return object;
        }
        catch (RemoteException e) {
            throw MxUtil.unreachable(config, e);
        }
        catch (MalformedObjectNameException e) {
            throw MxUtil.invalidObjectName(objectName, e);
        }
        catch (InstanceNotFoundException e) {
            throw MxUtil.objectNotFound(objectName, e);
        }
        catch (ReflectionException e) {
            throw MxUtil.error(objectName, e, method);
        }
        catch (IntrospectionException e) {
            throw MxUtil.error(objectName, e, method);
        }
        catch (MBeanException e) {
            throw MxUtil.error(objectName, e, method);
        }
        catch (IOException e) {
            throw MxUtil.error(objectName, e, method);
        }
        finally {
            MxUtil.close(connector, objectName, method);
        }
    }

    public static void close(JMXConnector connector) {
        if (connector != null) {
            try {
                connector.close();
            }
            catch (IOException e) {
                log.error((Object)("error closing connector: " + e), (Throwable)e);
            }
        }
    }

    public static void close(JMXConnector connector, String objectName, String method) {
        if (connector != null) {
            try {
                connector.close();
            }
            catch (IOException e) {
                log.error((Object)("error closing connector " + e + ".  objectName=" + objectName + "method=" + method), (Throwable)e);
            }
        }
    }

    private static class ConnectorInstance {
        JMXConnector connector;
        String username;
        String password;

        ConnectorInstance(JMXConnector connector, String username, String password) {
            this.connector = connector;
            this.username = username;
            this.password = password;
        }
    }

    private static class JMXConnectorKey {
        private final String url;
        private final String user;
        private final String pass;

        private JMXConnectorKey(String url, String user, String pass) {
            this.url = url;
            this.user = user;
            this.pass = pass;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (!(rhs instanceof JMXConnectorKey)) {
                return false;
            }
            JMXConnectorKey r = (JMXConnectorKey)rhs;
            return r.url.equals(this.url) && this.equals(r.user, this.user) && this.equals(r.pass, this.pass);
        }

        private boolean equals(String buf1, String buf2) {
            if (buf1 == buf2) {
                return true;
            }
            if (buf1 == null && buf2 != null || buf2 == null && buf1 != null) {
                return false;
            }
            return buf1.equals(buf2);
        }

        public int hashCode() {
            int rtn = this.url.hashCode() * 7;
            rtn += this.user != null ? this.user.hashCode() * 7 : 0;
            return rtn += this.pass != null ? this.pass.hashCode() * 7 : 0;
        }
    }
}

