/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.xmlparser.XmlAttr;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlAttrHandler;
import org.hyperic.util.xmlparser.XmlFilterHandler;
import org.hyperic.util.xmlparser.XmlTagEntryHandler;
import org.hyperic.util.xmlparser.XmlTagException;
import org.hyperic.util.xmlparser.XmlTagExitHandler;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

public abstract class BaseTag
implements XmlTagHandler,
XmlTagEntryHandler,
XmlTagExitHandler,
XmlFilterHandler,
XmlAttrHandler {
    static final String ATTR_NAME = "name";
    static final String ATTR_TYPE = "type";
    static final String ATTR_VERSION = "version";
    static final String ATTR_DESCRIPTION = "description";
    static final String ATTR_INCLUDE = "include";
    static final String ATTR_VALUE = "value";
    static final String ATTR_PLATFORM = "platform";
    static final String ATTR_CLASS = "class";
    static final String ATTR_RECURSIVE = "recursive";
    static final String ATTR_PATH = "path";
    static final String ATTR_FILTER = "filter";
    static final String TYPE_GLOBAL = "global";
    private static final String[] EMPTY_LIST = new String[0];
    private static final String[] EMPTY_ATTRS = new String[0];
    private static final XmlAttr[] EMTPY_JATTRS = new XmlAttr[0];
    private static final XmlTagInfo[] EMPTY_TAG_INFO = new XmlTagInfo[0];
    private XmlAttr[] attrs = EMTPY_JATTRS;
    Properties props = null;
    BaseTag parent;
    PluginData data;
    boolean collectMetrics = true;
    boolean collectHelp = true;

    BaseTag() {
    }

    BaseTag(BaseTag parent) {
        this.parent = parent;
        this.data = parent.data;
        this.collectMetrics = parent.collectMetrics;
        this.collectHelp = parent.collectHelp;
    }

    public abstract String getName();

    protected Log getLog() {
        return LogFactory.getLog((String)this.getClass().getName());
    }

    boolean isGlobalType() {
        return TYPE_GLOBAL.equals(this.getAttribute(ATTR_TYPE));
    }

    boolean isResourceParent() {
        if (this.parent == null) {
            return false;
        }
        return this.parent instanceof ResourceTag;
    }

    String getAttribute(String name, String defval) {
        if (this.props == null) {
            return defval;
        }
        return this.props.getProperty(name, defval);
    }

    String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    void setAttribute(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    public String[] getOptionalAttributes() {
        return EMPTY_ATTRS;
    }

    public String[] getRequiredAttributes() {
        return EMPTY_ATTRS;
    }

    public XmlAttr[] getAttributes() {
        int i;
        String[] optional = this.getOptionalAttributes();
        String[] required = this.getRequiredAttributes();
        if (optional.length == 0 && required.length == 0) {
            return EMTPY_JATTRS;
        }
        int idx = 0;
        this.attrs = new XmlAttr[required.length + optional.length];
        for (i = 0; i < required.length; ++i) {
            this.attrs[idx++] = new XmlAttr(required[i], 0);
        }
        for (i = 0; i < optional.length; ++i) {
            this.attrs[idx++] = new XmlAttr(optional[i], 1);
        }
        return this.attrs;
    }

    public void handleAttribute(int idx, String value) throws XmlAttrException {
        if (idx >= this.attrs.length) {
            throw new XmlAttrException(idx + " out of range " + this.attrs.length);
        }
        this.handleAttribute(this.attrs[idx].getName(), value);
    }

    public void handleAttribute(String name, String value) throws XmlAttrException {
        this.setAttribute(name, value);
    }

    public XmlTagInfo[] getSubTags() {
        return EMPTY_TAG_INFO;
    }

    public XmlTagInfo[] getMergedSubTags(XmlTagInfo[] base, XmlTagInfo add) {
        return this.getMergedSubTags(base, new XmlTagInfo[]{add});
    }

    public XmlTagInfo[] getMergedSubTags(XmlTagInfo[] base, XmlTagInfo[] add) {
        return (XmlTagInfo[])ArrayUtil.merge((Object[])base, (Object[])add, (Object[])new XmlTagInfo[0]);
    }

    public String filterAttrValue(XmlTagHandler tag, String name, String value) {
        return this.data.applyFilters(value);
    }

    public void enter() {
        this.startTag();
    }

    void startTag() {
    }

    public void exit() throws XmlTagException {
        this.endTag();
        if (this.props != null) {
            this.props.clear();
        }
    }

    void endTag() throws XmlTagException {
    }

    Object getScratch(String name) {
        return this.data.scratch.get(this.getName() + name);
    }

    void putScratch(String name, Object o) {
        this.data.scratch.put(this.getName() + name, o);
    }

    String[] getList(String s) {
        if (s == null) {
            return EMPTY_LIST;
        }
        List list = StringUtil.explode((String)s, (String)",");
        return list.toArray(EMPTY_LIST);
    }

    String[] getAttributeList(String name) {
        return this.getList(this.getAttribute(name));
    }
}

