/*
 * Decompiled with CFR 0.152.
 */
package org.novadeck.jxla.tools;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.novadeck.jxla.tools.Constants;

public class Utils {
    public static final String UA_IE = "msie";
    public static final String UA_OPERA = "opera";
    public static final String UA_KONQUEROR = "konqueror";
    public static final String UA_NETSCAPE = "mozilla";
    public static final String UA_LYNX = "lynx";
    public static final String UA_BOT = "bot";
    public static final String UA_PHP = "php";
    public static final String UA_NETBOX = "NetBox - NetGem";

    public static Pattern compileRE(String regexp) {
        try {
            return Constants.COMPILER.compile(regexp);
        }
        catch (MalformedPatternException e) {
            return null;
        }
    }

    public static boolean match(String str, Pattern p) {
        return Constants.MATCHER.matches(str, p);
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final boolean isComment(String s) {
        return Utils.isEmpty(s) || s.charAt(0) == '#';
    }

    public static String getUserAgent(String s) {
        if (Utils.isEmpty(s)) {
            return null;
        }
        if ((s = s.toLowerCase()).indexOf(UA_BOT) >= 0) {
            return "Bots";
        }
        if (s.indexOf(UA_IE) >= 0) {
            return "Internet Explorer";
        }
        if (s.indexOf(UA_OPERA) >= 0) {
            return "Opera";
        }
        if (s.indexOf(UA_KONQUEROR) >= 0) {
            return "Konqueror";
        }
        if (s.indexOf(UA_NETBOX) >= 0) {
            return "NetBox";
        }
        if (s.indexOf(UA_NETSCAPE) >= 0) {
            return "NetScape";
        }
        if (s.indexOf(UA_LYNX) >= 0) {
            return "Lynx";
        }
        if (s.indexOf(UA_PHP) >= 0) {
            return "PHP";
        }
        return "Unkown Browser";
    }

    public static final boolean canOutputHit(String uri) {
        if (uri == null) {
            return false;
        }
        return !uri.endsWith(".jpg") && !uri.endsWith(".png") && !uri.endsWith(".gif") && !uri.endsWith(".jpeg");
    }
}

