/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import org.hyperic.hibernate.dialect.HQDialect;
import org.hyperic.util.jdbc.DBUtil;

public class PostgreSQLDialect
extends org.hibernate.dialect.PostgreSQLDialect
implements HQDialect {
    private static final String logCtx = PostgreSQLDialect.class.getName();

    public boolean supportsDeferrableConstraints() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getCreateSequenceString(String sequenceName) {
        return new StringBuffer().append("create sequence ").append(sequenceName).append(" start ").append(10001).append(" increment 1 ").toString();
    }

    public String getOptimizeStmt(String table, int cost) {
        return "ANALYZE " + table;
    }

    public boolean supportsDuplicateInsertStmt() {
        return false;
    }

    public boolean supportsMultiInsertStmt() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Statement stmt, String tableName) throws SQLException {
        ResultSet rs;
        block3: {
            boolean bl;
            rs = null;
            try {
                String sql = "SELECT tablename from pg_tables WHERE lower(tablename) = lower('" + tableName + "')";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet((Object)logCtx, rs);
                throw throwable;
            }
            DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean viewExists(Statement stmt, String viewName) throws SQLException {
        ResultSet rs;
        block3: {
            boolean bl;
            rs = null;
            try {
                String sql = "SELECT viewname from pg_views WHERE lower(viewname) = lower('" + viewName + "')";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet((Object)logCtx, rs);
                throw throwable;
            }
            DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        return bl;
    }

    public String getLimitString(int num) {
        return "LIMIT " + num;
    }

    public String getLimitBuf(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql);
        buf.append(" LIMIT ");
        buf.append(limit);
        if (offset > 0) {
            buf.append(" offset ").append(offset);
        }
        return buf.toString();
    }

    public boolean usesSequenceGenerator() {
        return true;
    }

    public String getRegExSQL(String column, String regex, boolean ignoreCase, boolean invertMatch) {
        String op = " ~ ";
        if (ignoreCase && invertMatch) {
            op = " !~* ";
        } else if (ignoreCase) {
            op = " ~* ";
        } else if (invertMatch) {
            op = " !~ ";
        }
        return new StringBuffer().append(column).append(op).append(regex).toString();
    }

    public boolean useEamNumbers() {
        return true;
    }

    public int getMaxExpressions() {
        return -1;
    }

    public boolean supportsPLSQL() {
        return false;
    }

    public boolean useMetricUnion() {
        return false;
    }

    public String getMetricDataHint() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSchemaCreationTimestampInMillis(Statement stmt) throws SQLException {
        Long l;
        ResultSet rs = null;
        Date installDate = null;
        try {
            String[] sqls;
            for (String sql : sqls = new String[]{"select CTIME from EAM_AGENT_TYPE where ID = 1", "select CTIME from EAM_APPLICATION_TYPE where ID = 2", "select CTIME from EAM_RESOURCE_GROUP where ID = 0", "select CTIME from EAM_ALERT_DEFINITION where ID = 0", "select CTIME from EAM_ESCALATION where ID = 100"}) {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block5;
                Date date = new Date(rs.getLong(1));
                if (installDate == null) {
                    installDate = date;
                    break block5;
                }
                Calendar cal1 = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                cal1.setTime(installDate);
                cal2.setTime(date);
                if (cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6)) break block5;
                l = null;
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)logCtx, rs);
            throw throwable;
        }
        {
            block5: {
                DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
                return l;
            }
            continue;
        }
        DBUtil.closeResultSet((Object)logCtx, rs);
        return installDate.getTime();
    }

    public boolean analyzeDb() {
        return false;
    }

    public boolean supportsAsyncCommit() {
        return true;
    }

    public String getSetAsyncCommitStmt(boolean on) {
        return "set synchronous_commit to " + (on ? "on" : "off");
    }
}

