/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.hyperic.hq.context.Bootstrap;
import org.hyperic.util.jdbc.DBUtil;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class HQMultipleHiLoPerTableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog(HQMultipleHiLoPerTableGenerator.class);
    private LinkedList seqs = new LinkedList();
    public static final String ID_TABLE = "table";
    public static final String PK_COLUMN_NAME = "primary_key_column";
    public static final String PK_VALUE_NAME = "primary_key_value";
    public static final String VALUE_COLUMN_NAME = "value_column";
    public static final String PK_LENGTH_NAME = "primary_key_length";
    public static final String INITIAL_HI = "initial_hi";
    public static final int DEFAULT_INITIAL_HI = 0;
    private static final int DEFAULT_PK_LENGTH = 255;
    public static final String DEFAULT_TABLE = "hibernate_sequences";
    private static final String DEFAULT_PK_COLUMN = "sequence_name";
    private static final String DEFAULT_VALUE_COLUMN = "sequence_next_hi_value";
    private String tableName;
    private String pkColumnName;
    private String valueColumnName;
    private String query;
    private String insert;
    private String update;
    private String keyValue;
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private int initialHi;
    private Class returnClass;
    private int keySize;

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{new StringBuffer().append("create table ").append(this.tableName).append(" ( ").append(this.pkColumnName).append(" ").append(dialect.getTypeName(12, this.keySize, 0, 0)).append(",  ").append(this.valueColumnName).append(" ").append(dialect.getTypeName(4)).append(", ").append("primary key (" + this.pkColumnName + ") ").append(" ) ").toString()};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    protected Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        return this.updateSequence(conn);
    }

    private Integer updateSequence(Connection connection) throws SQLException {
        int result;
        int rows;
        do {
            log.debug((Object)this.query);
            PreparedStatement qps = connection.prepareStatement(this.query);
            Statement ips = null;
            try {
                ResultSet rs = qps.executeQuery();
                boolean isInitialized = rs.next();
                if (!isInitialized) {
                    result = 0;
                    ips = connection.prepareStatement(this.insert);
                    ips.setInt(1, this.initialHi);
                    ips.execute();
                } else {
                    result = rs.getInt(1);
                }
                rs.close();
            }
            catch (SQLException sqle) {
                log.error((Object)"could not read or init a hi value", (Throwable)sqle);
                throw sqle;
            }
            finally {
                if (ips != null) {
                    ips.close();
                }
                qps.close();
            }
            PreparedStatement ups = connection.prepareStatement(this.update);
            try {
                ups.setInt(1, result + 1);
                ups.setInt(2, result);
                rows = ups.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sqle);
                throw sqle;
            }
            finally {
                ups.close();
            }
        } while (rows == 0);
        return new Integer(result);
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        Number num;
        while (!this.numberIsValid(num = this._generate(session, obj))) {
        }
        return num;
    }

    private int executeInNewTransaction(TransactionTemplate transactionTemplate, final SessionImplementor session) {
        if (transactionTemplate != null) {
            return (Integer)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction(TransactionStatus status) {
                    try {
                        return HQMultipleHiLoPerTableGenerator.this.updateSequence(Bootstrap.getBean(DBUtil.class).getConnection());
                    }
                    catch (SQLException sqle) {
                        throw JDBCExceptionHelper.convert((SQLExceptionConverter)session.getFactory().getSQLExceptionConverter(), (SQLException)sqle, (String)"could not get or update next value", null);
                    }
                }
            });
        }
        return (Integer)this.doWorkInNewTransaction(session);
    }

    private synchronized Number _generate(SessionImplementor session, Object obj) throws HibernateException {
        TransactionTemplate transactionTemplate = null;
        if (Bootstrap.hasAppContext()) {
            transactionTemplate = new TransactionTemplate((PlatformTransactionManager)Bootstrap.getBean("transactionManager"));
            transactionTemplate.setPropagationBehavior(3);
        }
        if (this.maxLo < 1) {
            int val = this.executeInNewTransaction(transactionTemplate, session);
            if (val == 0) {
                val = this.executeInNewTransaction(transactionTemplate, session);
            }
            Number num = IdentifierGeneratorFactory.createNumber((long)val, (Class)this.returnClass);
            if (log.isTraceEnabled()) {
                log.trace((Object)((Object)((Object)this) + " created seq: " + this.keyValue + " / " + num));
            }
            return num;
        }
        if (this.lo > this.maxLo) {
            int hival = this.executeInNewTransaction(transactionTemplate, session);
            this.lo = hival == 0 ? 1 : 0;
            this.hi = hival * (this.maxLo + 1);
            log.debug((Object)("new hi value: " + hival));
        }
        Number num = IdentifierGeneratorFactory.createNumber((long)(this.hi + (long)this.lo++), (Class)this.returnClass);
        if (log.isTraceEnabled()) {
            log.trace((Object)((Object)((Object)this) + " created seq: " + this.keyValue + " / " + num));
        }
        return num;
    }

    private synchronized boolean numberIsValid(Number num) {
        if (this.seqs.contains(num)) {
            log.warn((Object)("sequence generator generated sequence " + this.keyValue + "/" + num + " which is a duplicate sequence, retrying"));
            return false;
        }
        this.seqs.add(num);
        while (this.seqs.size() >= 10) {
            this.seqs.removeLast();
        }
        return true;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.tableName = PropertiesHelper.getString((String)ID_TABLE, (Properties)params, (String)DEFAULT_TABLE);
        this.pkColumnName = PropertiesHelper.getString((String)PK_COLUMN_NAME, (Properties)params, (String)DEFAULT_PK_COLUMN);
        this.valueColumnName = PropertiesHelper.getString((String)VALUE_COLUMN_NAME, (Properties)params, (String)DEFAULT_VALUE_COLUMN);
        this.initialHi = PropertiesHelper.getInt((String)INITIAL_HI, (Properties)params, (int)0);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        this.keySize = PropertiesHelper.getInt((String)PK_LENGTH_NAME, (Properties)params, (int)255);
        this.keyValue = PropertiesHelper.getString((String)PK_VALUE_NAME, (Properties)params, (String)params.getProperty("target_table"));
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = Table.qualify((String)catalogName, (String)schemaName, (String)this.tableName);
        }
        this.query = "select " + this.valueColumnName + " from " + dialect.appendLockHint(LockMode.UPGRADE, this.tableName) + " where " + this.pkColumnName + " = '" + this.keyValue + "'" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.valueColumnName + " = ? where " + this.valueColumnName + " = ? and " + this.pkColumnName + " = '" + this.keyValue + "'";
        this.insert = "insert into " + this.tableName + "(" + this.pkColumnName + ", " + this.valueColumnName + ") " + "values('" + this.keyValue + "', ?)";
        this.maxLo = PropertiesHelper.getInt((String)MAX_LO, (Properties)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }
}

