/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfig {
    protected static final Log logger = LogFactory.getLog((String)AgentConfig.class.getName());
    private static final String DEV_URANDOM = "/dev/urandom";
    public static final String WORK_DIR = "work";
    public static final String JSW_PROP_AGENT_BUNDLE = "set.HQ_AGENT_BUNDLE";
    public static final String JSW_PROP_AGENT_ROLLBACK_BUNDLE = "set.HQ_AGENT_ROLLBACK_BUNDLE";
    public static final String JSW_PROP_AGENT_JAVA_HOME = "set.HQ_JAVA_HOME";
    public static final String PROP_LATHER_PROXYHOST = "lather.proxyHost";
    public static final String PROP_LATHER_PROXYPORT = "lather.proxyPort";
    public static final String IP_GLOBAL = "*";
    private static final String DEFAULT_PROXY_HOST = "";
    private static final int DEFAULT_PROXY_PORT = -1;
    private static final int DEFAULT_NOTIFY_UP_PORT = -1;
    private static final String DEFAULT_ENBALED_CIPHERS = "SSL_RSA_WITH_RC4_128_MD5,SSL_RSA_WITH_RC4_128_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA";
    public static final String PDK_DIR_KEY = "agent.pdkDir";
    public static final String PDK_LIB_DIR_KEY = "agent.pdkLibDir";
    public static final String PDK_PLUGIN_DIR_KEY = "agent.pdkPluginDir";
    public static final String PDK_WORK_DIR_KEY = "agent.pdkWorkDir";
    public static final String AGENT_BUNDLE_HOME = "agent.bundle.home";
    public static final String SSL_KEYSTORE_ALIAS = "agent.keystore.alias";
    public static final String DEFAULT_SSL_KEYSTORE_ALIAS = "hq";
    public static final String SSL_KEYSTORE_PATH = "agent.keystore.path";
    public static final String SSL_KEYSTORE_PASSWORD = "agent.keystore.password";
    public static final String SSL_KEYSTORE_ACCEPT_UNVERIFIED_CERT = "accept.unverified.certificates";
    public static final String DEFAULT_AGENT_KEY_FILE_NAME = "propEncKey";
    public static final String[] PROP_LISTENPORT;
    public static final String[] PROP_LISTENIP;
    public static final String[] PROP_STORAGEPROVIDER;
    public static final String[] PROP_STORAGEPROVIDERINFO;
    public static final String[] PROP_INSTALLHOME;
    public static final String[] PROP_BUNDLEHOME;
    public static final String[] PROP_TMPDIR;
    public static final String[] PROP_LOGDIR;
    public static final String[] PROP_DATADIR;
    public static final String[] PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT;
    public static final String[] PROP_KEYSTORE_PATH;
    public static final String[] PROP_KEYSTORE_PASSWORD;
    public static final String[] PROP_LIB_HANDLERS;
    public static final String[] PROP_LIB_HANDLERS_LIB;
    public static final String[] PROP_PDK_DIR;
    public static final String[] PROP_PDK_LIB_DIR;
    public static final String[] PROP_PDK_PLUGIN_DIR;
    public static final String[] PROP_PDK_WORK_DIR;
    public static final String[] PROP_PROXYHOST;
    public static final String[] PROP_PROXYPORT;
    private static final String HQ_PASS = "agent.setup.camPword";
    public static final String PERSISTED_CONTROL_RESPONSES_DIR;
    public static final String[] PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE;
    public static final String[] PROP_ENABLED_CIPHERS;
    public static final String PROP_PROPFILE = "agent.propFile";
    public static final String DEFAULT_AGENT_PROPFILE_NAME = "agent.properties";
    public static final String AGENT_CONF_DIR;
    public static final String DEFAULT_PROPFILE;
    public static final String ROLLBACK_PROPFILE = "agent.rollbackPropFile";
    public static final String DEFAULT_ROLLBACKPROPFILE;
    public static final String BUNDLE_PROPFILE;
    public static final String DEFAULT_AGENT_PROP_ENC_KEY_FILE_NAME = "agent.scu";
    public static final String DEFAULT_PROP_ENC_KEY_FILE;
    public static final Set<String> ENCRYPTED_PROP_KEYS;
    private static final String[][] propertyList;
    private int listenPort;
    private String listenIp;
    private int proxyPort = -1;
    private String proxyIp = "";
    private int notifyUpPort = -1;
    private String storageProvider;
    private String storageProviderInfo;
    private Properties bootProps;
    private String tokenFile;
    private String[] enabledCiphers = "SSL_RSA_WITH_RC4_128_MD5,SSL_RSA_WITH_RC4_128_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA".split(",");
    private File logdir;

    private AgentConfig() {
    }

    public static AgentConfig newInstance() {
        try {
            AgentConfig.checkAgentBundleHome();
            return AgentConfig.newInstance(AgentConfig.getDefaultProperties());
        }
        catch (AgentConfigException exc) {
            throw new AgentAssertionException("Default properties should always be proper");
        }
    }

    private static void checkAgentBundleHome() throws AgentConfigException {
        String bundleHome = System.getProperty(PROP_BUNDLEHOME[0]);
        if (bundleHome == null) {
            throw new AgentConfigException("No value for required system property " + PROP_BUNDLEHOME[0] + " provided!");
        }
        File bundleHomeDir = new File(bundleHome);
        if (!bundleHomeDir.isDirectory()) {
            throw new AgentConfigException("Invalid value " + PROP_BUNDLEHOME[1] + " for required system property " + PROP_BUNDLEHOME[0] + " provided!");
        }
    }

    public static void ensurePropertiesEncryption(String propertiesFileName) throws AgentConfigException {
        try {
            PropertyEncryptionUtil.ensurePropertiesEncryption((String)propertiesFileName, (String)DEFAULT_PROP_ENC_KEY_FILE, ENCRYPTED_PROP_KEYS);
        }
        catch (PropertyUtilException exc) {
            throw new AgentConfigException(exc.getMessage());
        }
    }

    private static synchronized boolean loadProps(Properties props, File propFile) throws AgentConfigException {
        Properties tmpProps;
        try {
            tmpProps = PropertyUtil.loadProperties((String)propFile.getPath());
        }
        catch (PropertyUtilException exc) {
            throw new AgentConfigException(exc.getMessage());
        }
        if (!propFile.exists()) {
            logger.error((Object)(propFile + " does not exist"));
            return false;
        }
        if (!propFile.canRead()) {
            logger.error((Object)("can't read " + propFile));
            return false;
        }
        try {
            String propEncKey = PropertyEncryptionUtil.getPropertyEncryptionKey((String)DEFAULT_PROP_ENC_KEY_FILE);
            Enumeration<?> propKeys = tmpProps.propertyNames();
            while (propKeys.hasMoreElements()) {
                String key = (String)propKeys.nextElement();
                String value = tmpProps.getProperty(key);
                if (value != null) {
                    if (SecurityUtil.isMarkedEncrypted((String)value)) {
                        value = SecurityUtil.decrypt((String)"PBEWithMD5AndDES", (String)propEncKey, (String)value);
                    }
                    value = value.trim();
                }
                props.put(key, value);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static File[] getPropertyFiles(String propsFile) {
        File deployerProps;
        String home;
        File homeAgentProperties;
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(propsFile));
        File bundleFile = new File(BUNDLE_PROPFILE);
        if (bundleFile.exists()) {
            files.add(bundleFile);
        }
        if ((homeAgentProperties = new File((home = System.getProperty("user.home")) + File.separator + ".hq" + File.separator + DEFAULT_AGENT_PROPFILE_NAME)).exists()) {
            files.add(homeAgentProperties);
        }
        if ((deployerProps = new File("deployer.properties")).exists()) {
            files.add(deployerProps);
        }
        return files.toArray(new File[files.size()]);
    }

    public static Properties getProperties(String propsFile) throws AgentConfigException {
        Properties useProps = new Properties();
        useProps.putAll((Map<?, ?>)AgentConfig.getDefaultProperties());
        File[] propFiles = AgentConfig.getPropertyFiles(propsFile);
        for (int i = 0; i < propFiles.length; ++i) {
            if (AgentConfig.loadProps(useProps, propFiles[i])) continue;
            throw new AgentConfigException("Failed to load: " + propFiles[i]);
        }
        PropertyUtil.expandVariables((Map)useProps);
        return useProps;
    }

    public static AgentConfig newInstance(String propsFile) throws IOException, AgentConfigException {
        AgentConfig.checkAgentBundleHome();
        Properties useProps = AgentConfig.getProperties(propsFile);
        return AgentConfig.newInstance(useProps);
    }

    public static AgentConfig newInstance(Properties props) throws AgentConfigException {
        AgentConfig res = new AgentConfig();
        res.useProperties(props);
        return res;
    }

    public static Properties getDefaultProperties() {
        Properties defaultProps = new Properties();
        for (String[] element : propertyList) {
            defaultProps.setProperty(element[0], element[1]);
        }
        return defaultProps;
    }

    public void useProperties(Properties appProps) throws AgentConfigException {
        boolean succeeded;
        this.bootProps = appProps;
        String listenPort = appProps.getProperty(PROP_LISTENPORT[0], PROP_LISTENPORT[1]);
        try {
            this.setListenPort(Integer.parseInt(listenPort));
        }
        catch (NumberFormatException exc) {
            throw new AgentConfigException(PROP_LISTENPORT[0] + " is not an integer");
        }
        String listenIp = appProps.getProperty(PROP_LISTENIP[0], PROP_LISTENIP[1]);
        this.setListenIp(listenIp);
        String proxyPort = appProps.getProperty(PROP_PROXYPORT[0], PROP_PROXYPORT[1]);
        try {
            int proxyPortInt = Integer.parseInt(proxyPort);
            if (proxyPortInt != -1) {
                this.setProxyPort(proxyPortInt);
            }
        }
        catch (NumberFormatException exc) {
            throw new AgentConfigException(PROP_PROXYPORT[0] + " is not an integer");
        }
        String proxyIp = appProps.getProperty(PROP_PROXYHOST[0], PROP_PROXYPORT[1]);
        this.setProxyIp(proxyIp);
        String[] enabledCiphers = appProps.getProperty(PROP_ENABLED_CIPHERS[0], PROP_ENABLED_CIPHERS[1]).split(",");
        this.setEnabledCiphers(enabledCiphers);
        String storageProvider = appProps.getProperty(PROP_STORAGEPROVIDER[0], PROP_STORAGEPROVIDER[1]);
        this.setStorageProvider(storageProvider);
        String storageProviderInfo = appProps.getProperty(PROP_STORAGEPROVIDERINFO[0], PROP_STORAGEPROVIDERINFO[1]);
        this.setStorageProviderInfo(storageProviderInfo);
        String dataDir = appProps.getProperty(PROP_DATADIR[0], PROP_DATADIR[1]);
        File dir = new File(dataDir);
        try {
            succeeded = FileUtil.makeDirs((File)dir, (int)3);
        }
        catch (InterruptedException e) {
            throw new AgentConfigException("creating data directory was interrupted");
        }
        if (!succeeded) {
            String parent = new File(dir.getAbsolutePath()).getParentFile().getAbsolutePath();
            throw new AgentConfigException("Error creating data directory: " + dir.getAbsolutePath() + "\nMake sure that the " + parent + " directory is " + "owned by user '" + System.getProperty("user.name") + "' and is not a read-only directory.");
        }
        this.tokenFile = appProps.getProperty("agent.tokenFile", dataDir + File.separator + "tokendata");
        String logDir = appProps.getProperty(PROP_LOGDIR[0], PROP_LOGDIR[1]);
        this.logdir = new File(logDir);
        try {
            succeeded = FileUtil.makeDirs((File)dir, (int)3);
        }
        catch (InterruptedException e) {
            throw new AgentConfigException("creating log directory was interrupted");
        }
        if (!succeeded) {
            String parent = new File(this.logdir.getAbsolutePath()).getParentFile().getAbsolutePath();
            throw new AgentConfigException("Error creating log directory: " + dir.getAbsolutePath() + "\nMake sure that the " + parent + " directory is " + "owned by user '" + System.getProperty("user.name") + "' and is not a read-only directory.");
        }
    }

    public File getLogDir() {
        return this.logdir;
    }

    public String getConfDirName() {
        return AGENT_CONF_DIR;
    }

    public void setListenPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.listenPort = port;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenIp(String ip) {
        this.listenIp = ip;
    }

    public String getListenIp() {
        return this.listenIp;
    }

    public void setProxyPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.proxyPort = port;
    }

    public boolean isProxyServerSet() {
        return this.getProxyPort() != -1 && !DEFAULT_PROXY_HOST.equals(this.getProxyIp());
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyIp(String ip) {
        this.proxyIp = ip;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public InetAddress getListenIpAsAddr() throws UnknownHostException {
        if (this.getListenIp().equals(IP_GLOBAL)) {
            return null;
        }
        return InetAddress.getByName(this.getListenIp());
    }

    public int getNotifyUpPort() {
        return this.notifyUpPort;
    }

    public void setNotifyUpPort(int port) throws AgentConfigException {
        this.verifyValidPortRange(port);
        this.notifyUpPort = port;
    }

    public void setStorageProvider(String storageProvider) {
        this.storageProvider = storageProvider;
    }

    public String getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProviderInfo(String info) {
        this.storageProviderInfo = info;
    }

    public String getStorageProviderInfo() {
        return this.storageProviderInfo;
    }

    public Properties getBootProperties() {
        return this.bootProps;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    private void verifyValidPortRange(int port) throws AgentConfigException {
        if (port < 1 || port > 65535) {
            throw new AgentConfigException("Invalid port (not in range 1->65535)");
        }
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public List<String> getEnabledCipherList() {
        return new ArrayList<String>(Arrays.asList(this.getEnabledCiphers()));
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        this.enabledCiphers = enabledCiphers;
    }

    static {
        if (new File(DEV_URANDOM).exists()) {
            System.setProperty("java.security.egd", "file:/dev/urandom");
        }
        PROP_LISTENPORT = new String[]{"agent.listenPort", Integer.toString(2144)};
        PROP_LISTENIP = new String[]{"agent.listenIp", IP_GLOBAL};
        PROP_STORAGEPROVIDER = new String[]{"agent.storageProvider", "org.hyperic.hq.agent.server.AgentDListProvider"};
        PROP_STORAGEPROVIDERINFO = new String[]{"agent.storageProvider.info", "${agent.dataDir}|m|1000|20|50"};
        PROP_INSTALLHOME = new String[]{"agent.install.home", System.getProperty("agent.install.home", System.getProperty("user.dir"))};
        PROP_BUNDLEHOME = new String[]{AGENT_BUNDLE_HOME, System.getProperty(AGENT_BUNDLE_HOME)};
        PROP_TMPDIR = new String[]{"agent.tmpDir", System.getProperty("agent.tmpDir", PROP_BUNDLEHOME[1] + "/tmp")};
        PROP_LOGDIR = new String[]{"agent.logDir", System.getProperty("agent.logDir", PROP_INSTALLHOME[1] + "/log")};
        PROP_DATADIR = new String[]{"agent.dataDir", System.getProperty("agent.dataDir", PROP_INSTALLHOME[1] + "/data")};
        PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT = new String[]{SSL_KEYSTORE_ACCEPT_UNVERIFIED_CERT, "true"};
        PROP_KEYSTORE_PATH = new String[]{SSL_KEYSTORE_PATH, PROP_DATADIR[1] + "/keystore"};
        PROP_KEYSTORE_PASSWORD = new String[]{SSL_KEYSTORE_PASSWORD, "storePW"};
        PROP_LIB_HANDLERS = new String[]{"agent.lib.handlers", PROP_BUNDLEHOME[1] + "/lib/handlers"};
        PROP_LIB_HANDLERS_LIB = new String[]{"agent.lib.handlers.lib", PROP_LIB_HANDLERS[1] + "/lib"};
        PROP_PDK_DIR = new String[]{PDK_DIR_KEY, System.getProperty(PDK_DIR_KEY, PROP_BUNDLEHOME[1] + "/pdk")};
        PROP_PDK_LIB_DIR = new String[]{PDK_LIB_DIR_KEY, System.getProperty(PDK_LIB_DIR_KEY, PROP_PDK_DIR[1] + "/lib")};
        PROP_PDK_PLUGIN_DIR = new String[]{PDK_PLUGIN_DIR_KEY, System.getProperty(PDK_PLUGIN_DIR_KEY, PROP_PDK_DIR[1] + "/plugins")};
        PROP_PDK_WORK_DIR = new String[]{PDK_WORK_DIR_KEY, System.getProperty(PDK_WORK_DIR_KEY, PROP_PDK_DIR[1] + "/" + WORK_DIR)};
        PROP_PROXYHOST = new String[]{"agent.proxyHost", DEFAULT_PROXY_HOST};
        PROP_PROXYPORT = new String[]{"agent.proxyPort", String.valueOf(-1)};
        PERSISTED_CONTROL_RESPONSES_DIR = PROP_DATADIR[1] + "/control_responses";
        PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE = new String[]{"agent.rollbackAgentBundleUpgrade", DEFAULT_PROXY_HOST};
        PROP_ENABLED_CIPHERS = new String[]{"agent.enabledCiphers", String.valueOf(DEFAULT_ENBALED_CIPHERS)};
        AGENT_CONF_DIR = PROP_INSTALLHOME[1] + "/conf/";
        DEFAULT_PROPFILE = AGENT_CONF_DIR + DEFAULT_AGENT_PROPFILE_NAME;
        DEFAULT_ROLLBACKPROPFILE = AGENT_CONF_DIR + "rollback.properties";
        BUNDLE_PROPFILE = AGENT_CONF_DIR + DEFAULT_AGENT_PROPFILE_NAME;
        DEFAULT_PROP_ENC_KEY_FILE = AGENT_CONF_DIR + DEFAULT_AGENT_PROP_ENC_KEY_FILE_NAME;
        ENCRYPTED_PROP_KEYS = new HashSet<String>();
        ENCRYPTED_PROP_KEYS.add(HQ_PASS);
        ENCRYPTED_PROP_KEYS.add(SSL_KEYSTORE_PASSWORD);
        propertyList = new String[][]{PROP_LISTENPORT, PROP_PROXYHOST, PROP_PROXYPORT, PROP_STORAGEPROVIDER, PROP_STORAGEPROVIDERINFO, PROP_INSTALLHOME, PROP_BUNDLEHOME, PROP_TMPDIR, PROP_LOGDIR, PROP_DATADIR, PROP_KEYSTORE_ACCEPT_UNVERIFIED_CERT, PROP_KEYSTORE_PATH, PROP_KEYSTORE_PASSWORD, PROP_LIB_HANDLERS, PROP_LIB_HANDLERS_LIB, PROP_PDK_DIR, PROP_PDK_LIB_DIR, PROP_PDK_PLUGIN_DIR, PROP_PDK_WORK_DIR, PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE, PROP_ENABLED_CIPHERS};
    }
}

