/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.commands;

import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.FileData;

public class AgentReceiveFileData_args
extends AgentRemoteValue {
    private static final String PROP_NFILES = "numFiles";
    private static final String PROP_FILENAME = "file.";
    private static final String PROP_FILESIZE = "size.";
    private static final String PROP_WRITETYPE = "type.";
    private static final String PROP_MD5SUM = "md5sum.";

    public AgentReceiveFileData_args() {
        this.setNumFiles(0);
    }

    public AgentReceiveFileData_args(AgentRemoteValue args) throws AgentRemoteException {
        this.setNumFiles(0);
        int nFiles = this.getNumFiles(args);
        for (int i = 0; i < nFiles; ++i) {
            FileData fileData = this.getFileData(args, i);
            this.addFileData(fileData);
        }
    }

    public void addFileData(FileData data) throws AgentRemoteException {
        int numFiles = this.getNumFiles();
        this.setFileName(numFiles, data.getDestFile());
        this.setFileSize(numFiles, data.getSize());
        this.setWriteType(numFiles, data.getWriteType());
        String md5sum = data.getMD5CheckSum();
        if (md5sum != null) {
            this.setMD5CheckSum(numFiles, md5sum);
        }
        this.setNumFiles(numFiles + 1);
    }

    public FileData getFile(int idx) throws AgentRemoteException {
        return this.getFileData(this, idx);
    }

    public int getNumFiles() throws AgentRemoteException {
        return this.getNumFiles(this);
    }

    private FileData getFileData(AgentRemoteValue args, int idx) throws AgentRemoteException {
        FileData fileData = new FileData(AgentReceiveFileData_args.getFileName(args, idx), AgentReceiveFileData_args.getFileSize(args, idx), AgentReceiveFileData_args.getWriteType(args, idx));
        String md5sum = AgentReceiveFileData_args.getMD5CheckSum(args, idx);
        if (md5sum != null) {
            fileData.setMD5CheckSum(md5sum);
        }
        return fileData;
    }

    private int getNumFiles(AgentRemoteValue val) throws AgentRemoteException {
        return val.getValueAsInt(PROP_NFILES);
    }

    private void setNumFiles(int numFiles) {
        this.setValue(PROP_NFILES, Integer.toString(numFiles));
    }

    private static String getFileName(AgentRemoteValue val, int idx) throws AgentRemoteException {
        return val.getValue(PROP_FILENAME + idx);
    }

    private void setFileName(int idx, String filename) {
        this.setValue(PROP_FILENAME + idx, filename);
    }

    private static long getFileSize(AgentRemoteValue val, int idx) throws AgentRemoteException {
        return val.getValueAsLong(PROP_FILESIZE + idx);
    }

    private void setFileSize(int idx, long size) {
        this.setValue(PROP_FILESIZE + idx, Long.toString(size));
    }

    private static int getWriteType(AgentRemoteValue val, int idx) throws AgentRemoteException {
        return val.getValueAsInt(PROP_WRITETYPE + idx);
    }

    private void setWriteType(int idx, int type) {
        this.setValue(PROP_WRITETYPE + idx, Integer.toString(type));
    }

    private static String getMD5CheckSum(AgentRemoteValue val, int idx) {
        return val.getValue(PROP_MD5SUM + idx);
    }

    private void setMD5CheckSum(int idx, String md5sum) {
        this.setValue(PROP_MD5SUM + idx, md5sum);
    }
}

