/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.product.MetricValue;

public class GetMeasurements_result
extends AgentRemoteValue {
    private static final String PARAM_NMEAS = "nmeas";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_RTIME = "rtime";
    private static final String PARAM_TYPE_EXC = "e";
    private static final String PARAM_TYPE_DOUBLE = "d";

    private void setup() {
        this.setNumMeasurements(0);
    }

    public GetMeasurements_result() {
        this.setup();
    }

    public GetMeasurements_result(AgentRemoteValue args) throws AgentRemoteException {
        this.setup();
        int nmeas = args.getValueAsInt(PARAM_NMEAS);
        for (int i = 0; i < nmeas; ++i) {
            String type = args.getValue(PARAM_TYPE + i);
            String val = args.getValue(PARAM_VALUE + i);
            if (type.equals(PARAM_TYPE_DOUBLE)) {
                Double dval;
                try {
                    dval = Double.valueOf(val);
                }
                catch (NumberFormatException exc) {
                    throw new AgentRemoteException("Invalid double value: " + val);
                }
                long rTime = args.getValueAsLong(PARAM_RTIME + i);
                MetricValue objVal = new MetricValue(dval, rTime);
                this.addMeasurement(objVal);
                continue;
            }
            if (type.equals(PARAM_TYPE_EXC)) {
                this.addException(val);
                continue;
            }
            throw new AgentRemoteException("Unknown measurement type: " + type);
        }
    }

    public int getNumMeasurements() {
        String val = this.getValue(PARAM_NMEAS);
        return Integer.parseInt(val);
    }

    private void setNumMeasurements(int newMeas) {
        super.setValue(PARAM_NMEAS, Integer.toString(newMeas));
    }

    public void addException(String excMsg) {
        int curMeas = this.getNumMeasurements();
        super.setValue(PARAM_TYPE + curMeas, PARAM_TYPE_EXC);
        super.setValue(PARAM_VALUE + curMeas, excMsg);
        super.setValue(PARAM_RTIME + curMeas, "0");
        this.setNumMeasurements(curMeas + 1);
    }

    public void addMeasurement(MetricValue val) {
        int curMeas = this.getNumMeasurements();
        super.setValue(PARAM_TYPE + curMeas, PARAM_TYPE_DOUBLE);
        super.setValue(PARAM_VALUE + curMeas, Double.toString(val.getValue()));
        super.setValue(PARAM_RTIME + curMeas, Long.toString(val.getTimestamp()));
        this.setNumMeasurements(curMeas + 1);
    }

    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public String getException(int measNum) {
        return this.getValue(PARAM_VALUE + measNum);
    }

    public MetricValue getMeasurement(int measNum) {
        String type = this.getType(measNum);
        if (type.equals(PARAM_TYPE_EXC)) {
            return null;
        }
        return new MetricValue(this.getValue(measNum, type), this.getTime(measNum));
    }

    private String getType(int measNum) {
        return this.getValue(PARAM_TYPE + measNum);
    }

    private Double getValue(int measNum, String type) {
        try {
            String qval = PARAM_VALUE + measNum;
            String val = this.getValue(qval);
            if (type.equals(PARAM_TYPE_DOUBLE)) {
                return Double.valueOf(val);
            }
            throw new AgentRemoteException("Unknown measurement type");
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed: " + exc);
        }
    }

    private long getTime(int measNum) {
        try {
            String qval = PARAM_RTIME + measNum;
            return this.getValueAsLong(qval);
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }
}

