/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.hyperic.hq.transport.util.InputStreamService;
import org.hyperic.hq.transport.util.StreamBuffer;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transporter.TransporterClient;

public class RemoteInputStream
extends InputStream
implements Externalizable {
    private static final long serialVersionUID = -2359924019799176338L;
    private InvokerLocator _sourceInvokerLocator;
    private String _streamId;
    private byte[] _currentBuffer;
    private int _currentBufferIdx;
    private InputStreamService _streamService;
    private boolean _closed;
    private boolean _isEOS;

    public RemoteInputStream() {
    }

    public RemoteInputStream(String streamId) {
        if (streamId == null) {
            throw new NullPointerException("stream id is null");
        }
        this._streamId = streamId;
    }

    public void setRemoteSourceInvokerLocator(InvokerLocator invokerLocator) {
        if (invokerLocator == null) {
            throw new NullPointerException("invoker locator is null");
        }
        this._sourceInvokerLocator = invokerLocator;
    }

    public int available() throws IOException {
        if (this._closed) {
            throw new IOException("stream is closed");
        }
        if (this._currentBuffer == null) {
            return 0;
        }
        return this._currentBuffer.length - this._currentBufferIdx;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException("stream is closed");
        }
        this._isEOS = this.retrieveNextBuffer();
        if (this._isEOS) {
            return -1;
        }
        int avail = this.available();
        int maxLen = len;
        if (avail > 0) {
            maxLen = Math.min(avail, len);
        }
        return super.read(b, off, maxLen);
    }

    public int read() throws IOException {
        if (this._closed) {
            throw new IOException("stream is closed");
        }
        this._isEOS = this.retrieveNextBuffer();
        if (this._isEOS) {
            return -1;
        }
        int c = 0xFF & this._currentBuffer[this._currentBufferIdx++];
        if (this._currentBufferIdx == this._currentBuffer.length) {
            this._currentBuffer = null;
        }
        return c;
    }

    private boolean retrieveNextBuffer() throws IOException {
        if (this._isEOS) {
            return true;
        }
        if (this._currentBuffer == null) {
            StreamBuffer nextBuffer = this.getInputStreamService().getNextBuffer(this._streamId);
            if (nextBuffer.isEOS()) {
                return true;
            }
            this._currentBuffer = nextBuffer.getBuffer();
            this._currentBufferIdx = 0;
        }
        return false;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._streamService != null) {
                TransporterClient.destroyTransporterClient((Object)this._streamService);
                this._streamService = null;
            }
            this._currentBuffer = null;
        }
    }

    public String getStreamId() {
        return this._streamId;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._streamId = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._streamId);
    }

    private InputStreamService getInputStreamService() throws IOException {
        if (this._streamService == null) {
            if (this._sourceInvokerLocator == null) {
                throw new IOException("remote source invoker locator was not set");
            }
            ClassLoader currentContext = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(InputStreamService.class.getClassLoader());
            try {
                this._streamService = (InputStreamService)TransporterClient.createTransporterClient((InvokerLocator)this._sourceInvokerLocator, InputStreamService.class);
            }
            catch (Exception e) {
                throw new IOException("Failed to connect to input stream service on remote source: " + e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentContext);
            }
        }
        return this._streamService;
    }
}

