/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.hyperic.util.security.MD5;

public class StreamBuffer
implements Externalizable {
    private boolean _isEOS;
    private byte[] _buffer;

    public StreamBuffer() {
    }

    private StreamBuffer(boolean isEOS, byte[] buffer) {
        this._isEOS = isEOS;
        this._buffer = buffer;
    }

    public static StreamBuffer newInstance(byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer must not be empty");
        }
        return new StreamBuffer(false, buffer);
    }

    public static StreamBuffer newEOSInstance() {
        return new StreamBuffer(true, new byte[0]);
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public boolean isEOS() {
        return this._isEOS;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._isEOS = in.readBoolean();
        int length = in.readInt();
        this._buffer = new byte[length];
        in.readFully(this._buffer);
        if (!this._isEOS) {
            String expectedChecksum = in.readUTF();
            MD5 checksum = new MD5();
            checksum.add(this._buffer);
            String actualChecksum = checksum.getDigestString();
            if (!expectedChecksum.equals(actualChecksum)) {
                throw new IOException("stream buffer checksum failed; expected=" + expectedChecksum + "; actual=" + actualChecksum);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._isEOS);
        out.writeInt(this._buffer.length);
        out.write(this._buffer);
        if (!this._isEOS) {
            MD5 checksum = new MD5();
            checksum.add(this._buffer);
            out.writeUTF(checksum.getDigestString());
        }
    }
}

