/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import org.hyperic.hq.hqapi1.types.AlertAction;
import org.hyperic.hq.hqapi1.types.AlertActionConfig;
import org.hyperic.hq.hqapi1.types.AlertCondition;
import org.hyperic.hq.hqapi1.types.AlertDefinition;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.Role;
import org.hyperic.hq.hqapi1.types.User;

public class AlertDefinitionBuilder {
    private static AlertCondition createBaseCondition(boolean required) {
        AlertCondition c = new AlertCondition();
        c.setRequired(required);
        return c;
    }

    public static AlertCondition createThresholdCondition(boolean required, String metric, AlertComparator comparator, double threshold) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.THRESHOLD.getType());
        c.setThresholdMetric(metric);
        c.setThresholdComparator(comparator.getComparator());
        c.setThresholdValue(threshold);
        return c;
    }

    public static AlertCondition createBaselineCondition(boolean required, String metric, AlertComparator comparator, double percentage, AlertBaseline type) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.BASELINE.getType());
        c.setBaselineMetric(metric);
        c.setBaselineComparator(comparator.getComparator());
        c.setBaselinePercentage(percentage);
        c.setBaselineType(type.getBaselineType());
        return c;
    }

    public static AlertCondition createControlCondition(boolean required, String action, AlertControlStatus status) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.CONTROL.getType());
        c.setControlAction(action);
        c.setControlStatus(status.getControlStatus());
        return c;
    }

    public static AlertCondition createChangeCondition(boolean required, String metric) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.METRIC_CHANGE.getType());
        c.setMetricChange(metric);
        return c;
    }

    public static AlertCondition createRecoveryCondition(boolean required, AlertDefinition recover) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.RECOVERY.getType());
        c.setRecover(recover.getName());
        return c;
    }

    public static AlertCondition createPropertyCondition(boolean required, String property) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.CUSTOM_PROP.getType());
        c.setProperty(property);
        return c;
    }

    public static AlertCondition createLogCondition(boolean required, AlertLogLevel logLevel, String matches) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.LOG.getType());
        c.setLogLevel(logLevel.getLevel());
        c.setLogMatches(matches);
        return c;
    }

    public static AlertCondition createConfigCondition(boolean required, String matches) {
        AlertCondition c = AlertDefinitionBuilder.createBaseCondition(required);
        c.setType(AlertConditionType.CONFIG_CHANGE.getType());
        c.setConfigMatch(matches);
        return c;
    }

    public static AlertAction createScriptAction(String script) {
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.control.ScriptAction");
        AlertActionConfig cfg = new AlertActionConfig();
        cfg.setKey("script");
        cfg.setValue(script);
        a.getAlertActionConfig().add(cfg);
        return a;
    }

    public static AlertAction createControlAction(Resource r, String action) {
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.control.ControlAction");
        AlertActionConfig resourceCfg = new AlertActionConfig();
        resourceCfg.setKey("resourceId");
        resourceCfg.setValue(Integer.toString(r.getId()));
        AlertActionConfig actionCfg = new AlertActionConfig();
        actionCfg.setKey("action");
        actionCfg.setValue(action);
        a.getAlertActionConfig().add(resourceCfg);
        a.getAlertActionConfig().add(actionCfg);
        return a;
    }

    public static AlertAction createOpenNMSAction(String server, int port) {
        AlertAction a = new AlertAction();
        a.setClassName("org.hyperic.hq.bizapp.server.action.integrate.OpenNMSAction");
        AlertActionConfig serverCfg = new AlertActionConfig();
        serverCfg.setKey("server");
        serverCfg.setValue(server);
        AlertActionConfig portCfg = new AlertActionConfig();
        portCfg.setKey("port");
        portCfg.setValue(Integer.toString(port));
        a.getAlertActionConfig().add(serverCfg);
        a.getAlertActionConfig().add(portCfg);
        return a;
    }

    public static AlertAction createSnmpAction(String address, String notificationMechanism, String oid, String variableBindings) {
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.alert.SnmpAction");
        AlertActionConfig addressCfg = new AlertActionConfig();
        addressCfg.setKey("address");
        addressCfg.setValue(address);
        AlertActionConfig notificationMechanismCfg = new AlertActionConfig();
        notificationMechanismCfg.setKey("snmpNotificationMechanism");
        notificationMechanismCfg.setValue(notificationMechanism);
        AlertActionConfig oidCfg = new AlertActionConfig();
        oidCfg.setKey("oid");
        oidCfg.setValue(oid);
        AlertActionConfig varbindsCfg = new AlertActionConfig();
        varbindsCfg.setKey("variableBindings");
        varbindsCfg.setValue(variableBindings);
        a.getAlertActionConfig().add(addressCfg);
        a.getAlertActionConfig().add(notificationMechanismCfg);
        a.getAlertActionConfig().add(oidCfg);
        a.getAlertActionConfig().add(varbindsCfg);
        return a;
    }

    public static void addEmailAction(AlertDefinition d, User[] users) {
        for (AlertAction a : d.getAlertAction()) {
            if (!a.getClassName().equals("com.hyperic.hq.bizapp.server.action.email.EmailAction")) continue;
            boolean actionExists = false;
            AlertActionConfig names = null;
            for (AlertActionConfig cfg : a.getAlertActionConfig()) {
                if (cfg.getKey().equals("notifyType") && cfg.getValue().equals("users")) {
                    actionExists = true;
                }
                if (!cfg.getKey().equals("names")) continue;
                names = cfg;
            }
            if (!actionExists || names == null) continue;
            StringBuffer nameList = new StringBuffer();
            for (int i = 0; i < users.length; ++i) {
                nameList.append(users[i].getName());
                if (i + 1 >= users.length) continue;
                nameList.append(",");
            }
            names.setValue(nameList.toString());
            return;
        }
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.email.EmailAction");
        AlertActionConfig type = new AlertActionConfig();
        type.setKey("notifyType");
        type.setValue("users");
        StringBuffer nameList = new StringBuffer();
        for (int i = 0; i < users.length; ++i) {
            nameList.append(users[i].getName());
            if (i + 1 >= users.length) continue;
            nameList.append(",");
        }
        AlertActionConfig names = new AlertActionConfig();
        names.setKey("names");
        names.setValue(nameList.toString());
        a.getAlertActionConfig().add(type);
        a.getAlertActionConfig().add(names);
        d.getAlertAction().add(a);
    }

    public static void addEmailAction(AlertDefinition d, Role[] roles) {
        for (AlertAction a : d.getAlertAction()) {
            if (!a.getClassName().equals("com.hyperic.hq.bizapp.server.action.email.EmailAction")) continue;
            boolean actionExists = false;
            AlertActionConfig names = null;
            for (AlertActionConfig cfg : a.getAlertActionConfig()) {
                if (cfg.getKey().equals("notifyType") && cfg.getValue().equals("roles")) {
                    actionExists = true;
                }
                if (!cfg.getKey().equals("names")) continue;
                names = cfg;
            }
            if (!actionExists || names == null) continue;
            StringBuffer nameList = new StringBuffer();
            for (int i = 0; i < roles.length; ++i) {
                nameList.append(roles[i].getName());
                if (i + 1 >= roles.length) continue;
                nameList.append(",");
            }
            names.setValue(nameList.toString());
            return;
        }
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.email.EmailAction");
        AlertActionConfig type = new AlertActionConfig();
        type.setKey("notifyType");
        type.setValue("roles");
        StringBuffer nameList = new StringBuffer();
        for (int i = 0; i < roles.length; ++i) {
            nameList.append(roles[i].getName());
            if (i + 1 >= roles.length) continue;
            nameList.append(",");
        }
        AlertActionConfig names = new AlertActionConfig();
        names.setKey("names");
        names.setValue(nameList.toString());
        a.getAlertActionConfig().add(type);
        a.getAlertActionConfig().add(names);
        d.getAlertAction().add(a);
    }

    public static void addEmailAction(AlertDefinition d, String[] otherRecipients) {
        for (AlertAction a : d.getAlertAction()) {
            if (!a.getClassName().equals("com.hyperic.hq.bizapp.server.action.email.EmailAction")) continue;
            boolean actionExists = false;
            AlertActionConfig names = null;
            for (AlertActionConfig cfg : a.getAlertActionConfig()) {
                if (cfg.getKey().equals("notifyType") && cfg.getValue().equals("email")) {
                    actionExists = true;
                }
                if (!cfg.getKey().equals("names")) continue;
                names = cfg;
            }
            if (!actionExists || names == null) continue;
            StringBuffer nameList = new StringBuffer();
            for (int i = 0; i < otherRecipients.length; ++i) {
                nameList.append(otherRecipients[i]);
                if (i + 1 >= otherRecipients.length) continue;
                nameList.append(",");
            }
            names.setValue(nameList.toString());
            return;
        }
        AlertAction a = new AlertAction();
        a.setClassName("com.hyperic.hq.bizapp.server.action.email.EmailAction");
        AlertActionConfig type = new AlertActionConfig();
        type.setKey("notifyType");
        type.setValue("email");
        StringBuffer nameList = new StringBuffer();
        for (int i = 0; i < otherRecipients.length; ++i) {
            nameList.append(otherRecipients[i]);
            if (i + 1 >= otherRecipients.length) continue;
            nameList.append(",");
        }
        AlertActionConfig names = new AlertActionConfig();
        names.setKey("names");
        names.setValue(nameList.toString());
        a.getAlertActionConfig().add(type);
        a.getAlertActionConfig().add(names);
        d.getAlertAction().add(a);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertLogLevel {
        ANY("ANY"),
        ERROR("ERR"),
        WARN("WRN"),
        INFO("INF"),
        DEBUG("DGB");

        private final String _level;

        private AlertLogLevel(String level) {
            this._level = level;
        }

        public String getLevel() {
            return this._level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertControlStatus {
        COMPLETED("Completed"),
        FAILED("Failed"),
        IN_PROGRESS("In Progress");

        private final String _controlStatus;

        private AlertControlStatus(String controlStatus) {
            this._controlStatus = controlStatus;
        }

        public String getControlStatus() {
            return this._controlStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertBaseline {
        MEAN("mean"),
        MIN("min"),
        MAX("max");

        private final String _baselineType;

        private AlertBaseline(String baselineType) {
            this._baselineType = baselineType;
        }

        public String getBaselineType() {
            return this._baselineType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertComparator {
        EQUALS("="),
        NOT_EQUALS("!="),
        LESS_THAN("<"),
        GREATER_THAN(">");

        private final String _comparator;

        private AlertComparator(String comparator) {
            this._comparator = comparator;
        }

        public String getComparator() {
            return this._comparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertPriority {
        HIGH(3),
        MEDIUM(2),
        LOW(1);

        private final int _priority;

        private AlertPriority(int priority) {
            this._priority = priority;
        }

        public int getPriority() {
            return this._priority;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlertConditionType {
        THRESHOLD(1),
        BASELINE(2),
        CONTROL(3),
        METRIC_CHANGE(4),
        RECOVERY(5),
        CUSTOM_PROP(6),
        LOG(7),
        CONFIG_CHANGE(8);

        private final int _type;

        private AlertConditionType(int type) {
            this._type = type;
        }

        public int getType() {
            return this._type;
        }
    }
}

