/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.EventsResponse;
import org.hyperic.hq.hqapi1.types.Resource;

public class EventApi
extends BaseApi {
    EventApi(HQConnection conn) {
        super(conn);
    }

    public EventsResponse findEvents(Resource r, long begin, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("begin", new String[]{Long.toString(begin)});
        params.put("end", new String[]{Long.toString(end)});
        params.put("resourceId", new String[]{Integer.toString(r.getId())});
        return this.doGet("event/findByResource.hqu", params, new XmlResponseHandler<EventsResponse>(EventsResponse.class));
    }

    public EventsResponse findEvents(long begin, long end, EventType type, EventStatus status, int count) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("begin", new String[]{Long.toString(begin)});
        params.put("end", new String[]{Long.toString(end)});
        params.put("type", new String[]{type != null ? type.getType() : null});
        params.put("status", new String[]{status != null ? status.getStatus() : null});
        params.put("count", new String[]{Integer.toString(count)});
        return this.doGet("event/find.hqu", params, new XmlResponseHandler<EventsResponse>(EventsResponse.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ANY(null),
        ALERT("org.hyperic.hq.events.AlertFiredEvent"),
        BASELINE("org.hyperic.hq.measurement.ext.BaselineChangeEvent"),
        CPROP("org.hyperic.hq.appdef.shared.CPropChangeEvent"),
        CLONE("org.hyperic.hq.events.CloningEvent"),
        CONTROL("org.hyperic.hq.control.ControlEvent"),
        ESCALATION("org.hyperic.hq.escalation.EscalationEvent"),
        MAINTENANCE("org.hyperic.hq.events.MaintenanceEvent"),
        LOG("org.hyperic.hq.measurement.shared.ResourceLogEvent");

        private final String _type;

        private EventType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventStatus {
        ANY("ANY"),
        ERROR("ERR"),
        WARN("WRN"),
        INFO("INF"),
        DEBUG("DBG");

        private final String _status;

        private EventStatus(String status) {
            this._status = status;
        }

        public String getStatus() {
            return this._status;
        }
    }
}

