/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.Metric;
import org.hyperic.hq.hqapi1.types.MetricDataResponse;
import org.hyperic.hq.hqapi1.types.MetricResponse;
import org.hyperic.hq.hqapi1.types.MetricTemplate;
import org.hyperic.hq.hqapi1.types.MetricTemplateResponse;
import org.hyperic.hq.hqapi1.types.MetricTemplatesRequest;
import org.hyperic.hq.hqapi1.types.MetricTemplatesResponse;
import org.hyperic.hq.hqapi1.types.MetricsDataResponse;
import org.hyperic.hq.hqapi1.types.MetricsRequest;
import org.hyperic.hq.hqapi1.types.MetricsRescheduleRequest;
import org.hyperic.hq.hqapi1.types.MetricsResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourcePrototype;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricApi
extends BaseApi {
    MetricApi(HQConnection conn) {
        super(conn);
    }

    public MetricsResponse getMetrics(Resource resource) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resource.getId())});
        return this.doGet("metric/getMetrics.hqu", params, new XmlResponseHandler<MetricsResponse>(MetricsResponse.class));
    }

    public MetricsResponse getEnabledMetrics(Resource resource) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resource.getId())});
        params.put("enabled", new String[]{Boolean.toString(true)});
        return this.doGet("metric/getMetrics.hqu", params, new XmlResponseHandler<MetricsResponse>(MetricsResponse.class));
    }

    public MetricsResponse getMetrics(Resource resource, boolean enabled) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resource.getId())});
        params.put("enabled", new String[]{Boolean.toString(enabled)});
        return this.doGet("metric/getMetrics.hqu", params, new XmlResponseHandler<MetricsResponse>(MetricsResponse.class));
    }

    public MetricResponse getMetric(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("metric/getMetric.hqu", params, new XmlResponseHandler<MetricResponse>(MetricResponse.class));
    }

    public StatusResponse syncMetrics(List<Metric> metrics) throws IOException {
        MetricsRequest syncRequest = new MetricsRequest();
        syncRequest.getMetric().addAll(metrics);
        return this.doPost("metric/syncMetrics.hqu", syncRequest, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public MetricTemplateResponse getMetricTemplate(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("metric/getMetricTemplate.hqu", params, new XmlResponseHandler<MetricTemplateResponse>(MetricTemplateResponse.class));
    }

    public MetricTemplatesResponse getMetricTemplates(ResourcePrototype prototype) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("prototype", new String[]{prototype.getName()});
        return this.doGet("metric/getTemplates.hqu", params, new XmlResponseHandler<MetricTemplatesResponse>(MetricTemplatesResponse.class));
    }

    public StatusResponse syncMetricTemplates(List<MetricTemplate> templates) throws IOException {
        MetricTemplatesRequest syncRequest = new MetricTemplatesRequest();
        syncRequest.getMetricTemplate().addAll(templates);
        return this.doPost("metric/syncTemplates.hqu", syncRequest, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public MetricDataResponse getMetricData(int metricId, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("metricId", new String[]{Integer.toString(metricId)});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metric/getData.hqu", params, new XmlResponseHandler<MetricDataResponse>(MetricDataResponse.class));
    }

    public MetricsDataResponse getMetricData(int groupId, int templateId, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("groupId", new String[]{Integer.toString(groupId)});
        params.put("templateId", new String[]{Integer.toString(templateId)});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metric/getGroupData.hqu", params, new XmlResponseHandler<MetricsDataResponse>(MetricsDataResponse.class));
    }

    public MetricsDataResponse getMetricData(int[] resourceIds, int templateId, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            ids[i] = Integer.toString(resourceIds[i]);
        }
        params.put("ids", ids);
        params.put("templateId", new String[]{Integer.toString(templateId)});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metric/getResourceData.hqu", params, new XmlResponseHandler<MetricsDataResponse>(MetricsDataResponse.class));
    }

    private List<Resource> getFlattenResources(List<Resource> resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : resources) {
            result.add(r);
            if (r.getResource().size() <= 0) continue;
            result.addAll(this.getFlattenResources(r.getResource()));
        }
        return result;
    }

    public StatusResponse reschedule(List<Resource> resources) throws IOException {
        List<Resource> flattened = this.getFlattenResources(resources);
        MetricsRescheduleRequest request = new MetricsRescheduleRequest();
        request.getResource().addAll(flattened);
        return this.doPost("metric/reschedule.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

