/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.hq.hqapi1.ResponseHandler;
import org.hyperic.hq.hqapi1.XmlUtil;
import org.hyperic.hq.hqapi1.types.ResponseStatus;
import org.hyperic.hq.hqapi1.types.ServiceError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResponseHandler<T>
implements ResponseHandler<T> {
    private static Log _log = LogFactory.getLog(XmlResponseHandler.class);
    private Class<T> clazz;

    public XmlResponseHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T handleResponse(HttpResponse response) throws IOException {
        int responseCode = response.getStatusLine().getStatusCode();
        switch (responseCode) {
            case 200: {
                InputStream is = response.getEntity().getContent();
                try {
                    return XmlUtil.deserialize(this.clazz, is);
                }
                catch (JAXBException e) {
                    ServiceError error = new ServiceError();
                    error.setErrorCode("UnexpectedError");
                    error.setReasonText("Unable to deserialize result");
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Unable to deserialize result", (Throwable)e);
                    }
                    return this.getErrorResponse(error);
                }
            }
            case 401: {
                ServiceError error = new ServiceError();
                error.setErrorCode("LoginFailure");
                error.setReasonText("The given username and password could not be validated");
                return this.getErrorResponse(error);
            }
        }
        ServiceError error = new ServiceError();
        error.setErrorCode("UnexpectedError");
        error.setReasonText("An unexpected error occurred");
        return this.getErrorResponse(error);
    }

    @Override
    public T getErrorResponse(ServiceError error) throws IOException {
        try {
            T ret = this.clazz.newInstance();
            Method setResponse = this.clazz.getMethod("setStatus", ResponseStatus.class);
            setResponse.invoke(ret, new Object[]{ResponseStatus.FAILURE});
            Method setError = this.clazz.getMethod("setError", ServiceError.class);
            setError.invoke(ret, error);
            return ret;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Error generating error response", (Throwable)e);
            }
            throw new IOException("Error generating Error response");
        }
    }
}

