/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1.examples;

import java.util.Date;
import java.util.List;
import org.hyperic.hq.hqapi1.HQApi;
import org.hyperic.hq.hqapi1.MetricApi;
import org.hyperic.hq.hqapi1.ResourceApi;
import org.hyperic.hq.hqapi1.types.DataPoint;
import org.hyperic.hq.hqapi1.types.MetricData;
import org.hyperic.hq.hqapi1.types.MetricTemplate;
import org.hyperic.hq.hqapi1.types.MetricTemplatesResponse;
import org.hyperic.hq.hqapi1.types.MetricsDataResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourcePrototypeResponse;
import org.hyperic.hq.hqapi1.types.ResourcesResponse;
import org.hyperic.hq.hqapi1.types.Response;
import org.hyperic.hq.hqapi1.types.ResponseStatus;

public class MetricDataExampleMuliResourceSingleMetric {
    private static final String TYPE = "FileServer Mount";
    private static final String ALIAS = "UsePercent";
    private static final long RANGE = 28800000L;

    private static void checkSuccess(Response r) {
        if (!r.getStatus().equals((Object)ResponseStatus.SUCCESS)) {
            System.err.println("API error: " + r.getError().getReasonText());
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        HQApi api = new HQApi("localhost", 7443, true, "hqadmin", "hqadmin");
        ResourceApi resourceApi = api.getResourceApi();
        MetricApi metricApi = api.getMetricApi();
        ResourcePrototypeResponse prototypeResponse = resourceApi.getResourcePrototype(TYPE);
        MetricDataExampleMuliResourceSingleMetric.checkSuccess(prototypeResponse);
        MetricTemplate t = null;
        MetricTemplatesResponse templatesResponse = metricApi.getMetricTemplates(prototypeResponse.getResourcePrototype());
        MetricDataExampleMuliResourceSingleMetric.checkSuccess(templatesResponse);
        for (MetricTemplate tmpl : templatesResponse.getMetricTemplate()) {
            if (!tmpl.getAlias().equals(ALIAS)) continue;
            t = tmpl;
        }
        if (t == null) {
            System.err.println("Unable to find alias UsePercent for type FileServer Mount");
            return;
        }
        ResourcesResponse resourcesResponse = resourceApi.getResources(prototypeResponse.getResourcePrototype(), false, false);
        MetricDataExampleMuliResourceSingleMetric.checkSuccess(resourcesResponse);
        List<Resource> resources = resourcesResponse.getResource();
        System.out.println("Found " + resources.size() + " matching resources.");
        int[] resourceIds = new int[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            resourceIds[i] = resources.get(i).getId();
        }
        long end = System.currentTimeMillis();
        MetricsDataResponse dataResponse = metricApi.getMetricData(resourceIds, t.getId(), end - 28800000L, end);
        MetricDataExampleMuliResourceSingleMetric.checkSuccess(dataResponse);
        for (MetricData d : dataResponse.getMetricData()) {
            System.out.println("Data for resource " + d.getResourceName() + " metric " + d.getMetricName());
            for (DataPoint p : d.getDataPoint()) {
                System.out.println("  time=" + new Date(p.getTimestamp()).toString() + " data=" + p.getValue());
            }
        }
    }
}

