/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.GFVersionInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberDetector
extends ServerDetector
implements AutoServerDetector {
    private static final Log log = LogFactory.getLog(MemberDetector.class);
    public static final String PROP_PREFIX = "GemFire.autodiscovery.";
    public static final String PROP_INCLUDES = "includeInstances";
    public static final String PROP_EXCLUDES = "excludeInstances";
    public static final String[] DEFAULT_INCLUDES = new String[]{"vFabric GemFire Cache Server 6.6 Cache Performance", "vFabric GemFire Cache Server 6.6 Cache Server", "vFabric GemFire Cache Server 6.6 Disk Store", "vFabric GemFire Cache Server 6.6 Function", "vFabric GemFire Cache Server 6.6 Function Service", "vFabric GemFire Cache Server 6.6 Partitioned Region", "vFabric GemFire Cache Server 6.6 Region", "vFabric GemFire Cache Server 6.6 Resource Manager", "vFabric GemFire Cache Server 6.6 VM Stats", "vFabric GemFire Gateway Hub 6.6 Cache Performance", "vFabric GemFire Gateway Hub 6.6 Cache Server", "vFabric GemFire Gateway Hub 6.6 Disk Store", "vFabric GemFire Gateway Hub 6.6 Gateway Hub Statistics", "vFabric GemFire Gateway Hub 6.6 Gateway Statistics", "vFabric GemFire Gateway Hub 6.6 Partitioned Region", "vFabric GemFire Gateway Hub 6.6 Region", "vFabric GemFire Gateway Hub 6.6 VM Stats", "vFabric GemFire Gateway Hub 6.6 Pool Stats", "vFabric GemFire Cache Server 6.5 Cache Performance", "vFabric GemFire Cache Server 6.5 Cache Server", "vFabric GemFire Cache Server 6.5 Disk Store", "vFabric GemFire Cache Server 6.5 Function", "vFabric GemFire Cache Server 6.5 Function Service", "vFabric GemFire Cache Server 6.5 Partitioned Region", "vFabric GemFire Cache Server 6.5 Region", "vFabric GemFire Cache Server 6.5 Resource Manager", "vFabric GemFire Cache Server 6.5 VM Stats", "vFabric GemFire Gateway Hub 6.5 Cache Performance", "vFabric GemFire Gateway Hub 6.5 Cache Server", "vFabric GemFire Gateway Hub 6.5 Disk Store", "vFabric GemFire Gateway Hub 6.5 Gateway Hub Statistics", "vFabric GemFire Gateway Hub 6.5 Gateway Statistics", "vFabric GemFire Gateway Hub 6.5 Partitioned Region", "vFabric GemFire Gateway Hub 6.5 Region", "vFabric GemFire Gateway Hub 6.5 VM Stats", "vFabric GemFire Gateway Hub 6.5 Pool Stats", "vFabric GemFire Cache Server 6.0 Cache Performance", "vFabric GemFire Cache Server 6.0 Cache Server", "vFabric GemFire Cache Server 6.0 Disk Store", "vFabric GemFire Cache Server 6.0 Function", "vFabric GemFire Cache Server 6.0 Function Service", "vFabric GemFire Cache Server 6.0 Partitioned Region", "vFabric GemFire Cache Server 6.0 Region", "vFabric GemFire Cache Server 6.0 Resource Manager", "vFabric GemFire Cache Server 6.0 VM Stats", "vFabric GemFire Gateway Hub 6.0 Cache Performance", "vFabric GemFire Gateway Hub 6.0 Cache Server", "vFabric GemFire Gateway Hub 6.0 Disk Store", "vFabric GemFire Gateway Hub 6.0 Gateway Hub Statistics", "vFabric GemFire Gateway Hub 6.0 Gateway Statistics", "vFabric GemFire Gateway Hub 6.0 Partitioned Region", "vFabric GemFire Gateway Hub 6.0 Region", "vFabric GemFire Gateway Hub 6.0 VM Stats", "vFabric GemFire Gateway Hub 6.5 Pool Stats", "vFabric GemFire Application Peer 6.0 Distribution Statistics", "vFabric GemFire Application Peer 6.0 Function", "vFabric GemFire Application Peer 6.0 Function Service", "vFabric GemFire Application Peer 6.0 VM Stats", "vFabric GemFire Application Peer 6.5 Distribution Statistics", "vFabric GemFire Application Peer 6.5 Function", "vFabric GemFire Application Peer 6.5 Function Service", "vFabric GemFire Application Peer 6.5 VM Stats", "vFabric GemFire Application Peer 6.6 Distribution Statistics", "vFabric GemFire Application Peer 6.6 Function", "vFabric GemFire Application Peer 6.6 Function Service", "vFabric GemFire Application Peer 6.6 VM Stats"};
    public static final String[] DEFAULT_EXCLUDES = new String[]{"vFabric GemFire Cache Server 6.6 Cache Client Notifier", "vFabric GemFire Cache Server 6.6 Disk Directory", "vFabric GemFire Cache Server 6.6 Disk Region", "vFabric GemFire Cache Server 6.6 Distributed Lock", "vFabric GemFire Cache Server 6.6 Distribution Statistics", "vFabric GemFire Cache Server 6.6 Statistics Sampler", "vFabric GemFire Gateway Hub 6.6 Cache Client Notifier", "vFabric GemFire Gateway Hub 6.6 Disk Directory", "vFabric GemFire Gateway Hub 6.6 Disk Region", "vFabric GemFire Gateway Hub 6.6 Distributed Lock", "vFabric GemFire Gateway Hub 6.6 Distribution Statistics", "vFabric GemFire Gateway Hub 6.6 Function", "vFabric GemFire Gateway Hub 6.6 Function Service", "vFabric GemFire Gateway Hub 6.6 Resource Manager", "vFabric GemFire Cache Server 6.5 Cache Client Notifier", "vFabric GemFire Cache Server 6.5 Disk Directory", "vFabric GemFire Cache Server 6.5 Disk Region", "vFabric GemFire Cache Server 6.5 Distributed Lock", "vFabric GemFire Cache Server 6.5 Distribution Statistics", "vFabric GemFire Cache Server 6.5 Statistics Sampler", "vFabric GemFire Gateway Hub 6.5 Cache Client Notifier", "vFabric GemFire Gateway Hub 6.5 Disk Directory", "vFabric GemFire Gateway Hub 6.5 Disk Region", "vFabric GemFire Gateway Hub 6.5 Distributed Lock", "vFabric GemFire Gateway Hub 6.5 Distribution Statistics", "vFabric GemFire Gateway Hub 6.5 Function", "vFabric GemFire Gateway Hub 6.5 Function Service", "vFabric GemFire Gateway Hub 6.5 Resource Manager", "vFabric GemFire Cache Server 6.0 Cache Client Notifier", "vFabric GemFire Cache Server 6.0 Disk Directory", "vFabric GemFire Cache Server 6.0 Disk Region", "vFabric GemFire Cache Server 6.0 Distributed Lock", "vFabric GemFire Cache Server 6.0 Distribution Statistics", "vFabric GemFire Cache Server 6.0 Statistics Sampler", "vFabric GemFire Gateway Hub 6.0 Cache Client Notifier", "vFabric GemFire Gateway Hub 6.0 Disk Directory", "vFabric GemFire Gateway Hub 6.0 Disk Region", "vFabric GemFire Gateway Hub 6.0 Distributed Lock", "vFabric GemFire Gateway Hub 6.0 Distribution Statistics", "vFabric GemFire Gateway Hub 6.0 Function", "vFabric GemFire Gateway Hub 6.0 Function Service", "vFabric GemFire Gateway Hub 6.0 Resource Manager"};
    private String[] includes = null;
    private String[] excludes = null;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.initSettings(manager);
    }

    private void initSettings(PluginManager manager) {
        this.includes = this.getSetting(manager.getProperties(), "GemFire.autodiscovery.includeInstances");
        this.excludes = this.getSetting(manager.getProperties(), "GemFire.autodiscovery.excludeInstances");
        if (this.excludes.length == 0 && this.includes.length != 0) {
            this.excludes = new String[0];
        } else if (this.excludes.length == 0 && this.includes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
        }
        if (this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
        }
        if (this.includes.length == 1 && this.includes[0].equals("all")) {
            this.excludes = new String[0];
            this.includes = this.excludes;
        }
    }

    public List<ServerResource> getServerResources(ConfigResponse config) throws PluginException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detecting server resources for: " + this.getTypeInfo().getFormattedName() + " " + this.getTypeInfo().getVersion()));
            log.debug((Object)("Config used for detection: " + config));
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (config.getValue("jmx.url") == null) {
            return servers;
        }
        GFJmxConnection gf = new GFJmxConnection(config);
        GFVersionInfo gfVersionInfo = gf.getVersionInfoFromAgent();
        if (gfVersionInfo == null) {
            return servers;
        }
        if (!gfVersionInfo.isGFVersion(this.getTypeInfo().getVersion())) {
            return servers;
        }
        GFProductPlugin master = (GFProductPlugin)this.getProductPlugin();
        MemberCache memberCache = master.getMemberCache(config.getValue("jmx.url"));
        memberCache.refreshCacheVMs(config);
        memberCache.refreshPeers(config);
        Set<MemberInfo> members = memberCache.getMembers();
        for (MemberInfo memberInfo : members) {
            int mask = gf.getMemberRoles(memberInfo.getGfid());
            if (!this.hasCorrectRoles(mask)) continue;
            ServerResource server = this.createServerResource(memberInfo.getWorkingDirectory());
            server.setName(this.getTypeInfo().getName() + " " + memberInfo.getName());
            server.setIdentifier(memberInfo.getWorkingDirectory() + memberInfo.getHost() + memberInfo.getName());
            ConfigResponse c = new ConfigResponse();
            c.setValue("host", memberInfo.getHost());
            c.setValue("name", memberInfo.getName());
            c.setValue("workingDirectory", memberInfo.getWorkingDirectory());
            this.setMeasurementConfig(server, new ConfigResponse());
            this.setProductConfig(server, c);
            servers.add(server);
        }
        return servers;
    }

    protected abstract boolean hasCorrectRoles(int var1);

    protected List<ServiceResource> discoverServices(ConfigResponse config) throws PluginException {
        StatType[] filtered;
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        GFJmxConnection gf = new GFJmxConnection(config);
        GFProductPlugin master = (GFProductPlugin)this.getProductPlugin();
        MemberCache memberCache = master.getMemberCache(config.getValue("jmx.url"));
        String workingDirectory = config.getValue("workingDirectory");
        String host = config.getValue("host");
        String name = config.getValue("name");
        Object[][] statObjectsWithType = gf.getStatObjectsWithType(memberCache.getGfid(workingDirectory, host, name));
        for (StatType statType : filtered = this.filterSupportedStats(statObjectsWithType, config)) {
            services.add(this.createService(config, statType, name));
        }
        services.add(this.createVMStatsService(name, statObjectsWithType));
        return this.filterIncludesExcludes(services);
    }

    protected List<ServiceResource> filterIncludesExcludes(List<ServiceResource> services) {
        ArrayList<ServiceResource> filtered = new ArrayList<ServiceResource>();
        for (ServiceResource serviceResource : services) {
            String serviceTypeName = serviceResource.getType();
            boolean add = false;
            if (this.includes.length == 0 || ArrayUtil.exists((Object[])this.includes, (Object)serviceTypeName)) {
                add = true;
            }
            if (add && ArrayUtil.exists((Object[])this.excludes, (Object)serviceTypeName)) {
                add = false;
            }
            if (!add) continue;
            filtered.add(serviceResource);
        }
        return filtered;
    }

    protected abstract StatType[] filterSupportedStats(Object[][] var1, ConfigResponse var2);

    private ServiceResource createService(ConfigResponse config, StatType statType, String name) {
        ServiceResource service = this.createServiceResource(statType.type);
        service.setName(name + " " + statType.type + (statType.postfix != null ? " " + statType.postfix : ""));
        ConfigResponse c = new ConfigResponse();
        c.setValue("statname", statType.objectName.getKeyProperty("name"));
        this.setMeasurementConfig(service, new ConfigResponse());
        this.setProductConfig(service, c);
        return service;
    }

    private ServiceResource createVMStatsService(String name, Object[][] statObjectsWithType) {
        ServiceResource service = this.createServiceResource("VM Stats");
        service.setName(name + " VM Stats");
        ConfigResponse c = new ConfigResponse();
        for (int i = 0; i < statObjectsWithType.length; ++i) {
            ObjectName o = (ObjectName)statObjectsWithType[i][0];
            String oName = o.getKeyProperty("name");
            String olName = oName.toLowerCase();
            String type = (String)statObjectsWithType[i][1];
            if (type.equals("VMGCStats")) {
                if (olName.contains("sweep")) {
                    c.setValue("gcexpensive", oName);
                    continue;
                }
                c.setValue("gccheap", oName);
                continue;
            }
            if (!type.equals("VMMemoryPoolStats")) continue;
            if (olName.contains("eden")) {
                c.setValue("youngeden", oName);
                continue;
            }
            if (olName.contains("survivor")) {
                c.setValue("youngsurvivor", oName);
                continue;
            }
            if (olName.contains("old") || olName.contains("tenured")) {
                c.setValue("oldtenured", oName);
                continue;
            }
            if (olName.contains("perm gen")) {
                c.setValue("oldpermanent", oName);
                continue;
            }
            if (!olName.contains("cache")) continue;
            c.setValue("codecache", oName);
        }
        c.setValue("vmstats", "vmStats");
        c.setValue("vmheapmemorystats", "vmHeapMemoryStats");
        c.setValue("vmnonheapmemorystats", "vmNonHeapMemoryStats");
        this.setMeasurementConfig(service, new ConfigResponse());
        this.setProductConfig(service, c);
        return service;
    }

    private String[] getSetting(Properties props, String key) {
        HashSet<String> values = new HashSet<String>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (!k.startsWith(key)) continue;
            values.add(props.getProperty(k));
        }
        if (values.size() > 0) {
            return values.toArray(new String[values.size()]);
        }
        return new String[0];
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    class StatType {
        String type;
        ObjectName objectName;
        String postfix;

        public StatType(String type, ObjectName objectName, String postfix) {
            this.type = type;
            this.objectName = objectName;
            this.postfix = postfix;
        }

        public StatType(String type, ObjectName objectName) {
            this(type, objectName, null);
        }
    }
}

