/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.log;

import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;

public class GFNotificationTrack
extends LogTrackPlugin
implements NotificationListener,
Runnable {
    private static final Log log = LogFactory.getLog(GFNotificationTrack.class);
    public static final String GF_NOTIFICATION_ALERT = "gemfire.distributedsystem.alert";
    public static final String OPT_FORCE_ERROR = "force.error";
    public static final String OPT_FORCE_WARN = "force.warn";
    public static final String OPT_FORCE_INFO = "force.info";
    private static final String[] LOG_LEVELS = new String[]{"error,severe", "warning", "info,config", "fine,finer,finest"};
    private Pattern forceErrorPattern = null;
    private Pattern forceWarnPattern = null;
    private Pattern forceInfoPattern = null;
    private MBeanServerConnection mServer = null;
    private ObjectName gemFireAgentMBean = null;
    private long lastCheck = 0L;

    public void configure(ConfigResponse config) throws PluginException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[configure] config=" + config));
        }
        super.configure(config);
        try {
            this.gemFireAgentMBean = new ObjectName("GemFire:type=Agent");
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
        String eRegex = config.getValue(OPT_FORCE_ERROR, null);
        this.forceErrorPattern = StringUtils.isBlank((String)eRegex) ? null : Pattern.compile(eRegex);
        String wRegex = config.getValue(OPT_FORCE_WARN, null);
        this.forceWarnPattern = StringUtils.isBlank((String)wRegex) ? null : Pattern.compile(wRegex);
        String iRegex = config.getValue(OPT_FORCE_INFO, null);
        this.forceInfoPattern = StringUtils.isBlank((String)iRegex) ? null : Pattern.compile(iRegex);
        this.subscribe();
        this.getManager().addRunnableTracker((Runnable)this);
    }

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    protected ConfigOption getFilesOption(TypeInfo info, ConfigResponse config) {
        return null;
    }

    public void handleNotification(Notification notification, Object handback) {
        String message = notification.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[handleNotification] notification.getType() => " + notification.getType() + " / notification.getMessage() => " + notification.getMessage() + " / notification.getSource() => " + notification.getSource() + " / notification.getSequenceNumber() => " + notification.getSequenceNumber()));
        }
        if (GF_NOTIFICATION_ALERT.equals(notification.getType())) {
            String level = this.parseLogLevel(message);
            TrackEvent event = this.newTrackEvent(notification.getTimeStamp(), this.forceLevel(message, level != null ? level : "info"), notification.getSource().toString(), message);
            if (event != null) {
                this.getManager().reportEvent(event);
            }
        }
    }

    private String parseLogLevel(String levelString) {
        String[] fields = levelString.split(" ");
        if (fields.length == 0 || fields[0].length() < 2) {
            return null;
        }
        String level = fields[0].substring(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseLogLevel:" + levelString + "/" + level));
        }
        if (ArrayUtils.contains((Object[])LOG_LEVELS, (Object)level)) {
            return level;
        }
        return null;
    }

    private String forceLevel(String message, String level) {
        Matcher m;
        if (this.forceErrorPattern != null && (m = this.forceErrorPattern.matcher(message)).find()) {
            return "error";
        }
        if (this.forceWarnPattern != null && (m = this.forceWarnPattern.matcher(message)).find()) {
            return "warning";
        }
        if (this.forceInfoPattern != null && (m = this.forceInfoPattern.matcher(message)).find()) {
            return "info";
        }
        return level;
    }

    private void subscribe() {
        GFJmxConnection gf = new GFJmxConnection(this.getConfig());
        gf.removeAlertNotificationListener(this);
        this.mServer = gf.addAlertNotificationListener(this);
        if (this.mServer == null) {
            log.info((Object)"Failed to subscribe to Gemfire alert notifications.");
        } else {
            log.debug((Object)"Successfully subscribed to Gemfire alert notifications.");
        }
    }

    public void run() {
        long now = System.currentTimeMillis();
        if (this.lastCheck + 60000L > now) {
            return;
        }
        if (this.mServer == null) {
            this.subscribe();
        }
        try {
            if (this.mServer != null) {
                this.mServer.isRegistered(this.gemFireAgentMBean);
            }
        }
        catch (IOException e) {
            this.mServer = null;
        }
        this.lastCheck = now;
    }

    public void shutdown() throws PluginException {
        this.getManager().removeRunnableTracker((Runnable)this);
        super.shutdown();
    }
}

