/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.metric.RatioMetric;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class CustomMetric {
    private String[] metrics;
    private String type;
    private String alias;

    public CustomMetric() {
    }

    public CustomMetric(String[] metrics, String type) {
        this.metrics = metrics;
        this.type = type;
        StringBuilder b = new StringBuilder();
        b.append("custom_");
        b.append(type);
        for (String metric : metrics) {
            b.append("_");
            b.append(metric);
        }
        this.alias = b.toString();
    }

    public CustomMetric(String alias) {
        StringTokenizer token = new StringTokenizer(alias, "_");
        token.nextToken();
        this.type = token.nextToken();
        ArrayList<String> list = new ArrayList<String>();
        while (token.hasMoreElements()) {
            list.add(token.nextToken());
        }
        this.metrics = list.toArray(new String[0]);
        this.alias = alias;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String[] metrics) {
        this.metrics = metrics;
    }

    public abstract Double calculate(Double[] var1);

    public static CustomMetric buildByAlias(String alias) {
        String[] fields = alias.split("_");
        if (fields[1].equals("ratio")) {
            return new RatioMetric(alias);
        }
        return null;
    }
}

