/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.dotnet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotNetMeasurementPlugin
extends Win32MeasurementPlugin {
    private static final String DATA_DOMAIN = ".NET CLR Data";
    private static final String DATA_PREFIX = "SqlClient: ";
    private static final String RUNTIME_NAME = "_Global_";
    private static Log log = LogFactory.getLog(DotNetMeasurementPlugin.class);
    private static final Map<String, List<String>> sqlPidsCache = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> oraclePidsCache = new HashMap<String, List<String>>();

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue val = null;
        if (metric.getDomainName().equalsIgnoreCase("pdh")) {
            val = this.getPDHMetric(metric);
        } else if (metric.getDomainName().equalsIgnoreCase("pdhSQLDP")) {
            val = this.getPDHSQLPDMetric(metric, sqlPidsCache, ".NET Data Provider for SqlServer");
        } else if (metric.getDomainName().equalsIgnoreCase("pdhOracleDP")) {
            val = this.getPDHSQLPDMetric(metric, oraclePidsCache, "Oracle Data Provider for .NET");
        } else {
            try {
                val = super.getValue(metric);
                if (metric.isAvail()) {
                    val = new MetricValue(1.0);
                }
            }
            catch (MetricNotFoundException ex) {
                if (metric.isAvail()) {
                    val = new MetricValue(0.0);
                }
                throw ex;
            }
        }
        return val;
    }

    protected String getAttributeName(Metric metric) {
        if (metric.getDomainName().equals(DATA_DOMAIN)) {
            return DATA_PREFIX + metric.getAttributeName();
        }
        return metric.getAttributeName();
    }

    public String translate(String template, ConfigResponse config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[translate] >> template=" + template));
            for (String key : config.getKeys()) {
                if (!key.toLowerCase().startsWith("app")) continue;
                log.debug((Object)("[translate]  > " + key + "=" + config.getValue(key)));
            }
        }
        template = super.translate(template, config);
        template = StringUtil.replace((String)template, (String)"__percent__", (String)"%");
        String prop = "app.name";
        template = StringUtil.replace((String)template, (String)"${app.name}", (String)config.getValue("app.name", RUNTIME_NAME));
        log.debug((Object)("[translate] << template=" + template));
        return template;
    }

    private MetricValue getPDHSQLPDMetric(Metric metric, Map<String, List<String>> pidsCache, String providerStr) {
        MetricValue res;
        if (metric.isAvail()) {
            pidsCache.clear();
        }
        if (pidsCache.isEmpty()) {
            try {
                String[] instances = Pdh.getInstances((String)providerStr);
                Pattern regex = Pattern.compile("([^\\[]*)\\[([^\\]]*)\\]");
                for (int i = 0; i < instances.length; ++i) {
                    String nonTrimmedName;
                    String name;
                    String instance = instances[i];
                    log.debug((Object)("[getPDHSQLPDMetric] " + providerStr + " instance = " + instance));
                    Matcher m = regex.matcher(instance);
                    if (!m.find() || (name = (nonTrimmedName = m.group(1)).trim()).length() == 0) continue;
                    List<String> pids = pidsCache.get(name);
                    if (pids == null) {
                        pids = new ArrayList<String>();
                        pidsCache.put(name, pids);
                    }
                    String spaces = nonTrimmedName.substring(nonTrimmedName.indexOf(name) + name.length());
                    String pid = spaces + "[" + m.group(2) + "]";
                    pids.add(pid);
                }
            }
            catch (Win32Exception e) {
                log.debug((Object)("Error getting PIDs data for '.NET Data Provider for SqlServer': " + (Object)((Object)e)), (Throwable)e);
            }
            log.debug((Object)("[getPDHSQLPDMetric] pidsCache = " + pidsCache));
        }
        log.debug((Object)("[getPDHSQLPDMetric] metric:'" + metric));
        String appName = metric.getObjectPropString();
        List<String> pids = pidsCache.get(appName);
        if (pids == null) {
            pidsCache.clear();
            res = metric.isAvail() ? new MetricValue(0.0) : MetricValue.NONE;
        } else if (metric.isAvail()) {
            res = new MetricValue(pids.size() > 0 ? 1.0 : 0.0);
        } else if (metric.getAttributeName().equalsIgnoreCase("instances")) {
            res = new MetricValue((long)pids.size());
        } else if (pids.isEmpty()) {
            res = MetricValue.NONE;
        } else {
            double val = 0.0;
            for (int i = 0; i < pids.size(); ++i) {
                String pid = pids.get(i);
                String obj = "\\" + providerStr + "(" + appName + pid + ")\\" + metric.getAttributeName();
                log.debug((Object)("[getPDHSQLPDMetric] obj:'" + obj));
                val += this.getPDHMetric(obj, metric.isAvail()).getValue();
            }
            res = new MetricValue(val);
        }
        return res;
    }

    private MetricValue getPDHMetric(Metric metric) {
        String obj = "\\" + metric.getObjectPropString();
        if (!metric.isAvail()) {
            obj = obj + "\\" + metric.getAttributeName();
        }
        log.debug((Object)("[getPDHMetric] metric:'" + metric));
        log.debug((Object)("[getPDHMetric] obj:'" + obj));
        return this.getPDHMetric(obj, metric.isAvail());
    }

    private MetricValue getPDHMetric(String obj, boolean avail) {
        MetricValue res;
        try {
            Double val = new Pdh().getFormattedValue(obj);
            res = new MetricValue((Number)val);
            if (avail) {
                res = new MetricValue(1.0);
            }
        }
        catch (Win32Exception ex) {
            if (avail) {
                res = new MetricValue(0.0);
                log.debug((Object)("[getPDHMetric] error on obj:'" + obj + "' :" + ex.getLocalizedMessage()), (Throwable)ex);
            }
            res = MetricValue.NONE;
            log.debug((Object)("[getPDHMetric] error on obj:'" + obj + "' :" + ex.getLocalizedMessage()));
        }
        return res;
    }
}

