/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.server;

import com.hyperic.hq.rt.agent.RtCommandsAPI;
import com.hyperic.hq.rt.agent.client.RtCommandsClient;
import com.hyperic.hq.rt.agent.commands.RtPluginDisable_args;
import com.hyperic.hq.rt.agent.commands.RtPlugin_args;
import com.hyperic.hq.rt.agent.server.RtCommandsService;
import com.hyperic.hq.rt.agent.server.RtSchedule;
import com.hyperic.hq.rt.agent.server.RtScheduleThread;
import com.hyperic.hq.rt.agent.server.RtSenderThread;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.product.RtPluginManager;

public class RtCommandsServer
implements AgentServerHandler {
    private static final long THREAD_JOIN_WAIT = 10000L;
    private RtCommandsAPI verAPI = new RtCommandsAPI();
    private Thread scheduleThread = null;
    private RtScheduleThread scheduleObject = null;
    private Thread senderThread = null;
    private RtSenderThread senderObject = null;
    private AgentStorageProvider storage = null;
    private AgentConfig bootConfig = null;
    private RtSchedule schedStorage = null;
    private RtPluginManager pluginManager = null;
    private RtCommandsService rtCommandsService;
    private Log log = LogFactory.getLog(RtCommandsServer.class);

    private void spawnThreads(RtSenderThread senderObject, RtScheduleThread scheduleObject) throws AgentStartException {
        this.senderThread = new Thread((Runnable)this.senderObject, "RtSenderThread");
        this.senderThread.setDaemon(true);
        this.scheduleThread = new Thread((Runnable)this.scheduleObject, "RtScheduleThread");
        this.scheduleThread.setDaemon(true);
        this.senderThread.start();
        this.scheduleThread.start();
    }

    public AgentAPIInfo getAPIInfo() {
        return this.verAPI;
    }

    public String[] getCommandSet() {
        return RtCommandsAPI.commandSet;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        if (cmd.equals("rt:scheduleRt")) {
            RtPlugin_args ra = new RtPlugin_args(args);
            this.rtCommandsService.scheduleRt(ra);
            return new AgentRemoteValue();
        }
        if (cmd.equals("rt:unscheduleRt")) {
            RtPluginDisable_args ra = new RtPluginDisable_args(args);
            this.rtCommandsService.unscheduleRt(ra);
            return new AgentRemoteValue();
        }
        if (cmd.equals("rt:reScheduleRt")) {
            RtPlugin_args ra = new RtPlugin_args(args);
            this.rtCommandsService.reScheduleRt(ra);
            return new AgentRemoteValue();
        }
        if (cmd.equals("rt:isEnabled")) {
            RtPlugin_args ra = new RtPlugin_args(args);
            return this.rtCommandsService.isEnabled(ra);
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        try {
            this.storage = agent.getStorageProvider();
            this.bootConfig = agent.getBootConfig();
            this.schedStorage = new RtSchedule(this.storage, this.bootConfig.getBootProperties());
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("Agent should be running here");
        }
        try {
            this.pluginManager = (RtPluginManager)agent.getPluginManager("responsetime");
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get response timeplugin manager: " + e.getMessage());
        }
        this.senderObject = new RtSenderThread(this.bootConfig.getBootProperties(), this.storage);
        this.scheduleObject = new RtScheduleThread(this.senderObject, this.pluginManager, this.storage);
        this.rtCommandsService = new RtCommandsService(this.storage, this.schedStorage, this.scheduleObject);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this.log.info((Object)"Registering Response Time Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(RtCommandsClient.class, (Object)this.rtCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Response Time Commands Service.", e);
        }
        this.spawnThreads(this.senderObject, this.scheduleObject);
        List l = this.schedStorage.getRtList();
        for (RtPlugin_args r : l) {
            this.scheduleObject.scheduleRt(r);
        }
        this.log.info((Object)"Response Time Commands Server started up");
    }

    private void interruptThread(Thread t) throws InterruptedException {
        if (t.isAlive()) {
            t.interrupt();
            t.join(10000L);
            if (t.isAlive()) {
                this.log.warn((Object)(t.getName() + " did not die within the " + "timeout period.  Killing it"));
                t.stop();
            }
        }
    }

    public final void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
        this.log.info((Object)"Response Time Commands Server shutting down");
        this.scheduleObject.die();
        this.senderObject.die();
        try {
            this.interruptThread(this.scheduleThread);
            this.interruptThread(this.senderThread);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.info((Object)"Response Time Commands Server shut down");
    }
}

