/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.FileSystems;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.Paths;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.ext.ExtendedWatchEventModifier;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.hyperic.cm.filemonitor.BaselineAdder;
import org.hyperic.cm.filemonitor.DirsMapAdder;
import org.hyperic.cm.filemonitor.WatchedFolderAdder;
import org.hyperic.cm.filemonitor.data.EventActionsEnum;
import org.hyperic.cm.filemonitor.data.EventConverter;
import org.hyperic.cm.filemonitor.data.EventMessage;
import org.hyperic.cm.filemonitor.data.WatchedDirInfo;
import org.hyperic.cm.filemonitor.utils.FileWalker;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Watcher
implements Runnable {
    private final WatchService watcher;
    private String filter;
    private static Logger log = LoggerFactory.getLogger(Watcher.class);
    private final BlockingQueue<EventMessage> senderQueue;
    private final Map<String, WatchKey> pathWatchKeyMap = new HashMap<String, WatchKey>();
    private final Map<WatchKey, WatchedDirInfo> watchKeyInfoMap = new HashMap<WatchKey, WatchedDirInfo>();
    EventMessage prevEvent;
    private boolean _stop = false;
    private String oldPath = null;

    public Watcher(BlockingQueue<EventMessage> senderQueue) {
        this.senderQueue = senderQueue;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.prevEvent = null;
    }

    public void setWatchedDirs(Map<String, WatchedDirInfo> newDirsMap) {
        HashSet<String> remove = new HashSet<String>(this.pathWatchKeyMap.keySet());
        this.addUpdateWatchedDirs(newDirsMap, remove);
        this.removeWatchedDirs(remove);
    }

    public void removeWatchedDirs(Collection<String> remove) {
        HashSet<String> keySet = new HashSet<String>(this.pathWatchKeyMap.keySet());
        for (String path : remove) {
            this.removeWatchedFolder(path);
            if (!Os.isFamily((String)"unix")) continue;
            for (String s : keySet) {
                if (!s.startsWith(path)) continue;
                this.removeWatchedFolder(path);
            }
        }
    }

    private void removeWatchedFolder(String path) {
        WatchKey key = this.pathWatchKeyMap.get(path);
        if (key == null) {
            return;
        }
        try {
            key.cancel();
        }
        catch (NullPointerException e) {
            log.debug("Folder removed before watch removed");
        }
        this.pathWatchKeyMap.remove(path);
        this.watchKeyInfoMap.remove(key);
        if (log.isInfoEnabled()) {
            log.info("Removing folder from watch: " + path);
        }
    }

    public void addUpdateWatchedDirs(Map<String, WatchedDirInfo> newDirsMap) {
        this.addUpdateWatchedDirs(newDirsMap, null);
    }

    protected void addUpdateWatchedDirs(Map<String, WatchedDirInfo> dirsMap, Collection<String> remove) {
        Map<String, WatchedDirInfo> newDirsMap = this.addLinuxRecursiveDirs(dirsMap);
        ArrayList<String> exists = new ArrayList<String>();
        for (String path : newDirsMap.keySet()) {
            WatchedDirInfo info;
            if (!this.pathWatchKeyMap.containsKey(path)) continue;
            WatchKey watchKey = this.pathWatchKeyMap.get(path);
            WatchedDirInfo watchedDirInfo = info = watchKey == null ? null : this.watchKeyInfoMap.get(watchKey);
            if (info != null) {
                String filter = newDirsMap.get(path) == null ? null : newDirsMap.get(path).getFilter();
                boolean recursive = newDirsMap.get(path) == null ? false : newDirsMap.get(path).isRecursive();
                info.setFilter(filter);
                info.setRecursive(recursive);
                log.info("Updating folder to watch: " + path);
            }
            exists.add(path);
        }
        for (String path : exists) {
            if (remove != null) {
                remove.remove(path);
            }
            newDirsMap.remove(path);
        }
        for (String path : newDirsMap.keySet()) {
            WatchedDirInfo info = newDirsMap.get(path);
            this.addWatchedFolder(path, info);
        }
    }

    protected Map<String, WatchedDirInfo> addLinuxRecursiveDirs(Map<String, WatchedDirInfo> newDirsMap) {
        if (!Os.isFamily((String)"unix") || newDirsMap == null || newDirsMap.size() <= 0) {
            return newDirsMap;
        }
        HashMap<String, WatchedDirInfo> map = new HashMap<String, WatchedDirInfo>(newDirsMap);
        for (Map.Entry<String, WatchedDirInfo> entry : newDirsMap.entrySet()) {
            WatchedDirInfo folder = entry.getValue();
            if (!folder.isRecursive()) continue;
            DirsMapAdder callable = new DirsMapAdder(map, folder.getFilter());
            File dir = new File(entry.getKey());
            if (log.isDebugEnabled()) {
                log.debug("Directory is to be monitored recursively on unix " + dir.getPath());
            }
            FileWalker.walkDfs(dir, callable);
        }
        return map;
    }

    public void addWatchedFolder(String path, WatchedDirInfo info) {
        Path p = this.createPathObj(path);
        boolean recursive = info == null ? null : Boolean.valueOf(info.isRecursive());
        WatchKey wk = this.initPathWatch(p, recursive);
        this.pathWatchKeyMap.put(path, wk);
        info.setPath(p);
        this.watchKeyInfoMap.put(wk, info);
        log.info("Adding folder to watch: " + path);
    }

    private Path createPathObj(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        return Paths.get((String)path);
    }

    public String getFilter() {
        return this.filter;
    }

    private WatchKey initPathWatch(Path path, boolean recursive) {
        WatchKey key = null;
        if (Os.isFamily((String)"unix")) {
            recursive = false;
        }
        try {
            WatchEvent.Modifier exModifier = recursive ? ExtendedWatchEventModifier.FILE_TREE : ExtendedWatchEventModifier.ACCURATE;
            key = path.register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY, ExtendedWatchEventKind.ENTRY_RENAME_FROM, ExtendedWatchEventKind.ENTRY_RENAME_TO}, new WatchEvent.Modifier[]{exModifier});
        }
        catch (UnsupportedOperationException uox) {
            System.err.println("file watching not supported!");
        }
        catch (IOException iox) {
            System.err.println("I/O errors");
        }
        return key;
    }

    @Override
    public void run() {
        HandleRenameFromNonMonitoredFolder handleUnmonitoredRename = new HandleRenameFromNonMonitoredFolder();
        while (!this._stop) {
            WatchKey signalledKey;
            try {
                signalledKey = this.watcher.take();
            }
            catch (InterruptedException ix) {
                continue;
            }
            catch (ClosedWatchServiceException cwse) {
                log.info("watch service closed, terminating.");
                break;
            }
            List list = signalledKey.pollEvents();
            signalledKey.reset();
            WatchedDirInfo info = this.watchKeyInfoMap.get(signalledKey);
            Path p = info == null ? null : info.getPath();
            String path = p == null ? null : p.toString();
            String filter = info == null ? null : info.getFilter();
            for (WatchEvent e : list) {
                WatchEvent.Kind kind = e.kind();
                EventActionsEnum event = EventConverter.Convert(kind);
                Path context = (Path)e.context();
                String fileName = context == null ? null : context.toString();
                String fullPath = String.valueOf(path) + File.separator + fileName;
                if (log.isDebugEnabled()) {
                    log.debug("Recieved event: " + (Object)((Object)event) + " " + fullPath);
                }
                if (event == null) {
                    if (kind == ExtendedWatchEventKind.ENTRY_RENAME_FROM) {
                        this.oldPath = fullPath;
                        continue;
                    }
                    if (kind != StandardWatchEventKind.OVERFLOW) continue;
                    log.error("OVERFLOW: more changes happened than we could retreive");
                    continue;
                }
                if ((EventActionsEnum.RENAME.equals((Object)event) || EventActionsEnum.CREATE.equals((Object)event)) && info.isRecursive() && this.doLinuxDirAdd(filter, fullPath)) {
                    if (EventActionsEnum.RENAME.equals((Object)event) && this.oldPath != null) {
                        handleUnmonitoredRename.setPath(null);
                        this.removeWatchedFolder(this.oldPath);
                        this.onEvent(EventActionsEnum.DELETE, filter, this.oldPath);
                    }
                    this.oldPath = null;
                    continue;
                }
                if (EventActionsEnum.DELETE.equals((Object)event)) {
                    this.removeWatchedFolder(fullPath);
                }
                if (EventActionsEnum.RENAME.equals((Object)event) && this.oldPath != null) {
                    this.onEvent(event, filter, fullPath, this.oldPath);
                    handleUnmonitoredRename.setPath(null);
                } else {
                    this.onEvent(event, filter, fullPath);
                }
                this.oldPath = null;
            }
            if (path == null) continue;
            handleUnmonitoredRename.setPath(this.oldPath);
            Thread t = new Thread(handleUnmonitoredRename);
            t.start();
        }
    }

    private boolean doLinuxDirAdd(String filter, String path) {
        if (!Os.isFamily((String)"unix")) {
            return false;
        }
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            return false;
        }
        if (this.pathWatchKeyMap.containsKey(path)) {
            return false;
        }
        this.addFolderRecursive(path, filter);
        return true;
    }

    public void addFolderRecursive(String path, String filter) {
        log.info("addFolderRecursive(" + path + ", " + filter + ")");
        this.addWatchedFolder(path, new WatchedDirInfo(null, true, filter));
        WatchedFolderAdder callable = new WatchedFolderAdder(this, filter);
        FileWalker.walkDfs(new File(path), callable);
        BaselineAdder fileAdder = new BaselineAdder(this, true, filter, EventActionsEnum.CREATE);
        this.simulateEvent(EventActionsEnum.CREATE, filter, path);
        FileWalker.walkDfs(new File(path), fileAdder);
    }

    public Boolean stopWatching() {
        this._stop = true;
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean passedFilter(String filePath, EventActionsEnum eventAction, String filter) {
        File f = new File(filePath);
        if (f.exists() && f.isDirectory() || EventActionsEnum.DELETE.equals((Object)eventAction) && Utils.getFileExtension((String)f.getName()) == null) {
            return true;
        }
        if (!(EventActionsEnum.DELETE.equals((Object)eventAction) || f.exists() && !f.isDirectory())) {
            if (log.isDebugEnabled()) {
                log.debug("Filtered - " + filePath + " This is a directory or non-existent file. Skipping this event.");
            }
            return false;
        }
        String fileName = f.getName();
        if (filter == null || fileName.matches(filter)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Filtered - " + filePath + " - File does not match filter. Skipping this event.");
        }
        return false;
    }

    private void onEvent(EventActionsEnum eventAction, String filter, String filePath) {
        this.onEvent(eventAction, filter, filePath, null);
    }

    private void onEvent(EventActionsEnum eventAction, String filter, String filePath, String oldFilePath) {
        String path = filePath;
        String oldPath = oldFilePath;
        if (EventActionsEnum.REGISTER_COMPLETE.equals((Object)eventAction)) {
            path = null;
        } else if (!this.passedFilter(path, eventAction, filter)) {
            if (oldPath == null) {
                log.info("path and target didn't pass filter " + path);
                eventAction = EventActionsEnum.SKIPPED;
            } else if (!this.passedFilter(oldPath, EventActionsEnum.DELETE, filter)) {
                log.info("source and target didn't pass filter " + path + " " + oldPath);
                eventAction = EventActionsEnum.SKIPPED;
            } else {
                path = oldPath;
                eventAction = EventActionsEnum.DELETE;
                log.info("Event changed from RENAME to " + (Object)((Object)eventAction));
            }
        } else if (oldPath != null && !this.passedFilter(oldPath, EventActionsEnum.DELETE, filter)) {
            eventAction = EventActionsEnum.CREATE;
            log.info("Event changed from RENAME to " + (Object)((Object)eventAction));
        }
        try {
            Long timestamp = Calendar.getInstance().getTimeInMillis();
            EventMessage currEvent = EventActionsEnum.RENAME.equals((Object)eventAction) ? new EventMessage(eventAction, path, oldPath, timestamp) : new EventMessage(eventAction, path, timestamp);
            this.senderQueue.put(currEvent);
            this.prevEvent = currEvent;
            log.info("Event Queued: " + (Object)((Object)eventAction) + " " + path + " " + (oldPath != null ? oldPath : ""));
        }
        catch (InterruptedException e) {
            log.error("Queue action interrupted " + e.getMessage(), (Throwable)e);
        }
    }

    public void simulateEvent(EventActionsEnum eventAction, String filter, String filePath) {
        if (log.isDebugEnabled()) {
            log.debug("Simulating " + eventAction.name() + " event for " + filePath + " with filter " + filter);
        }
        this.onEvent(eventAction, filter, filePath);
    }

    private class HandleRenameFromNonMonitoredFolder
    implements Runnable {
        private String path = null;

        public void setPath(String path) {
            this.path = path;
            log.debug("Potential rename from monitored to non-monitored. " + path);
        }

        public void run() {
            if (this.path == null) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.path != null) {
                Watcher.this.onEvent(EventActionsEnum.DELETE, Watcher.this.filter, this.path);
                log.debug("Detected rename from monitored to non-monitored. " + this.path);
                Watcher.this.oldPath = null;
            }
        }
    }
}

