/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor.utils;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static Logger log = LoggerFactory.getLogger(XmlUtils.class);

    public static Document createEmptyDocument() {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = fac.newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            Document doc = impl.createDocument(null, null, null);
            return doc;
        }
        catch (ParserConfigurationException ex) {
            log.error("Error creating empty xml document", (Throwable)ex);
            return null;
        }
    }

    public static NodeList getNodeListByName(Document doc, String path) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression expr = xpath.compile(path);
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            return nodes;
        }
        catch (XPathExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Collection<String> getAttrValues(NodeList nodeList, String attrName) {
        if (nodeList == null) {
            return null;
        }
        ArrayList<String> vals = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element e;
            String val;
            Node n = nodeList.item(i);
            if (n instanceof Element && (val = (e = (Element)n).getAttribute(attrName)) != null && val.length() > 0) {
                vals.add(val);
            }
            ++i;
        }
        return vals;
    }

    public static Collection<String[]> getAttrsValues(NodeList nodeList, String[] attrNames) {
        if (nodeList == null) {
            return null;
        }
        ArrayList<String[]> valsCol = new ArrayList<String[]>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                String[] vals = new String[attrNames.length];
                int j = 0;
                String[] stringArray = attrNames;
                int n2 = attrNames.length;
                int n3 = 0;
                while (n3 < n2) {
                    String val;
                    String name = stringArray[n3];
                    vals[j] = val = e.getAttribute(name);
                    ++j;
                    ++n3;
                }
                valsCol.add(vals);
            }
            ++i;
        }
        return valsCol;
    }

    public static Document loadDomFromFile(String filePath) {
        File file = new File(filePath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    public static Document loadDomFromString(String xmlSource) throws SAXException, ParserConfigurationException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xmlSource)));
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

