/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.MeasurementPluginManager;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.filter.TokenReplacer;

public class MeasurementPlugin
extends GenericPlugin {
    public static final String PROP_TEMPLATE_CONFIG = "template-config";
    public static final String TYPE_COLLECTOR = "collector";
    private static final String HELP_PLATFORM_ALL = "ALL";
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private Class collector = null;
    private static boolean inProxyRegister = false;
    private MeasurementPluginManager manager;
    private static final int PLATFORM_HELP_UNIX = 1;
    private static final int PLATFORM_HELP_WIN32 = 2;
    private static final String[][] PLATFORM_HELP_PROPS = new String[][]{{"CMD.cp", "cp", "copy"}, {"CMD.cpr", "cp -R", "xcopy /E"}, {"CMD.prompt", "%", "C:\\&gt;"}, {"CMD.env.set", "export", "set"}, {"CMD.ext", "sh", "exe"}, {"CMD.rm", "rm", "del"}, {"FILE.sep", "/", "\\"}, {"FILE.sep.esc", "/", "\\\\"}};
    private static final String[][] NO_PLATFORM_HELP_PROPS = new String[0][0];

    private void registerProxies(PluginManager manager) throws PluginException {
        if (inProxyRegister) {
            return;
        }
        if (this.getTypeInfo() == null) {
            return;
        }
        String domain = this.getTypeProperty("DOMAIN");
        if (domain == null) {
            return;
        }
        inProxyRegister = true;
        StringTokenizer tok = new StringTokenizer(domain, ",");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (this.manager.isRegistered(name)) continue;
            this.getLog().info((Object)("Register " + this.getName() + " proxy for domain: " + name));
            try {
                this.getManager().createPlugin(name, this);
            }
            catch (PluginException e) {
                inProxyRegister = false;
                throw e;
            }
        }
        inProxyRegister = false;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.manager = (MeasurementPluginManager)manager;
        this.registerProxies(manager);
    }

    protected MeasurementPluginManager getManager() {
        return this.manager;
    }

    protected Map getMeasurementProperties() {
        return null;
    }

    private void setInterval(MeasurementInfo metric) {
        switch (metric.getCollectionType()) {
            case 0: {
                metric.setInterval(300000L);
                break;
            }
            case 2: 
            case 3: {
                metric.setInterval(600000L);
                break;
            }
            case 1: {
                metric.setInterval(1800000L);
                break;
            }
            default: {
                this.log.error((Object)("Unknown collection type: " + metric.getCollectionType()));
            }
        }
    }

    private void setAvailInterval(TypeInfo type, MeasurementInfo metric) {
        switch (type.getType()) {
            case 1: {
                metric.setInterval(60000L);
                break;
            }
            case 2: {
                metric.setInterval(300000L);
                break;
            }
            case 3: {
                metric.setInterval(600000L);
                break;
            }
            default: {
                this.log.error((Object)("Unable to set default metric interval: Unknown type: " + type));
            }
        }
    }

    public MeasurementInfo[] getMeasurements(TypeInfo info) {
        if (this.data == null) {
            this.log.debug((Object)(this.getName() + " has no PluginData"));
            return null;
        }
        List xmlMetrics = this.data.getMetrics(info.getName());
        if (xmlMetrics == null) {
            return null;
        }
        String tmplConfig = this.data.getProperty(PROP_TEMPLATE_CONFIG);
        String availCat = "AVAILABILITY";
        ArrayList<MeasurementInfo> metrics = new ArrayList<MeasurementInfo>(xmlMetrics.size());
        for (int i = 0; i < xmlMetrics.size(); ++i) {
            String prefix;
            String ptqlDomain;
            MeasurementInfo metric = (MeasurementInfo)xmlMetrics.get(i);
            metric = (MeasurementInfo)metric.clone();
            metrics.add(metric);
            if (metric.getInterval() == -1L) {
                if (metric.getCategory().equals("AVAILABILITY")) {
                    this.setAvailInterval(info, metric);
                } else {
                    this.setInterval(metric);
                }
            }
            String template = metric.getTemplate();
            if (tmplConfig != null && !template.startsWith(ptqlDomain = "sigar.ptql")) {
                metric.setTemplate(template + ":" + tmplConfig);
                template = metric.getTemplate();
            }
            if (!template.startsWith(prefix = info.getName() + ":")) {
                metric.setTemplate(prefix + template);
            }
            if ((metric = MeasurementPlugin.generateRateMetric(metric)) == null) continue;
            metrics.add(metric);
        }
        MeasurementInfo[] infos = new MeasurementInfo[metrics.size()];
        metrics.toArray(infos);
        return infos;
    }

    protected String[][] getPlatformHelpProperties() {
        return NO_PLATFORM_HELP_PROPS;
    }

    String replaceHelpProperties(String help, TypeInfo info, Map props) {
        String platform = this.getHelpPlatform(info);
        TokenReplacer replacer = new TokenReplacer();
        if (info.getType() != 1 && info.getVersion() != null) {
            replacer.addFilter("product.version", info.getVersion());
        }
        int ix = PlatformDetector.isWin32(platform) ? 2 : 1;
        for (int i = 0; i < PLATFORM_HELP_PROPS.length; ++i) {
            replacer.addFilter(PLATFORM_HELP_PROPS[i][0], PLATFORM_HELP_PROPS[i][ix]);
        }
        String[][] pluginProps = this.getPlatformHelpProperties();
        for (int i = 0; i < pluginProps.length; ++i) {
            replacer.addFilter(pluginProps[i][0], pluginProps[i][ix]);
        }
        replacer.addFilters(props);
        replacer.addFilters((Map)this.getProperties());
        replacer.addFilters((Map)this.getTypeProperties());
        return replacer.replaceTokens(help);
    }

    private static MeasurementInfo generateRateMetric(MeasurementInfo info) {
        if (info.getCollectionType() != 2) {
            return null;
        }
        if (info.getRate().equals("none")) {
            return null;
        }
        MeasurementInfo rate = (MeasurementInfo)info.clone();
        if (info.isIndicator()) {
            info.setIndicator(false);
        }
        if (info.isDefaultOn()) {
            info.setDefaultOn(false);
        }
        info = null;
        if ("".equals(rate.getRate())) {
            rate.setRate("1m");
        }
        rate.setCollectionType(0);
        rate.setName(rate.getName() + " " + rate.getReadableRate());
        rate.setAlias(rate.getAlias() + rate.getRate());
        rate.setTemplate(rate.getTemplate() + "__RATE__" + "=" + rate.getRate());
        return rate;
    }

    protected String getPluginXMLHelp(TypeInfo info, String name, Map props) {
        if (this.data == null) {
            this.log.debug((Object)(this.getName() + " has no PluginData"));
            return null;
        }
        String help = this.data.getHelp(name);
        if (help != null) {
            if (help.length() == 0) {
                return null;
            }
            return this.replaceHelpProperties(help, info, props);
        }
        return help;
    }

    private String getHelpPlatform(TypeInfo info) {
        String platform = HELP_PLATFORM_ALL;
        String[] platforms = info.getType() == 1 ? new String[]{} : info.getPlatformTypes();
        if (platforms.length == 1) {
            platform = platforms[0];
        }
        return platform;
    }

    private String[] getHelpPlatformNames(TypeInfo info, String name) {
        String platform = this.getHelpPlatform(info);
        String[] names = platform.equals(HELP_PLATFORM_ALL) ? new String[]{name} : new String[]{TypeBuilder.composePlatformTypeName(name, platform), name};
        return names;
    }

    private String[] getHelpPlatformNames(TypeInfo info) {
        return this.getHelpPlatformNames(info, info.getName());
    }

    public String getHelp(TypeInfo info, Map props) {
        String[] names = this.getHelpPlatformNames(info);
        for (int i = 0; i < names.length; ++i) {
            String help = this.getPluginXMLHelp(info, names[i], props);
            if (help == null) continue;
            return help;
        }
        return null;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        return Collector.getValue(this, metric);
    }

    public Collector getNewCollector() {
        if (this.collector == null && this.data != null) {
            String name = this.data.getPlugin(TYPE_COLLECTOR, this.getTypeInfo().getName());
            if (name == null) {
                String msg = "No measurement plugin or collector defined for: " + this.getTypeInfo().getName();
                throw new MetricInvalidException(msg);
            }
            this.collector = ProductPlugin.getPluginClass(this.getClass().getClassLoader(), this.data, name, this.getTypeInfo().getName());
            if (this.collector == null) {
                String msg = "Class '" + name + "' NotFound using ClassLoader=" + this.data.getClassLoader();
                throw new MetricInvalidException(msg);
            }
        }
        try {
            return (Collector)this.collector.newInstance();
        }
        catch (Exception e) {
            throw new MetricInvalidException(e.getMessage());
        }
    }

    public Properties getCollectorProperties(Metric metric) {
        return metric.getObjectProperties();
    }

    public String translate(String template, ConfigResponse config) {
        TokenReplacer replacer = new TokenReplacer();
        Map props = this.getMeasurementProperties();
        if (props != null) {
            replacer.addFilters(props);
        }
        replacer.addFilters(PluginData.getGlobalProperties());
        template = replacer.replaceTokens(template);
        return Metric.translate(template, config);
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema;
        if (this.data != null && (schema = this.data.getConfigSchema(info, 1)) != null) {
            return schema;
        }
        return super.getConfigSchema(info, config);
    }
}

