/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.snmp.MIBLookupException;
import org.hyperic.snmp.MIBTree;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;
import org.hyperic.util.StringUtil;
import org.hyperic.util.timer.StopWatch;

public class SNMPMeasurementPlugin
extends MeasurementPlugin {
    public static final String DOMAIN = "snmp";
    public static final String PROP_INDEX_NAME = "snmpIndexName";
    public static final String PROP_INDEX_VALUE = "snmpIndexValue";
    private static final String PROP_OID = "snmpOID";
    private static final String PROP_VARTYPE = "snmpVarType";
    private static final int VARTYPE_SINGLE = 0;
    private static final int VARTYPE_NEXT = 1;
    private static final int VARTYPE_COLUMN = 2;
    private static final int VARTYPE_INDEX = 3;
    private static final int VARTYPE_OID = 4;
    private static long ixTimestamp = 0L;
    private static long ixExpire = 3600000L;
    private static HashMap VARTYPES = new HashMap();
    private SNMPClient client = new SNMPClient();
    private static Map ixCache = new HashMap();
    private static Object ixLock = new Object();
    private Log log;

    protected String[] getMIBs() {
        String prop = this.getPluginProperty("MIBS");
        if (prop == null) {
            return new String[0];
        }
        List mibs = StringUtil.explode((String)prop, (String)",");
        return mibs.toArray(new String[0]);
    }

    private static int convertVarType(Properties props) {
        Integer type;
        String var = props.getProperty(PROP_VARTYPE);
        if (var == null) {
            var = props.getProperty(PROP_INDEX_NAME) != null ? "index" : (props.getProperty(PROP_OID) != null ? "oid" : "single");
        }
        if ((type = (Integer)VARTYPES.get(var)) == null) {
            String msg = "Unsupported snmpVarType: '" + var + "'";
            throw new IllegalArgumentException(msg);
        }
        return type;
    }

    public void init(PluginManager manager) throws PluginException {
        String pdkDir;
        super.init(manager);
        this.log = this.getLog();
        String prop = "snmp.indexCacheExpire";
        String expire = manager.getProperty(prop);
        if (expire != null) {
            ixExpire = Integer.parseInt(expire) * 1000;
        }
        if ((pdkDir = ProductPluginManager.getPdkDir()) == null) {
            return;
        }
        MIBTree.setMibDir(pdkDir + "/mibs");
        try {
            if (this.client.init(manager.getProperties()) && this.data != null) {
                String jar = this.data.getFile();
                String[] mibs = this.getMIBs();
                if (jar.endsWith(".xml")) {
                    this.client.addMIBs(mibs);
                } else {
                    this.client.addMIBs(jar, mibs);
                }
            }
        }
        catch (SNMPException e) {
            throw new PluginException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private double getDoubleValue(SNMPValue snmpValue) throws PluginException {
        String invalidType = "SNMP query returned a string which could not be handled: ";
        switch (snmpValue.getType()) {
            case 0: 
            case 2: {
                try {
                    return snmpValue.toLong();
                }
                catch (SNMPException e) {
                    // empty catch block
                }
            }
            case 1: {
                String value = snmpValue.toString();
                if ("".equals(value)) {
                    this.log.debug((Object)"string value is empty, returning -1");
                    return -1.0;
                }
                try {
                    double val = Double.parseDouble(value);
                    this.log.debug((Object)"converted using Double.parseDouble");
                    return val;
                }
                catch (NumberFormatException e) {
                    try {
                        double val = snmpValue.toLong();
                        this.log.debug((Object)"converted using snmpValue.toLong");
                        return val;
                    }
                    catch (SNMPException e2) {
                        // empty catch block
                    }
                }
            }
        }
        throw new PluginException("SNMP query returned a string which could not be handled: " + snmpValue.toString());
    }

    private static boolean listIsEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }

    private MetricUnreachableException snmpConnectException(Metric metric, SNMPException e) {
        Properties props = metric.getObjectProperties();
        String cfg = props.getProperty("snmpIp", "127.0.0.1") + ":" + props.getProperty("snmpPort", SNMPClient.DEFAULT_PORT_STRING) + " " + props.getProperty("snmpVersion", SNMPClient.VALID_VERSIONS[1]) + "," + props.getProperty("snmpCommunity", SNMPClient.DEFAULT_COMMUNITY);
        String msg = "Unable to connect to SNMP Agent (" + cfg + ")";
        return new MetricUnreachableException(msg, (Throwable)((Object)e));
    }

    private boolean isAvail(Metric metric) {
        return "true".equals(metric.getObjectProperty("Avail"));
    }

    /*
     * Unable to fully structure code
     */
    public MetricValue getValue(Metric metric) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        isDebug = this.log.isDebugEnabled();
        session = this.getSession(metric);
        if (session == null) {
            throw new PluginException("SNMPSession was null!");
        }
        props = metric.getProperties();
        value = 0.0;
        varName = metric.getAttributeName();
        if (varName == null || varName.length() == 0 || varName.equals("%oid%")) {
            return MetricValue.NONE;
        }
        varOID = this.getPluginProperty(varName);
        if (varOID != null) {
            if (isDebug) {
                this.log.debug((Object)(this.getName() + " defined " + varName + " to " + varOID));
            }
            varName = varOID;
        }
        varType = SNMPMeasurementPlugin.convertVarType(props);
        timer = null;
        if (isDebug) {
            timer = new StopWatch();
        }
        if (varType == 0 || varType == 1) {
            try {
                snmpValue = varType == 0 ? session.getSingleValue(varName) : session.getNextValue(varName);
            }
            catch (MIBLookupException e) {
                throw new MetricInvalidException(e.getMessage());
            }
            catch (SNMPException e) {
                if (this.isAvail(metric)) {
                    var15_19 = new MetricValue(0.0);
                    return var15_19;
                }
                throw this.snmpConnectException(metric, e);
            }
            finally {
                if (timer != null) {
                    this.log.debug((Object)("getValue took: " + timer));
                }
            }
            value = this.getDoubleValue(snmpValue);
        } else {
            try {
                switch (varType) {
                    case 3: {
                        columnOfValues = session.getBulk(varName);
                        if (SNMPMeasurementPlugin.listIsEmpty(columnOfValues)) {
                            msg = "Column data not found: " + varName;
                            throw new MetricNotFoundException(msg);
                        }
                        size = columnOfValues.size();
                        index = this.getIndex(props, session);
                        if (index >= columnOfValues.size()) {
                            ix = props.getProperty("snmpIndexName");
                            val = props.getProperty("snmpIndexValue");
                            msg = "No value found for SNMP index: " + ix + "." + val;
                            throw new MetricNotFoundException(msg);
                        }
                        value = this.getDoubleValue((SNMPValue)columnOfValues.get(index));
                        ** break;
lbl53:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        idx = -1;
                        if (props.getProperty("snmpIndexName") != null) {
                            idx = this.getIndex(props, session);
                        }
                        oid = props.getProperty("snmpOID");
                        found = false;
                        snmpValue = session.getTableValue(varName, idx + 1, oid);
                        if (snmpValue != null) {
                            value = this.getDoubleValue(snmpValue);
                            found = true;
                        }
                        if (!found) {
                            msg = "OID not found: " + oid;
                            throw new MetricNotFoundException(msg);
                        }
                        break;
                    }
                    case 2: {
                        columnOfValues = session.getBulk(varName);
                        if (SNMPMeasurementPlugin.listIsEmpty(columnOfValues)) {
                            msg = "Column data not found: " + varName;
                            throw new MetricNotFoundException(msg);
                        }
                        size = columnOfValues.size();
                        for (i = 0; i < size; ++i) {
                            value += this.getDoubleValue((SNMPValue)columnOfValues.get(i));
                        }
                    }
                    default: {
                        throw new MetricNotFoundException("Invalid vartype");
                    }
                }
            }
            catch (SNMPException e) {
                if (this.isAvail(metric)) {
                    var14_18 = new MetricValue(0.0);
                    return var14_18;
                }
                throw this.snmpConnectException(metric, e);
            }
            finally {
                if (timer != null) {
                    this.log.debug((Object)("getValue took: " + timer + " (type=" + varType + ")"));
                }
            }
        }
        if (this.isAvail(metric)) {
            value = value <= 0.0 ? 0.0 : 1.0;
        }
        return new MetricValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndex(Properties props, SNMPSession session) throws MetricUnreachableException, MetricNotFoundException {
        String indexName = props.getProperty(PROP_INDEX_NAME);
        String indexValue = props.getProperty(PROP_INDEX_VALUE);
        if (indexName == null) {
            throw new MetricInvalidException("missing indexName");
        }
        if (indexValue == null) {
            throw new MetricInvalidException("missing indexValue");
        }
        Object object = ixLock;
        synchronized (object) {
            return this.getIndex(indexName, indexValue, session);
        }
    }

    private int getIndex(String indexName, String indexValue, SNMPSession session) throws MetricUnreachableException, MetricNotFoundException {
        int i;
        Integer ix;
        long timeNow = System.currentTimeMillis();
        boolean expired = false;
        if (timeNow - ixTimestamp > ixExpire) {
            if (ixTimestamp == 0L) {
                this.log.debug((Object)"initializing index cache");
            } else {
                this.log.debug((Object)"clearing index cache");
            }
            ixCache.clear();
            ixTimestamp = timeNow;
            expired = true;
        } else {
            ix = (Integer)ixCache.get(indexValue);
            if (ix != null) {
                return ix;
            }
        }
        List indexNames = StringUtil.explode((String)indexName, (String)"->");
        ArrayList<StringBuffer> data = new ArrayList<StringBuffer>();
        for (i = 0; i < indexNames.size(); ++i) {
            String name = (String)indexNames.get(i);
            List values = null;
            try {
                values = session.getBulk(name);
                for (int j = 0; j < values.size(); ++j) {
                    String value = values.get(j).toString();
                    StringBuffer buf = null;
                    if (data.size() - 1 >= j) {
                        buf = (StringBuffer)data.get(j);
                        buf.append("->").append(value);
                        continue;
                    }
                    buf = new StringBuffer(value);
                    data.add(buf);
                }
                continue;
            }
            catch (SNMPException e) {
                throw new MetricInvalidException((Throwable)((Object)e));
            }
        }
        for (i = data.size() - 1; i >= 0; --i) {
            StringBuffer buf = (StringBuffer)data.get(i);
            String cur = buf.toString();
            Integer index = new Integer(i);
            ixCache.put(cur, index);
            ixCache.put(cur.trim(), index);
        }
        if (this.log.isDebugEnabled()) {
            if (expired) {
                this.log.debug((Object)"built index cache:");
                for (Map.Entry ent : ixCache.entrySet()) {
                    this.log.debug((Object)("   " + ent.getKey() + "=>" + ent.getValue()));
                }
            } else {
                this.log.debug((Object)("forced to rebuild index cache looking for: " + indexValue));
            }
        }
        if ((ix = (Integer)ixCache.get(indexValue)) != null) {
            return ix;
        }
        String possibleValues = ", possible values=";
        possibleValues = SNMPMeasurementPlugin.listIsEmpty(data) ? possibleValues + "[NONE FOUND]" : possibleValues + data.toString();
        throw new MetricNotFoundException("could not find value '" + indexValue + "' in column '" + indexName + "'" + possibleValues);
    }

    private SNMPSession getSession(Metric metric) throws PluginException {
        Properties props = metric.getObjectProperties();
        if (props.get("snmpIp") == null) {
            props.put("snmpIp", metric.getDomainName());
        }
        try {
            return this.client.getSession(props);
        }
        catch (SNMPException e) {
            throw new PluginException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    static {
        VARTYPES.put("single", new Integer(0));
        VARTYPES.put("column", new Integer(2));
        VARTYPES.put("index", new Integer(3));
        VARTYPES.put("oid", new Integer(4));
        VARTYPES.put("next", new Integer(1));
    }
}

