/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Properties;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;

public class Win32MeasurementPlugin
extends MeasurementPlugin {
    public static final String DOMAIN = "win32";
    private static final String PROP_OBJECT = "Object";
    private static final String PROP_INSTANCE = "Instance";
    private static final String PROP_TYPE = "Type";

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (metric.getDomainName().equals(DOMAIN)) {
            return this.getValueProxy(metric);
        }
        return this.getValueCompat(metric);
    }

    private MetricValue getValueProxy(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Properties props = metric.getObjectProperties();
        String object = props.getProperty(PROP_OBJECT);
        String instance = props.getProperty(PROP_INSTANCE);
        String type = props.getProperty(PROP_TYPE);
        String counter = metric.getAttributeName();
        boolean isAvail = false;
        boolean isFormatted = false;
        if (type != null && !(isAvail = "Availability".equals(type))) {
            isFormatted = "Formatted".equals(type);
        }
        if (object == null && (object = props.getProperty("Service")) != null) {
            if (counter.equals("StartType")) {
                return new MetricValue((long)Win32MeasurementPlugin.getServiceStartType(object));
            }
            return this.getServiceValue(object);
        }
        if (object == null) {
            throw new MetricInvalidException(metric.toString());
        }
        StringBuffer name = new StringBuffer();
        name.append('\\').append(object);
        if (instance != null) {
            name.append('(').append(instance).append(')');
        }
        name.append('\\').append(counter);
        return this.getPdhValue(metric, name.toString(), isAvail, isFormatted);
    }

    private MetricValue getValueCompat(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String domain = this.getDomainName(metric);
        String attr = this.getAttributeName(metric);
        if (domain.equals("ServiceAvail")) {
            return this.getServiceValue(attr);
        }
        StringBuffer name = new StringBuffer();
        if (domain.charAt(0) != '\\') {
            name.append("\\");
        }
        name.append(domain);
        if (domain.charAt(domain.length() - 1) != '\\') {
            name.append("\\");
        }
        name.append(attr);
        String propString = metric.getObjectPropString();
        boolean isFormatted = false;
        boolean isAvail = false;
        if (propString.equals("Type=Formatted")) {
            isFormatted = true;
        } else if (propString.equals("Type=Availability")) {
            isAvail = true;
        }
        return this.getPdhValue(metric, name.toString(), isAvail, isFormatted);
    }

    protected String getAttributeName(Metric metric) {
        return metric.getAttributeName();
    }

    protected String getDomainName(Metric metric) {
        return metric.getDomainName();
    }

    protected double adjustValue(Metric metric, double value) {
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getServiceStatus(String name) {
        Service svc = null;
        try {
            svc = new Service(name);
            int n = svc.getStatus();
            return n;
        }
        catch (Win32Exception e) {
            int n = 1;
            return n;
        }
        finally {
            if (svc != null) {
                svc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getServiceStartType(String name) {
        Service svc = null;
        try {
            svc = new Service(name);
            int n = svc.getConfig().getStartType();
            return n;
        }
        catch (Win32Exception e) {
            int n = 4;
            return n;
        }
        finally {
            if (svc != null) {
                svc.close();
            }
        }
    }

    static boolean isServiceRunning(String name) {
        return Win32MeasurementPlugin.getServiceStatus(name) == 4;
    }

    private MetricValue getPdhValue(Metric metric, String counter, boolean isAvail, boolean isFormatted) throws MetricNotFoundException {
        MetricValue metricValue;
        Pdh pdh = null;
        try {
            pdh = new Pdh();
            double value = isFormatted ? pdh.getFormattedValue(counter) : pdh.getRawValue(counter);
            if (isAvail) {
                MetricValue metricValue2 = new MetricValue(1.0);
                return metricValue2;
            }
            metricValue = new MetricValue(this.adjustValue(metric, value), System.currentTimeMillis());
        }
        catch (Win32Exception e) {
            throw new MetricNotFoundException(counter);
        }
        finally {
            if (pdh != null) {
                try {
                    pdh.close();
                }
                catch (Win32Exception e) {}
            }
        }
        return metricValue;
    }

    private MetricValue getServiceValue(String name) {
        double avail;
        switch (Win32MeasurementPlugin.getServiceStatus(name)) {
            case 4: {
                avail = 1.0;
                break;
            }
            case 7: {
                avail = -0.01;
                break;
            }
            default: {
                avail = 0.0;
            }
        }
        return new MetricValue(avail);
    }
}

