/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.snmp4j.smi.OctetString;

public class MIBTree {
    public static final String PROP_MIBS_DIR = "snmp.mibs.dir";
    private static Log log = LogFactory.getLog((String)MIBTree.class.getName());
    private static final int INDEX = 1;
    private static final int IDENTIFIER = 2;
    private static final int NO_ACCESS = 4;
    private static final int MAX_OID_LEN = 127;
    private static final String QUOTE = "\"";
    private static final String ASSIGN = "::=";
    private static MIBTree instance = null;
    private HashMap parsedFiles = new HashMap();
    private HashMap table = new HashMap();
    private HashMap oids = new HashMap();
    private LineNumberReader reader;
    private List tokens = new ArrayList();
    private List previous = new ArrayList();
    private StringTokenizer tokenizer;
    private String currentMIB;
    private String lastLookupFailure;
    private boolean inDescription = false;
    private static final int T_NAME = 0;
    private static final int T_PARENT = 1;
    private static final int T_OID = 2;
    private static final String[][] SNMPv2_SMI = new String[][]{{"org", "iso", "3"}, {"dod", "org", "6"}, {"internet", "dod", "1"}, {"directory", "internet", "1"}, {"mgmt", "internet", "2"}, {"mib-2", "mgmt", "1"}, {"transmission", "mib-2", "10"}, {"experimental", "internet", "3"}, {"private", "internet", "4"}, {"enterprises", "private", "1"}, {"security", "internet", "5"}, {"snmpV2", "internet", "6"}, {"snmpDomains", "snmpV2", "1"}, {"snmpProxys", "snmpV2", "2"}, {"snmpModules", "snmpV2", "3"}};
    private static final String[][] SNMPv2_MIB = new String[][]{{"sysDescr", "system", "1"}, {"sysObjectID", "system", "2"}, {"sysUpTime", "system", "3"}, {"sysContact", "system", "4"}, {"sysName", "system", "5"}, {"sysLocation", "system", "6"}, {"sysServices", "system", "7"}};

    public MIBTree() {
        this.table.put("iso", new ISONode());
    }

    public void init() {
        this.currentMIB = "SNMPv2-SMI";
        this.add(SNMPv2_SMI, 2);
        this.currentMIB = "SNMPv2-MIB";
        this.add("system", "mib-2", "1", 2);
        this.add(SNMPv2_MIB, 0);
        this.currentMIB = null;
        String dir = System.getProperty(PROP_MIBS_DIR);
        if (dir != null) {
            File mibs = new File(dir);
            if (!mibs.exists()) {
                log.debug((Object)(mibs + " MIB dir does not exist"));
                return;
            }
            try {
                this.parse(mibs);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static synchronized MIBTree getInstance() {
        if (instance == null) {
            instance = new MIBTree();
            instance.init();
        }
        return instance;
    }

    MIBNode lookup(String name) {
        return (MIBNode)this.table.get(name);
    }

    public static void setMibDir(String dir) {
        System.setProperty(PROP_MIBS_DIR, dir);
    }

    public static String toString(int[] oid) {
        StringBuffer buffer = new StringBuffer(oid.length * 2);
        buffer.append(oid[0]);
        for (int i = 1; i < oid.length; ++i) {
            buffer.append('.').append(oid[i]);
        }
        return buffer.toString();
    }

    public int[] getOID(String name) {
        int[] oid = (int[])this.oids.get(name);
        if (oid != null) {
            return oid;
        }
        if (name.indexOf(46) != -1) {
            StringTokenizer tok = new StringTokenizer(name, ".");
            int[] scratch = new int[127];
            int ix = 0;
            while (tok.hasMoreTokens()) {
                int[] subnode;
                String node = tok.nextToken();
                if (Character.isDigit(node.charAt(0))) {
                    scratch[ix++] = Integer.parseInt(node);
                    continue;
                }
                int len = node.length() - 1;
                int quote = 39;
                if (node.charAt(0) == '\'' && node.charAt(len) == '\'') {
                    node = node.substring(1, len);
                    subnode = new OctetString(node).toSubIndex(false).getValue();
                } else {
                    subnode = this.getOID(node);
                }
                if (subnode == null) {
                    return null;
                }
                System.arraycopy(subnode, 0, scratch, ix, subnode.length);
                ix += subnode.length;
            }
            oid = new int[ix];
            System.arraycopy(scratch, 0, oid, 0, ix);
        } else {
            MIBNode mibnode = this.lookup(name);
            if (mibnode == null) {
                return null;
            }
            oid = mibnode.getOID(name);
            if (oid == null) {
                log.warn((Object)(name + " found in tree but unable to resolve OID." + " lastLookupFailure=" + this.lastLookupFailure));
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + " resolved to: " + MIBTree.toString(oid)));
        }
        this.oids.put(name, oid);
        return oid;
    }

    private void add(String[][] table, int flags) {
        for (int i = 0; i < table.length; ++i) {
            String[] entry = table[i];
            this.add(entry[0], entry[1], entry[2], flags);
        }
    }

    private void add(String name, String parent, String oid, int flags) {
        boolean isDebug = log.isDebugEnabled();
        MIBNode node = (MIBNode)this.table.get(name);
        if (node != null) {
            if (isDebug) {
                log.debug((Object)(this.currentMIB + "." + name + " already added by " + node.getMIB()));
            }
            return;
        }
        node = isDebug ? new DebugMIBNode(oid, parent) : new MIBNode(oid, parent);
        node.flags = flags;
        this.table.put(name, node);
    }

    private String token(int ix) {
        if (ix < this.tokens.size()) {
            return (String)this.tokens.get(ix);
        }
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            this.tokens.add(token);
            if (ix + 1 != this.tokens.size()) continue;
            return token;
        }
        return "";
    }

    private String where(int start) {
        return " at " + this.currentMIB + ":" + (start == 0 ? "" : start + "..") + this.reader.getLineNumber();
    }

    private void tokenize(String line) {
        this.previous.clear();
        this.previous.addAll(this.tokens);
        this.tokens.clear();
        if (line == null) {
            line = "";
        }
        this.tokenizer = new StringTokenizer(line);
    }

    private String readToLine(String contains) throws IOException {
        String line;
        int start = this.reader.getLineNumber();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(contains) == -1) continue;
            return line;
        }
        throw new IOException("Expecting '" + contains + "'" + " not found" + this.where(start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String skipDescription(String line) throws IOException {
        this.inDescription = true;
        try {
            if (line.indexOf(QUOTE) == -1) {
                line = this.readToLine(QUOTE);
            }
            if (!line.endsWith(QUOTE)) {
                line = this.readToLine(QUOTE);
            }
            String string = this.readLine();
            return string;
        }
        finally {
            this.inDescription = false;
        }
    }

    private String readLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("--")) continue;
            int ix = line.indexOf("--");
            if (ix != -1) {
                line = line.substring(0, ix).trim();
            }
            if (line.length() == 0) continue;
            if (!this.inDescription && line.startsWith("DESCRIPTION")) {
                return this.skipDescription(line);
            }
            return line;
        }
        return null;
    }

    private void parseId(String name, String line, int flags) throws IOException {
        if (line.endsWith(ASSIGN)) {
            line = this.readLine();
        }
        int start = line.indexOf(123);
        int end = line.indexOf(125);
        if (start != -1 && end == -1) {
            String nextLine;
            do {
                nextLine = this.readLine();
            } while ((end = (line = line + " " + nextLine).indexOf(125)) == -1);
        }
        if (start == -1 || end == -1) {
            throw new IOException("Expecting ::= {...}  in " + line + this.where(0));
        }
        StringTokenizer tok = new StringTokenizer(line = line.substring(start + 1, end).trim());
        int numTokens = tok.countTokens();
        if (numTokens < 2) {
            throw new IOException("Invalid ID in " + line + this.where(0));
        }
        if (numTokens == 2) {
            String parent = tok.nextToken();
            String number = tok.nextToken();
            this.add(name, parent, number, flags);
        } else {
            String parent = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                int openParen = next.indexOf(40);
                if (openParen != -1) {
                    int closeParen = next.indexOf(41);
                    if (closeParen == -1) {
                        throw new IOException("Expecting ')' in " + line + this.where(0));
                    }
                    String subName = next.substring(0, openParen);
                    String subNum = next.substring(openParen + 1, closeParen);
                    this.add(subName, parent, subNum, 2);
                    parent = subName;
                    continue;
                }
                this.add(name, parent, next, flags);
            }
        }
    }

    private void parseObjectType() throws IOException {
        String line;
        String name = this.token(0);
        int flags = 4;
        while ((line = this.readLine()) != null && line.indexOf(ASSIGN) == -1) {
            if (line.startsWith("INDEX")) {
                flags |= 1;
                continue;
            }
            if (line.startsWith("SYNTAX")) {
                if (line.indexOf("SEQUENCE") == -1) continue;
                flags |= 1;
                continue;
            }
            if (!line.startsWith("ACCESS") && !line.startsWith("MAX-ACCESS") || line.indexOf("not-accessible") != -1) continue;
            flags &= 0xFFFFFFFB;
        }
        this.parseId(name, line, flags);
    }

    private void parseObjectIdentifier(String line) throws IOException {
        String name = this.token(0);
        if (line.indexOf(ASSIGN) == -1) {
            line = this.readToLine(ASSIGN);
        }
        this.parseId(name, line, 2);
    }

    private boolean hasParsedFile(File file) {
        String name = file.getName();
        if (this.parsedFiles.get(name) != null) {
            return true;
        }
        this.parsedFiles.put(name, Boolean.TRUE);
        return false;
    }

    private boolean parseFile(File file) throws IOException {
        return this.parse(file.toString(), new FileInputStream(file));
    }

    public boolean parse(JarFile jar) throws IOException {
        return this.parse(jar, null);
    }

    public boolean parse(JarFile jar, String[] accept) throws IOException {
        AcceptFilter filter = new AcceptFilter(accept);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            String name;
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith("mibs/") || !filter.accept(name = entry.getName().substring(5)) || this.hasParsedFile(new File(name))) continue;
            String where = jar.getName() + "!" + entry.getName();
            this.parse(where, jar.getInputStream(entry));
        }
        return true;
    }

    public boolean parse(File file) throws IOException {
        return this.parse(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(File file, String[] accept) throws IOException {
        if (this.hasParsedFile(file)) {
            return true;
        }
        if (file.isDirectory()) {
            File[] mibs = file.listFiles();
            if (mibs == null || mibs.length == 0) {
                log.debug((Object)("No MIBs in directory: " + file));
                return false;
            }
            AcceptFilter filter = new AcceptFilter(accept);
            log.debug((Object)("Loading MIBs in directory: " + file));
            for (int i = 0; i < mibs.length; ++i) {
                File mib = mibs[i];
                if (mib.isDirectory() || !filter.accept(mib.getName())) continue;
                this.parseFile(mib);
            }
            return true;
        }
        if (file.getName().endsWith(".jar")) {
            JarFile jar = new JarFile(file);
            try {
                boolean bl = this.parse(jar, accept);
                return bl;
            }
            finally {
                jar.close();
            }
        }
        return this.parseFile(file);
    }

    public boolean parse(URL url) throws IOException {
        if (this.hasParsedFile(new File(url.getFile()))) {
            return true;
        }
        return this.parse(url.toString(), url.openStream());
    }

    public boolean parse(String name, InputStream is) throws IOException {
        boolean isSuccess = false;
        try {
            isSuccess = this.parse(is);
        }
        catch (IOException e) {
            throw new IOException("Failed to load MIB: '" + name + "': " + e);
        }
        log.debug((Object)("Loading MIB: '" + name + "': " + (isSuccess ? "success" : "skipped")));
        return isSuccess;
    }

    public boolean parse(InputStream is) throws IOException {
        this.lastLookupFailure = null;
        try {
            boolean bl = this.parseMIB(is);
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e + this.where(0));
        }
        finally {
            this.tokens.clear();
            this.previous.clear();
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public String getLastLookupFailure() {
        return this.lastLookupFailure;
    }

    private boolean parseMIB(InputStream is) throws IOException {
        String line;
        this.reader = new LineNumberReader(new InputStreamReader(is));
        this.currentMIB = "";
        this.tokenize(this.readLine());
        if (!this.token(1).equals("DEFINITIONS")) {
            return false;
        }
        this.currentMIB = this.token(0);
        int size = this.table.size();
        while ((line = this.readLine()) != null) {
            String second;
            this.tokenize(line);
            String first = this.token(0);
            if (first.equals("IMPORTS") || first.equals("EXPORTS")) {
                this.readToLine(";");
                continue;
            }
            if (first.equals("SYNTAX") || (second = this.token(1)) == null) continue;
            if (line.indexOf("SEQUENCE {") != -1 || line.indexOf("CHOICE {") != -1) {
                this.readToLine("}");
                continue;
            }
            if (second.equals("OBJECT") && this.token(2).equals("IDENTIFIER")) {
                this.parseObjectIdentifier(line);
                continue;
            }
            if (this.previous.size() == 1 && first.equals("OBJECT") && second.equals("IDENTIFIER")) {
                Object name = this.previous.get(0);
                line = name + " " + line;
                this.tokens.add(0, name);
                this.parseObjectIdentifier(line);
                continue;
            }
            if (!second.equals("OBJECT-TYPE") && !second.equals("MODULE-IDENTITY") && !second.equals("OBJECT-IDENTITY")) continue;
            this.parseObjectType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.currentMIB + " added " + (this.table.size() - size) + " entries"));
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        MIBTree tree = MIBTree.getInstance();
        for (i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            if (file.exists()) {
                if (!tree.parse(file)) {
                    System.out.println(args[i] + " is not valid MIB");
                    continue;
                }
                System.out.println(args[i] + " parsed");
                continue;
            }
            names.add(args[i]);
        }
        if (names.size() == 0) {
            names.addAll(tree.table.keySet());
        }
        for (i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            int[] oid = tree.getOID(name);
            if (oid == null) {
                System.out.println("Failed to get oid for: " + name + " (lastLookupFailure=" + tree.lastLookupFailure + ")");
                continue;
            }
            System.out.println(name + "=" + MIBTree.toString(oid));
        }
    }

    private class AcceptFilter {
        List filter = null;

        AcceptFilter(String[] accept) {
            if (accept != null && accept.length != 0) {
                this.filter = Arrays.asList(accept);
            }
        }

        boolean accept(String name) {
            if (this.filter != null) {
                return this.filter.contains(name);
            }
            return true;
        }
    }

    class DebugMIBNode
    extends MIBNode {
        String mib;

        DebugMIBNode(String oid, String parent) {
            super(oid, parent);
            if (instance != null) {
                this.mib = instance.currentMIB;
            }
        }

        String getMIB() {
            return this.mib;
        }
    }

    class ISONode
    extends MIBNode {
        ISONode() {
            super("1", null);
            this.flags = 2;
        }
    }

    class MIBNode {
        String parent;
        String oid;
        int flags = 0;

        MIBNode(String oid, String parent) {
            this.oid = oid.intern();
            this.parent = parent;
        }

        MIBNode getParent() {
            return MIBTree.this.lookup(this.parent);
        }

        String getMIB() {
            return "unknown";
        }

        boolean hasFlag(int flag) {
            return (this.flags & flag) != 0;
        }

        int[] getOID(String name) {
            int[] scratch = new int[127];
            int ix = scratch.length;
            MIBNode node = this;
            boolean indexApplies = !this.hasFlag(2) && !this.hasFlag(4);
            boolean hasIndex = false;
            boolean isDebug = log.isDebugEnabled();
            while (node != null && ix > 0) {
                scratch[--ix] = Integer.parseInt(node.oid);
                MIBNode parent = node.getParent();
                if (parent == null) {
                    if (node.getClass() == ISONode.class) break;
                    MIBTree.this.lastLookupFailure = node.parent;
                    return null;
                }
                if (parent.hasFlag(1)) {
                    hasIndex = true;
                }
                node = parent;
            }
            boolean addIndex = indexApplies && !hasIndex;
            int len = scratch.length - ix;
            int alloc = addIndex ? len + 1 : len;
            int[] oid = new int[alloc];
            System.arraycopy(scratch, ix, oid, 0, len);
            if (addIndex) {
                oid[len] = 0;
                if (isDebug) {
                    log.debug((Object)(this.getMIB() + "." + name + " has no index, appending .0"));
                }
            }
            return oid;
        }
    }
}

