/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.tomcat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class TomcatServerDetector
extends MxServerDetector {
    private static final String TOMCAT_PARAMS_KEY = "\\Parameters\\Java";
    private static final String TOMCAT_SERVICE_KEY = "SOFTWARE\\Apache Software Foundation\\Procrun 2.0";
    private static final String PTQL_QUERY_WIN32 = "Pid.Service.eq=%service_name%";
    private static final String CATALINA_BASE_PROP = "-Dcatalina.base=";
    private static final String TOMCAT_DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:6969/jmxrmi";
    private static final String PTQL_CONFIG_OPTION = "process.query";
    private static final String CATALINA_HOME_PROP = "-Dcatalina.home=";
    private Log log = LogFactory.getLog(TomcatServerDetector.class);

    private ServerResource getServerResource(String win32Service, List options) throws PluginException {
        if (!this.isWin32ServiceRunning(win32Service)) {
            this.log.debug((Object)(win32Service + " is not running, skipping."));
            return null;
        }
        String[] args = options.toArray(new String[0]);
        String catalinaBase = this.getCatalinaBase(args);
        if (catalinaBase == null) {
            this.log.error((Object)("No Catalina Base found for service " + win32Service + ". Skipping.."));
            return null;
        }
        File catalinaBaseDir = new File(catalinaBase);
        if (!catalinaBaseDir.exists()) {
            this.log.error((Object)("Resolved catalina base " + catalinaBase + " is not a valid directory. Skipping Tomcat service " + win32Service));
            return null;
        }
        this.log.debug((Object)("Successfully detected Catalina Base for service: " + catalinaBase + " options=" + options));
        String path = catalinaBaseDir.getAbsolutePath();
        if (!this.isCorrectVersion(catalinaBase + "/lib/catalina.jar")) {
            return null;
        }
        ServerResource server = this.createServerResource(path);
        ConfigResponse config = new ConfigResponse();
        config.setValue("jmx.url", TOMCAT_DEFAULT_URL);
        for (int i = 0; i < args.length && !this.configureMxURL(config, args[i]); ++i) {
        }
        config.setValue("service_name", win32Service);
        config.setValue(PTQL_CONFIG_OPTION, PTQL_QUERY_WIN32);
        server.setName(server.getName() + " " + win32Service);
        server.setProductConfig(config);
        server.setMeasurementConfig();
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getServicesFromRegistry() {
        RegistryKey key = null;
        String[] services = null;
        try {
            key = RegistryKey.LocalMachine.openSubKey(TOMCAT_SERVICE_KEY);
            services = key.getSubKeyNames();
        }
        catch (Win32Exception win32Exception) {
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getServerRegistryMap() {
        HashMap serverMap = new HashMap();
        String[] services = this.getServicesFromRegistry();
        if (services == null) {
            return serverMap;
        }
        for (int i = 0; i < services.length; ++i) {
            this.log.debug((Object)("Detected Tomcat service " + services[i]));
            ArrayList options = new ArrayList();
            RegistryKey key = null;
            try {
                key = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\Apache Software Foundation\\Procrun 2.0\\" + services[i] + TOMCAT_PARAMS_KEY);
                key.getMultiStringValue("Options", options);
            }
            catch (Win32Exception e) {
                this.log.error((Object)("Failed to find Java parameters for Tomcat service " + services[i]));
                continue;
            }
            finally {
                if (key != null) {
                    key.close();
                }
            }
            serverMap.put(services[i], options);
        }
        return serverMap;
    }

    protected boolean isInstallTypeVersion(MxServerDetector.MxProcess process) {
        String[] processArgs = process.getArgs();
        String catalinaHome = this.getCatalinaHome(processArgs);
        String catalinaBase = this.getCatalinaBase(processArgs);
        String bootstrapJar = this.getBootstrapJar(processArgs);
        boolean correctVersion = false;
        if (bootstrapJar != null) {
            correctVersion = this.isCorrectVersion(bootstrapJar);
        } else {
            correctVersion = this.isInstallTypeVersion(catalinaBase);
            if (!correctVersion) {
                if (catalinaHome == null) {
                    this.getLog().warn((Object)("Unable to determine Tomcat version of possible Tomcat process with install path: " + process.getInstallPath() + ".  Could not find value of catalina.home in process system properties.  This process will be skipped."));
                    return false;
                }
                correctVersion = this.isInstallTypeVersion(catalinaHome);
            }
        }
        if (!correctVersion) {
            return false;
        }
        Iterator keys = PluginData.getGlobalProperties().keySet().iterator();
        String extend_server = null;
        while (keys.hasNext()) {
            String tcServerVersionFile;
            String key = (String)keys.next();
            if (!key.toUpperCase().endsWith(".EXTENDS")) continue;
            String val = (String)PluginData.getGlobalProperties().get(key);
            Pattern p = Pattern.compile(val);
            Matcher m = p.matcher(this.getTypeInfo().getName());
            boolean find = m.find();
            this.getLog().debug((Object)("[isInstallTypeVersion] " + key + "=" + val + " (" + this.getTypeInfo().getName() + ") m.find()=" + find));
            if (!find || (tcServerVersionFile = this.getTypeProperty(extend_server = key.substring(0, key.lastIndexOf(".")), "VERSION_FILE")) == null) continue;
            File homeVersionFile = new File(catalinaHome, tcServerVersionFile);
            File baseVersionFile = new File(catalinaBase, tcServerVersionFile);
            if ((homeVersionFile.exists() || baseVersionFile.exists()) && this.findVersionFile(new File(catalinaBase), Pattern.compile("hq-common.*\\.jar")) == null) {
                this.getLog().debug((Object)("[isInstallTypeVersion] '" + this.getTypeInfo().getName() + " [" + process.getInstallPath() + "]' is a '" + extend_server + "'"));
                return false;
            }
            this.getLog().debug((Object)("[isInstallTypeVersion] '" + this.getTypeInfo().getName() + " [" + process.getInstallPath() + "]' is not a '" + extend_server + "'"));
        }
        return true;
    }

    protected String getCatalinaHome(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(CATALINA_HOME_PROP)) continue;
            return args[i].substring(CATALINA_HOME_PROP.length());
        }
        return null;
    }

    protected String getProcQuery(String path) {
        String query = super.getProcessQuery();
        if (path != null) {
            query = query + path;
        }
        return query;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        List servers = super.getServerResources(platformConfig);
        if (TomcatServerDetector.isWin32()) {
            Map registryMap = this.getServerRegistryMap();
            for (String serviceName : registryMap.keySet()) {
                List options;
                ServerResource server = this.getServerResource(serviceName, options = (List)registryMap.get(serviceName));
                if (server == null) continue;
                servers.add(server);
            }
        }
        if (servers != null) {
            for (Object server : servers) {
                ((ServerResource)server).setControlConfig();
            }
        }
        return servers;
    }

    private String getBootstrapJar(String[] args) {
        String res = null;
        for (int i = 0; i < args.length && res == null; ++i) {
            if (!args[i].equalsIgnoreCase("-classpath")) continue;
            String[] cp = args[i + 1].split(File.pathSeparator);
            for (int c = 0; c < cp.length && res == null; ++c) {
                if (!cp[c].endsWith("bootstrap.jar")) continue;
                res = cp[c];
            }
        }
        this.log.debug((Object)("[getBootstrapJar] res='" + res + "'"));
        return res;
    }

    private String getCatalinaBase(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(CATALINA_BASE_PROP)) continue;
            return args[i].substring(CATALINA_BASE_PROP.length());
        }
        return null;
    }

    protected void setProductConfig(ServerResource server, ConfigResponse config, long pid) {
        this.populateListeningPorts(pid, config, true);
        super.setProductConfig(server, config);
    }

    protected ServerResource getServerResource(MxServerDetector.MxProcess process) {
        ServerResource server = super.getServerResource(process);
        String catalinaBase = server.getInstallPath();
        File hq = this.findVersionFile(new File(catalinaBase), Pattern.compile("hq-common.*\\.jar"));
        if (hq != null) {
            server.setName(TomcatServerDetector.getPlatformName() + " Hyperic - Apache Tomcat " + this.getTypeInfo().getVersion());
            server.setIdentifier("HQ Tomcat");
        }
        return server;
    }

    public int getScanOrder() {
        return 0;
    }

    private boolean isCorrectVersion(String versionJar) {
        boolean correctVersion = false;
        try {
            JarFile jarFile = new JarFile(versionJar);
            this.log.debug((Object)("[isInstallTypeVersion] versionJar='" + jarFile.getName() + "'"));
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            jarFile.close();
            String tomcatVersion = attributes.getValue("Specification-Version");
            String expectedVersion = this.getTypeProperty("tomcatVersion");
            if (expectedVersion == null) {
                expectedVersion = this.getTypeInfo().getVersion();
            }
            this.log.debug((Object)("[isInstallTypeVersion] tomcatVersion='" + tomcatVersion + "' (" + expectedVersion + ")"));
            correctVersion = tomcatVersion.equals(expectedVersion);
        }
        catch (IOException e) {
            this.log.debug((Object)("Error getting Tomcat version (" + e + ")"), (Throwable)e);
        }
        return correctVersion;
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            this.log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            this.log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

