/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;

public class EnumVisitor
extends ClassCodeVisitorSupport {
    private static final int FS = 24;
    private static final int PS = 9;
    private static final int PUBLIC_FS = 25;
    private static final int PRIVATE_FS = 26;
    private final CompilationUnit compilationUnit;
    private final SourceUnit sourceUnit;

    public EnumVisitor(CompilationUnit cu, SourceUnit su) {
        this.compilationUnit = cu;
        this.sourceUnit = su;
    }

    public void visitClass(ClassNode node) {
        if (!node.isEnum()) {
            return;
        }
        this.completeEnum(node);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private void completeEnum(ClassNode enumClass) {
        boolean isAic = this.isAnonymousInnerClass(enumClass);
        FieldNode minValue = null;
        FieldNode maxValue = null;
        FieldNode values = null;
        if (!isAic) {
            values = new FieldNode("$VALUES", 4122, enumClass.makeArray(), enumClass, null);
            values.setSynthetic(true);
            this.addMethods(enumClass, values);
            minValue = new FieldNode("MIN_VALUE", 25, enumClass, enumClass, null);
            maxValue = new FieldNode("MAX_VALUE", 25, enumClass, enumClass, null);
        }
        this.addInit(enumClass, minValue, maxValue, values, isAic);
    }

    private void addMethods(ClassNode enumClass, FieldNode values) {
        BlockStatement ifStatement;
        BlockStatement code;
        MethodNode nextMethod;
        Token assign;
        List<MethodNode> methods = enumClass.getMethods();
        boolean hasNext = false;
        boolean hasPrevious = false;
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode m = methods.get(i);
            if (m.getName().equals("next") && m.getParameters().length == 0) {
                hasNext = true;
            }
            if (m.getName().equals("previous") && m.getParameters().length == 0) {
                hasPrevious = true;
            }
            if (hasNext && hasPrevious) break;
        }
        MethodNode valuesMethod = new MethodNode("values", 25, enumClass.makeArray(), new Parameter[0], ClassNode.EMPTY_ARRAY, null);
        valuesMethod.setSynthetic(true);
        BlockStatement code2 = new BlockStatement();
        code2.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new FieldExpression(values), "clone", MethodCallExpression.NO_ARGUMENTS)));
        valuesMethod.setCode(code2);
        enumClass.addMethod(valuesMethod);
        if (!hasNext) {
            assign = Token.newSymbol(100, -1, -1);
            Token ge = Token.newSymbol(127, -1, -1);
            nextMethod = new MethodNode("next", 1, enumClass, new Parameter[0], ClassNode.EMPTY_ARRAY, null);
            nextMethod.setSynthetic(true);
            code = new BlockStatement();
            ifStatement = new BlockStatement();
            ifStatement.addStatement(new ExpressionStatement(new BinaryExpression(new VariableExpression("ordinal"), assign, new ConstantExpression(0))));
            code.addStatement(new ExpressionStatement(new DeclarationExpression(new VariableExpression("ordinal"), assign, (Expression)new MethodCallExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "ordinal", MethodCallExpression.NO_ARGUMENTS), "next", MethodCallExpression.NO_ARGUMENTS))));
            code.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(new VariableExpression("ordinal"), ge, new MethodCallExpression((Expression)new FieldExpression(values), "size", MethodCallExpression.NO_ARGUMENTS))), ifStatement, EmptyStatement.INSTANCE));
            code.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new FieldExpression(values), "getAt", (Expression)new VariableExpression("ordinal"))));
            nextMethod.setCode(code);
            enumClass.addMethod(nextMethod);
        }
        if (!hasPrevious) {
            assign = Token.newSymbol(100, -1, -1);
            Token lt = Token.newSymbol(124, -1, -1);
            nextMethod = new MethodNode("previous", 1, enumClass, new Parameter[0], ClassNode.EMPTY_ARRAY, null);
            nextMethod.setSynthetic(true);
            code = new BlockStatement();
            ifStatement = new BlockStatement();
            ifStatement.addStatement(new ExpressionStatement(new BinaryExpression(new VariableExpression("ordinal"), assign, new MethodCallExpression((Expression)new MethodCallExpression((Expression)new FieldExpression(values), "size", MethodCallExpression.NO_ARGUMENTS), "minus", (Expression)new ConstantExpression(1)))));
            code.addStatement(new ExpressionStatement(new DeclarationExpression(new VariableExpression("ordinal"), assign, (Expression)new MethodCallExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "ordinal", MethodCallExpression.NO_ARGUMENTS), "previous", MethodCallExpression.NO_ARGUMENTS))));
            code.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(new VariableExpression("ordinal"), lt, new ConstantExpression(0))), ifStatement, EmptyStatement.INSTANCE));
            code.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new FieldExpression(values), "getAt", (Expression)new VariableExpression("ordinal"))));
            nextMethod.setCode(code);
            enumClass.addMethod(nextMethod);
        }
        Parameter stringParameter = new Parameter(ClassHelper.STRING_TYPE, "name");
        MethodNode valueOfMethod = new MethodNode("valueOf", 9, enumClass, new Parameter[]{stringParameter}, ClassNode.EMPTY_ARRAY, null);
        ArgumentListExpression callArguments = new ArgumentListExpression();
        callArguments.addExpression(new ClassExpression(enumClass));
        callArguments.addExpression(new VariableExpression("name"));
        code = new BlockStatement();
        code.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new ClassExpression(ClassHelper.Enum_Type), "valueOf", (Expression)callArguments)));
        valueOfMethod.setCode(code);
        valueOfMethod.setSynthetic(true);
        enumClass.addMethod(valueOfMethod);
    }

    private void addInit(ClassNode enumClass, FieldNode minValue, FieldNode maxValue, FieldNode values, boolean isAic) {
        this.addConstructor(enumClass);
        Parameter[] parameter = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "para")};
        MethodNode initMethod = new MethodNode("$INIT", 25, enumClass, parameter, ClassNode.EMPTY_ARRAY, null);
        initMethod.setSynthetic(true);
        ConstructorCallExpression cce = new ConstructorCallExpression(ClassNode.THIS, new ArgumentListExpression(new SpreadExpression(new VariableExpression("para"))));
        BlockStatement code = new BlockStatement();
        code.addStatement(new ReturnStatement(cce));
        initMethod.setCode(code);
        enumClass.addMethod(initMethod);
        List<FieldNode> fields = enumClass.getFields();
        ArrayList<Expression> arrayInit = new ArrayList<Expression>();
        int value = -1;
        Token assign = Token.newSymbol(100, -1, -1);
        ArrayList<Statement> block = new ArrayList<Statement>();
        FieldNode tempMin = null;
        FieldNode tempMax = null;
        for (FieldNode field : fields) {
            if ((field.getModifiers() & 0x4000) == 0) continue;
            ++value;
            if (tempMin == null) {
                tempMin = field;
            }
            tempMax = field;
            ClassNode enumBase = enumClass;
            ArgumentListExpression args = new ArgumentListExpression();
            args.addExpression(new ConstantExpression(field.getName()));
            args.addExpression(new ConstantExpression(value));
            if (field.getInitialExpression() != null) {
                ListExpression oldArgs = (ListExpression)field.getInitialExpression();
                for (Expression exp : oldArgs.getExpressions()) {
                    InnerClassNode inner;
                    if (exp instanceof ClassExpression && exp.getType() instanceof InnerClassNode && (inner = (InnerClassNode)exp.getType()).getVariableScope() == null) {
                        enumBase = inner;
                        continue;
                    }
                    args.addExpression(exp);
                }
            }
            field.setInitialValueExpression(null);
            block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(field), assign, new StaticMethodCallExpression(enumBase, "$INIT", args))));
            arrayInit.add(new FieldExpression(field));
        }
        if (!isAic) {
            if (tempMin != null) {
                block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(minValue), assign, new FieldExpression(tempMin))));
                block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(maxValue), assign, new FieldExpression(tempMax))));
                enumClass.addField(minValue);
                enumClass.addField(maxValue);
            }
            block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(values), assign, new ArrayExpression(enumClass, arrayInit))));
            enumClass.addField(values);
        }
        enumClass.addStaticInitializerStatements(block, true);
    }

    private boolean isAnonymousInnerClass(ClassNode enumClass) {
        if (!(enumClass instanceof InnerClassNode)) {
            return false;
        }
        InnerClassNode ic = (InnerClassNode)enumClass;
        return ic.getVariableScope() == null;
    }

    private void addConstructor(ClassNode enumClass) {
        ArrayList<ConstructorNode> ctors = new ArrayList<ConstructorNode>(enumClass.getDeclaredConstructors());
        if (ctors.size() == 0) {
            ConstructorNode init = new ConstructorNode(1, new Parameter[0], ClassNode.EMPTY_ARRAY, new BlockStatement());
            enumClass.addConstructor(init);
            ctors.add(init);
        }
        for (ConstructorNode ctor : ctors) {
            if (ctor.firstStatementIsSpecialConstructorCall()) continue;
            Parameter[] oldP = ctor.getParameters();
            Parameter[] newP = new Parameter[oldP.length + 2];
            String stringParameterName = this.getUniqueVariableName("__str", ctor.getCode());
            newP[0] = new Parameter(ClassHelper.STRING_TYPE, stringParameterName);
            String intParameterName = this.getUniqueVariableName("__int", ctor.getCode());
            newP[1] = new Parameter(ClassHelper.int_TYPE, intParameterName);
            System.arraycopy(oldP, 0, newP, 2, oldP.length);
            ctor.setParameters(newP);
            ConstructorCallExpression cce = new ConstructorCallExpression(ClassNode.SUPER, new ArgumentListExpression(new VariableExpression(stringParameterName), new VariableExpression(intParameterName)));
            BlockStatement code = new BlockStatement();
            code.addStatement(new ExpressionStatement(cce));
            Statement oldCode = ctor.getCode();
            if (oldCode != null) {
                code.addStatement(oldCode);
            }
            ctor.setCode(code);
        }
    }

    private String getUniqueVariableName(final String name, Statement code) {
        if (code == null) {
            return name;
        }
        final Object[] found = new Object[1];
        CodeVisitorSupport cv = new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                if (expression.getName().equals(name)) {
                    found[0] = Boolean.TRUE;
                }
            }
        };
        code.visit(cv);
        if (found[0] != null) {
            return this.getUniqueVariableName("_" + name, code);
        }
        return name;
    }
}

