/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hqagent;

import org.hyperic.hq.plugin.hqagent.AgentConfigTrackPlugin;
import org.hyperic.hq.plugin.hqagent.AgentLogTrackPlugin;
import org.hyperic.hq.plugin.hqagent.AgentMeasurementPlugin;
import org.hyperic.hq.plugin.hqagent.AgentServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;

public class AgentProductPlugin
extends ProductPlugin {
    public static final String NAME = "camagent";
    static final String SERVER_NAME = "HQ Agent";
    static final String SERVER_DESC = "Server";
    public static final String FULL_SERVER_NAME = "HQ Agent";

    public AgentProductPlugin() {
        this.setName(NAME);
    }

    public ConfigSchema getCustomPropertiesSchema(String name) {
        ConfigSchema schema = new ConfigSchema();
        StringConfigOption opt = new StringConfigOption("version", "Agent Version");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("build", "Agent Build");
        opt.setOptional(true);
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("JavaVersion", "Java Version");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("JavaVendor", "Java Vendor");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("UserHome", "User Home");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("SigarVersion", "Sigar Version");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("SigarNativeVersion", "Sigar Native Version");
        schema.addOption((ConfigOption)opt);
        opt = new StringConfigOption("AgentBundleVersion", "Agent Bundle Version");
        schema.addOption((ConfigOption)opt);
        return schema;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        return new ConfigSchema();
    }

    public GenericPlugin getPlugin(String type, TypeInfo entity) {
        if (type.equals("measurement")) {
            return new AgentMeasurementPlugin();
        }
        if (type.equals("autoinventory")) {
            if (entity.getType() == 2) {
                return new AgentServerDetector();
            }
        } else if (type.equals("log_track")) {
            if (entity.getType() == 2) {
                return new AgentLogTrackPlugin();
            }
        } else if (type.equals("config_track") && entity.getType() == 2) {
            return new AgentConfigTrackPlugin();
        }
        return null;
    }

    public TypeInfo[] getTypes() {
        TypeBuilder types = new TypeBuilder("HQ Agent", SERVER_DESC);
        types.addServer("x");
        return types.getTypes();
    }
}

