/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CBfileAccessor
extends BfileAccessor {
    static final int maxLength = 530;
    T4CMAREngine mare;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    T4CBfileAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, 530, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CBfileAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, 530, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
    }

    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 32 && this.statement.sqlKind != 64) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 32 || this.statement.sqlKind == 64 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            int n2 = (int)this.mare.unmarshalUB4();
            if (n2 == 0) {
                this.meta[0] = -1;
                this.processIndicator(0);
                ++this.lastRowProcessed;
                return false;
            }
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n4] = -1;
            this.rowSpaceIndicator[n5] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n6 = (int)this.mare.unmarshalUB4();
        if (n6 == 0) {
            this.meta[0] = -1;
            this.processIndicator(0);
            this.rowSpaceIndicator[n4] = -1;
            this.rowSpaceIndicator[n5] = 0;
            ++this.lastRowProcessed;
            return false;
        }
        if (this.lobPrefetchSizeForThisColumn != -1) {
            this.handlePrefetch();
        }
        this.mare.unmarshalCLR(this.rowSpaceByte, n3, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n4] = -1;
            this.rowSpaceIndicator[n5] = 0;
        } else {
            this.rowSpaceIndicator[n5] = (short)this.meta[0];
            this.rowSpaceIndicator[n4] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.columnIndex + n2 * this.byteLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, n4, this.rowSpaceByte, n3, s2);
        }
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.byteLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.byteLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(byArray, n5, this.rowSpaceByte, n4, s2);
        }
    }

    byte[][] checkAndAllocateLobPrefetchMemory(byte[][] byArray, int n2, int n3, int n4) {
        Object object = byArray;
        if (object == null) {
            object = new byte[Math.max(n2, n3 + 1)][];
            object[n3] = new byte[n4];
        } else {
            if (((byte[][])object).length < n3 + 1) {
                byte[][] byArrayArray = new byte[(n3 + 1) * 2][];
                System.arraycopy(object, 0, byArrayArray, 0, ((byte[][])object).length);
                object = byArrayArray;
            }
            if (object[n3] == null || object[n3].length < n4) {
                object[n3] = new byte[n4];
            }
        }
        return object;
    }

    char[][] checkAndAllocateLobPrefetchMemory(char[][] cArray, int n2, int n3, int n4) {
        Object object = cArray;
        if (object == null) {
            object = new char[Math.max(n2, n3 + 1)][];
            object[n3] = new char[n4];
        } else {
            if (((char[][])object).length < n3 + 1) {
                char[][] cArrayArray = new char[(n3 + 1) * 2][];
                System.arraycopy(object, 0, cArrayArray, 0, ((char[][])object).length);
                object = cArrayArray;
            }
            if (object[n3] == null || object[n3].length < n4) {
                object[n3] = new char[n4];
            }
        }
        return object;
    }

    long[] checkAndAllocateLobPrefetchMemory(long[] lArray, int n2, int n3) {
        long[] lArray2 = lArray;
        if (lArray2 == null) {
            lArray2 = new long[Math.max(n2, n3 + 1)];
        } else if (lArray2.length < n3 + 1) {
            long[] lArray3 = new long[(n3 + 1) * 2];
            System.arraycopy(lArray2, 0, lArray3, 0, lArray2.length);
            lArray2 = lArray3;
        }
        return lArray2;
    }

    int[] checkAndAllocateLobPrefetchMemory(int[] nArray, int n2, int n3) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[Math.max(n2, n3 + 1)];
        } else if (nArray2.length < n3 + 1) {
            int[] nArray3 = new int[(n3 + 1) * 2];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray2 = nArray3;
        }
        return nArray2;
    }

    short[] checkAndAllocateLobPrefetchMemory(short[] sArray, int n2, int n3) {
        short[] sArray2 = sArray;
        if (sArray2 == null) {
            sArray2 = new short[Math.max(n2, n3 + 1)];
        } else if (sArray2.length < n3 + 1) {
            short[] sArray3 = new short[(n3 + 1) * 2];
            System.arraycopy(sArray2, 0, sArray3, 0, sArray2.length);
            sArray2 = sArray3;
        }
        return sArray2;
    }

    byte[] checkAndAllocateLobPrefetchMemory(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[Math.max(n2, n3 + 1)];
        } else if (byArray2.length < n3 + 1) {
            byte[] byArray3 = new byte[(n3 + 1) * 2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    boolean[] checkAndAllocateLobPrefetchMemory(boolean[] blArray, int n2, int n3) {
        boolean[] blArray2 = blArray;
        if (blArray2 == null) {
            blArray2 = new boolean[Math.max(n2, n3 + 1)];
        } else if (blArray2.length < n3 + 1) {
            boolean[] blArray3 = new boolean[(n3 + 1) * 2];
            System.arraycopy(blArray2, 0, blArray3, 0, blArray2.length);
            blArray2 = blArray3;
        }
        return blArray2;
    }

    void handlePrefetch() throws SQLException, IOException {
        this.prefetchedLobSize = this.checkAndAllocateLobPrefetchMemory(this.prefetchedLobSize, this.statement.rowPrefetchInLastFetch, this.lastRowProcessed);
        this.prefetchedLobSize[this.lastRowProcessed] = (int)this.mare.unmarshalSB8();
        if (this.lobPrefetchSizeForThisColumn > 0) {
            this.mare.unmarshalUB1();
        }
    }

    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -13: {
                    return this.getBFILE(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return var2_2;
    }
}

