/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess dbaccess;
    int dbChunkSize = -1;
    boolean isFree = false;
    boolean fromObject = false;
    private long cachedLobLength = -1L;
    private byte[] prefetchData;
    private int prefetchDataSize = 0;
    private boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, boolean bl) throws SQLException {
        this(oracleConnection, byArray);
        this.fromObject = bl;
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        BLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = this.getPhysicalConnection().createBlobDBAccess();
    }

    public long length() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l2 = -1L;
        l2 = this.activePrefetch && this.cachedLobLength != -1L ? this.cachedLobLength : (this.canReadBasicLobDataInLocator() ? (long)this.dilLength() : this.getDBAccess().length(this));
        return l2;
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 0 || l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBytes(l2, n2);
        }
        byte[] byArray = null;
        if (n2 == 0) {
            return new byte[0];
        }
        if (this.activePrefetch && (this.cachedLobLength == 0L || this.cachedLobLength > 0L && l2 - 1L >= this.cachedLobLength)) {
            byArray = null;
        } else {
            long l3 = 0L;
            byte[] byArray2 = this.activePrefetch && this.cachedLobLength != -1L ? new byte[Math.min((int)this.cachedLobLength, n2)] : new byte[n2];
            l3 = this.getBytes(l2, n2, byArray2);
            if (l3 > 0L) {
                if (l3 == (long)n2) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l3];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l3);
                }
            }
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(1L);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, byArray, l2);
    }

    public long position(Blob blob, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, (BLOB)blob, l2);
    }

    public int getBytes(long l2, int n2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().getBytes(this, l2, n2, byArray);
    }

    public int putBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setBytes(l2, byArray);
    }

    public int putBytes(long l2, byte[] byArray, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setBytes(l2, byArray, 0, n2);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setBinaryStream(1L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n2;
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = n2 = this.getChunkSize();
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static BLOB empty_lob() throws SQLException {
        return BLOB.getEmptyBLOB();
    }

    public static BLOB getEmptyBLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = (this.shareBytes()[5] & 0x10) != 0;
        return bl;
    }

    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return bl;
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, false);
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(l2);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.truncate(l2);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n3);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().freeTemporary(this, this.fromObject);
    }

    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isOpen(this);
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putBytes(this, l2, byArray, 0, byArray != null ? byArray.length : 0);
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putBytes(this, l2, byArray, n2, n3);
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, true);
    }

    public void truncate(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'len' should be >= 0. ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().trim(this, l2);
    }

    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n2) {
        return new BLOB[n2];
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return super.getJavaSqlConnection();
    }

    public final void setLength(long l2) {
        this.cachedLobLength = l2;
    }

    public final void setChunkSize(int n2) {
        this.dbChunkSize = n2;
    }

    public final void setPrefetchedData(byte[] byArray) {
        if (byArray == null) {
            this.setPrefetchedData(null, 0);
        } else {
            this.setPrefetchedData(byArray, byArray.length);
        }
    }

    public final void setPrefetchedData(byte[] byArray, int n2) {
        this.prefetchData = byArray;
        this.prefetchDataSize = n2;
    }

    public final byte[] getPrefetchedData() {
        return this.prefetchData;
    }

    public final int getPrefetchedDataSize() {
        return this.prefetchDataSize;
    }

    public final void setActivePrefetch(boolean bl) {
        if (this.activePrefetch && !bl) {
            this.clearCachedData();
        }
        this.activePrefetch = bl;
    }

    public final void clearCachedData() {
        this.cachedLobLength = -1L;
        this.prefetchData = null;
    }

    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    boolean canReadBasicLobDataInLocator() throws SQLException {
        int n2;
        byte[] byArray = this.shareBytes();
        if (byArray == null || byArray.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int n3 = byArray[6] & 0xFF;
        int n4 = byArray[7] & 0xFF;
        boolean bl = (n3 & 8) == 8;
        boolean bl2 = (n4 & 0xFFFFFF80) == -128;
        boolean bl3 = false;
        if (bl && !bl2) {
            n2 = byArray[88] & 0xFF;
            bl3 = (n2 & 8) == 8;
        }
        n2 = bl && !bl2 && bl3 ? 1 : 0;
        return n2 != 0;
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    byte[] dilGetBytes(long l2, int n2) throws SQLException {
        if (n2 == 0) {
            return new byte[0];
        }
        if (this.dilLength() == 0) {
            return null;
        }
        int n3 = (int)Math.min((long)n2, (long)this.dilLength() - (l2 - 1L));
        if (n3 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.shareBytes(), (int)(l2 - 1L) + 86 + 16, byArray, 0, n3);
        return byArray;
    }

    InputStream dilGetBinaryStream(long l2) throws SQLException {
        if (l2 - 1L > (long)this.dilLength()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = this.dilGetBytes(l2, this.dilLength());
        return new ByteArrayInputStream(byArray);
    }
}

