/*
 * This file implements the RTP-MIB module.
 */
/* General includes */
#include <stdio.h>
#include <sys/types.h>

/* SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <var_struct.h>

#include "covalent-snmp-config.h"
#include "rtp-mib/rtp-mib.h"

#ifndef SNMP_MIN
#define SNMP_MIN(a,b)   (((a)<(b)) ? (a) : (b))
#endif

#define NEXT    FALSE
#define EXACT   TRUE
#define INDEX   2

#ifdef RTP_RECEIVER_GROUP

#define RTPRCVRINVERSESTARTTIME          1

#define RTPRCVRCNAME                     3
#define RTPRCVRADDR                      4
#define RTPRCVRRTT                       5
#define RTPRCVRLOSTPACKETS               6
#define RTPRCVRJITTER                    7
#define RTPRCVRTOOL                      8
#define RTPRCVRRRS                       9
#define RTPRCVRRRTIME                    10
#define RTPRCVRPT                        11
#define RTPRCVRPACKETS                   12
#define RTPRCVROCTETS                    13
#define RTPRCVRSTARTTIME                 14


static unsigned char *
read_rtpRcvrInverseEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
    /* All returns are NULL. Meaning no values are implemented. */
    /* A better way is not to add this MIB portion.             */

    switch (vp->magic) {
    case RTPRCVRINVERSESTARTTIME:
        return (unsigned char *) NULL;
    default:
         ERROR_MSG("");
    }
    return NULL;
}

static unsigned char *
read_rtpRcvrEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
    /* All returns are NULL. Meaning no values are implemented. */
    /* A better way is not to add this MIB portion.             */
    switch (vp->magic) {
    case RTPRCVRCNAME:
        return (unsigned char *) NULL;
    case RTPRCVRADDR:
        return (unsigned char *) NULL;
    case RTPRCVRRTT:
        return (unsigned char *) NULL;
    case RTPRCVRLOSTPACKETS:
        return (unsigned char *) NULL;
    case RTPRCVRJITTER:
        return (unsigned char *) NULL;
    case RTPRCVRTOOL:
        return (unsigned char *) NULL;
    case RTPRCVRRRS:
        return (unsigned char *) NULL;
    case RTPRCVRRRTIME:
        return (unsigned char *) NULL;
    case RTPRCVRPT:
        return (unsigned char *) NULL;
    case RTPRCVRPACKETS:
        return (unsigned char *) NULL;
    case RTPRCVROCTETS:
        return (unsigned char *) NULL;
    case RTPRCVRSTARTTIME:
        return (unsigned char *) NULL;
    default:
         ERROR_MSG("");
    }
    return NULL;
}

static oid rtpRcvrInverseEntry_oid[] = {1, 3, 6, 1, 2, 1, 87, 1, 6, 1};
static struct variable2 rtpRcvrInverseEntry_variables[] = {
    { RTPRCVRINVERSESTARTTIME, ASN_INTEGER, RONLY, read_rtpRcvrInverseEntry, 1, {1} },
};

static oid rtpRcvrEntry_oid[] = {1, 3, 6, 1, 2, 1, 87, 1, 7, 1};
static struct variable2 rtpRcvrEntry_variables[] = {
    { RTPRCVRCNAME, ASN_OCTET_STR, RONLY, read_rtpRcvrEntry, 1, {3} },
    { RTPRCVRADDR, ASN_OCTET_STR, RONLY, read_rtpRcvrEntry, 1, {4} },
    { RTPRCVRRTT, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {5} },
    { RTPRCVRLOSTPACKETS, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {6} },
    { RTPRCVRJITTER, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {7} },
    { RTPRCVRTOOL, ASN_OCTET_STR, RONLY, read_rtpRcvrEntry, 1, {8} },
    { RTPRCVRRRS, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {9} },
    { RTPRCVRRRTIME, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {10} },
    { RTPRCVRPT, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {11} },
    { RTPRCVRPACKETS, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {12} },
    { RTPRCVROCTETS, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {13} },
    { RTPRCVRSTARTTIME, ASN_INTEGER, RONLY, read_rtpRcvrEntry, 1, {14} },
};

init_rtp_receiver_group()
{
    REGISTER_MIB("rtpRcvrInverseEntry", rtpRcvrInverseEntry_variables,
         variable2, rtpRcvrInverseEntry_oid);
    REGISTER_MIB("rtpRcvrEntry", rtpRcvrEntry_variables,
         variable2, rtpRcvrEntry_oid);
}
#endif /* RTP_RECEIVER_GROUP */
