/*
 * AgentX SubAgent Configuration which 
 */
/* General includes */
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

/* Apache includes */
#include <httpd.h>

/* NET-SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp_debug.h"
#include "default_store.h"
#include "ds_agent.h"
#include "snmp_logging.h"
#include "mib_module_config.h"
#include "read_config.h"
#include "agent_read_config.h"

/* module includes */
#include "covalent-snmp-config.h"
#include "dummy-config.h"

static void read_dummy_tokens(const char *token, char *cptr);
static void read_dummy_tokens(const char *token, char *cptr)
{
    /* The function is just a NO-OP. */
    return;
}


SNMPCOMMON_DECLARE(void) init_agentx_dummy_config(void)
{
    snmpd_register_config_handler("syslocation", read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("syscontact",  read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("sysservices", read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("com2sec",     read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("group",       read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("access",      read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("view",        read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("rocommunity", read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("rwcommunity", read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("rouser",      read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("rwuser",      read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("vacmView",    read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("vacmGroup",   read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("vacmAccess",  read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("usmUser",     read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("createUser",  read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("master",      read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("agentxsocket",read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("trapsink",    read_dummy_tokens, NULL, "");
    snmpd_register_config_handler("trap2sink",   read_dummy_tokens, NULL, "");
}


