#ifndef	__WWW_MIB_H__
#define	__WWW_MIB_H__

void init_www_mib(server_rec *s, pool *p, char *bucket_directory);
server_rec *get_admin_wwwService_row(struct variable *vp,
		oid *name, size_t *namelength, oid *newname, 
		size_t *newname_length, int exact, server_rec *server);
wwwStatistics_t *get_www_statistics_record(int index);
int get_www_service_count(void);
int set_www_service_count(server_rec *s);

/* columnar objects of the wwwServiceEntry */
#define	WWWSERVICEDESCRIPTION	2
#define	WWWSERVICECONTACT	3
#define	WWWSERVICEPROTOCOL	4
#define	WWWSERVICENAME	5
#define	WWWSERVICETYPE	6
#define	WWWSERVICESTARTTIME	7
#define	WWWSERVICEOPERSTATUS	8
#define	WWWSERVICELASTCHANGE	9

/* enumerated wwwServiceOperStatus */
#define OPERSTATUS_DOWN		1
#define OPERSTATUS_RUNNING	2
#define OPERSTATUS_HALTED	3
#define OPERSTATUS_CONGESTED	4
#define OPERSTATUS_RESTARTING	5

/* columnar objects wwwSummaryEntry */
#define	WWWSUMMARYINREQUESTS	1
#define	WWWSUMMARYOUTREQUESTS	2
#define	WWWSUMMARYINRESPONSES	3
#define	WWWSUMMARYOUTRESPONSES	4
#define	WWWSUMMARYINBYTES	5
#define	WWWSUMMARYINLOWBYTES	6
#define	WWWSUMMARYOUTBYTES	7
#define	WWWSUMMARYOUTLOWBYTES	8

/* columnar objects of the wwwRequestInEntry */
#define	WWWREQUESTINREQUESTS	2
#define	WWWREQUESTINBYTES	3
#define	WWWREQUESTINLASTIME	4

/* columnar objects of the wwwRequestOutEntry */
#define	WWWREQUESTOUTREQUESTS	2
#define	WWWREQUESTOUTBYTES	3
#define	WWWREQUESTOUTLASTTIME	4

/* columnar objects of the wwwResponseInEntry */
#define	WWWRESPONSEINRESPONSES	2
#define	WWWRESPONSEINBYTES	3
#define	WWWRESPONSEINLASTTIME	4


/* columnar objects of the wwwResponseOutEntry, 2 */
#define	WWWRESPONSEOUTRESPONSES	2
#define	WWWRESPONSEOUTBYTES		3
#define	WWWRESPONSEOUTLASTTIME	4


/* columnar objects of the wwwDocCtrlEntry */
#define	WWWDOCCTRLNSIZE	1
#define	WWWDOCCTRLNLOCK	2
#define	WWWDOCCTRLBUCKETS	3
#define	WWWDOCCTRLBUCKETSTIMEINTERVAL	4
#define	WWWDOCCTRLTOPNSIZE	5

/* columnar objects of the wwwDocLastNEntry */
#define	WWWDOCLASTNNAME	2
#define	WWWDOCLASTNTIMESTAMP	3
#define	WWWDOCLASTNREQUESTTYPE	4
#define	WWWDOCLASTNRESPONSETYPE	5
#define	WWWDOCLASTNSTATUSMSG	6
#define	WWWDOCLASTNBYTES	7

/* columnar objects of the wwwDocBucketEntry */
#define	WWWDOCBUCKETTIMESTAMP	2
#define	WWWDOCBUCKETACCESSES	3
#define	WWWDOCBUCKETDOCUMENTS	4
#define	WWWDOCBUCKETBYTES	5

/* columnar objects of the wwwDocAccessTopNEntry */
#define	WWWDOCACCESSTOPNNAME	2
#define	WWWDOCACCESSTOPNACCESSES	3
#define	WWWDOCACCESSTOPNBYTES	4
#define	WWWDOCACCESSTOPNLASTRESPONSETYPE	5

/* columnar objects of the wwwDocBytesTopNEntry */
#define	WWWDOCBYTESTOPNNAME	2
#define	WWWDOCBYTESTOPNACCESSES	3
#define	WWWDOCBYTESTOPNBYTES	4
#define	WWWDOCBYTESTOPNLASTNRESPONSETYPE	5

#endif /* __WWW_MIB_H__ */
