/* Apache includes */
#include "httpd.h"
#include "http_conf_globals.h"
#include "http_config.h"

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp_api.h"
#include "snmp_vars.h"

#include "covalent-snmp-config.h"
#include "ietf-mibs/snmp-generic.h"
#include "covalent-snmp-logging.h"
#include "covalent-snmp.h"
#include "covalent-snmp-sconfig.h"
#include "application-mib-modules.h"

#include "ietf-mibs/www-mib.h"
#include "ietf-mibs/nsm-mib.h"
#include "covalent-mibs/resp-notify-mib.h"
#include "covalent-mibs/apache-config-mib.h"
#include "covalent-mibs/apache-status-mib.h"
#include "covalent-mibs/apache-modules-mib.h"

/*
 * init_application_mib_modules
 * Parameters: server_rec *s,
 *             pool *p,
 *             char *persdir
 * Returns:    void
 * Description:
 * This function embraces all application framework MIB modules
 * for Covalent SNMP.
 */
void
init_application_mib_modules(server_rec *s, pool *p, char *persdir)
{
#ifdef WWW_MIB
    init_www_mib(s, p, persdir);
#endif /* WWW_MIB */
#ifdef NSM_MIB
    init_nsm_mib();
#endif /* NSM_MIB */
#ifdef COVALENT_RESP_NOTIFY_MIB
    init_www_resp_notify_mib();
#endif /* COVALENT_RESP_NOTIFY_MIB */
#ifdef COVALENT_APACHE_CONFIG_MIB
    init_covalent_apache_config_mib_subtrees(s, p);
#endif /* COVALENT_APACHE_CONFIG_MIB */
#ifdef COVALENT_APACHE_STATUS_MIB
    init_covalent_apache_status_mib();
#endif /* COVALENT_APACHE_STATUS_MIB */
#ifdef COVALENT_APACHE_MODULES_MIB
    init_covalent_apache_modules_mib();
#endif /* COVALENT_APACHE_MODULES_MIB */
    init_external_mib_modules(s, p);
}
