#ifndef __COVALENT_SNMP_LOGGING_H__
#define __COVALENT_SNMP_LOGGING_H__

#ifndef MAX_WWWDOCNAME
/* May not be longer due to Utf8String limitation. */
#define MAX_WWWDOCNAME			256
#endif

#ifndef MAX_WWWDOCLASTNSTATUSMSG
/* May not be longer due to Utf8String limitation. */
#define MAX_WWWDOCLASTNSTATUSMSG	256
#endif

typedef struct {
    int			wwwServiceIndex;
    time_t		wwwRequestTime;
    unsigned long	wwwRequestInType;
    unsigned long	wwwResponseOutType;
    unsigned long	wwwBytesIn;
    unsigned long	wwwBytesOut;
    char		wwwDocName[ MAX_WWWDOCNAME ];
    char		wwwStatusMsg[ MAX_WWWDOCLASTNSTATUSMSG ];
} www_log_record;


typedef struct {
    int wwwServiceIndex;
    time_t time;
    char wwwDocName[ MAX_WWWDOCNAME ];
    char virusName[ MAX_WWWDOCNAME ];
} antivirus_detection_log_t;

typedef struct {
    int activity;
    int result;
    time_t time;
    unsigned long interval;
    char statusMsg[ MAX_SNMPADMINSTRING ];
} antivirus_update_activity_t;

typedef struct {
    int wwwServiceIndex;
    int last_or_new;
    time_t time;
    char doc[ MAX_WWWDOCNAME ];
} intrusion_detection_log_t;

typedef enum {
    /*  1 -  9 Reserved for internal (future) use within Conductor. */
    WWW = 0,     /* Used for logging of a WWW-request/response.     */
    STARTUP = 1, /* Used by childeren to signal they have started.  */
    /* 10 - 19 Reserved for (future) use within AntiVirus           */
    CONDUCTOR_ANTIVIRUS_SERVICE_STATS = 11,
    CONDUCTOR_ANTIVIRUS_UPDATE_STATS = 12,
    /* 20 - 29 Reserved for (future) use within Intruder            */
    CONDUCTOR_INTRUSION_INIT = 20,
    CONDUCTOR_INTRUSION_DOCUPDATE = 21,
    /* 30 - 39 Reserved for (future) use within Credator            */
    CONDUCTOR_CREDITOR = 30,
    /* 40 - 49 Reserved for (future) use within RavenSSL            */
    CONDUCTOR_RAVENSSL = 40
} snmp_log_type;

typedef struct {
    snmp_log_type type;
    union {
        www_log_record www;
        antivirus_detection_log_t detected;
        antivirus_update_activity_t update;
        intrusion_detection_log_t intrusion;
    } data;
} snmp_generic_log_record;


#endif /* __COVALENT_SNMP_LOGGING_H__ */
