/* Apache includes */
#include <httpd.h>
#include <http_config.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_vars.h>
#include <agent_trap.h>

/* Conductor module includes */
#include "ietf-mibs/snmp-generic.h"
#include "covalent-snmp-config.h"
#include "covalent-snmp-logging.h"
#include "covalent-snmp-sconfig.h"

/* This variable is defined in covalent-snmp.c */
extern module snmp_agt_module;
int snmp_generic_logger(snmp_generic_log_record *data);

void
covalent_snmp_setup_sconf_for_vhosts(pool *p, server_rec *s)
{
    ap_set_module_config(s->module_config, &snmp_agt_module, covalent_snmp_create_sconf(p, s));
}

void *
covalent_snmp_create_sconf(pool *p, server_rec *s)
{
    covalent_snmp_sconfig *ptr = (covalent_snmp_sconfig *)
		ap_pcalloc(p, sizeof(covalent_snmp_sconfig));

    ptr->api_version = CONDUCTOR_API_VERSION;
    ptr->wwwServiceIndex = 0;
    ptr->snmp_logger = snmp_generic_logger;
    ptr->external_mib_subtrees = ap_make_array(p, 1, sizeof(external_mib_subtree));
    ptr->invoke_notification = send_enterprise_trap_vars;
    return(ptr);
}

int
set_sconfig_wwwServiceIndex(server_rec *s, int index)
{
    covalent_snmp_sconfig *ptr = (covalent_snmp_sconfig *)
		ap_get_module_config(s->module_config, &snmp_agt_module);

    if (ptr == NULL) {
	return(0);
    }
    ptr->wwwServiceIndex = index;
    return(ptr->wwwServiceIndex);
}

int
get_sconfig_wwwServiceIndex(server_rec *s)
{
    covalent_snmp_sconfig *ptr = (covalent_snmp_sconfig *)
		ap_get_module_config(s->module_config, &snmp_agt_module);

    if (ptr == NULL) {
	return(-1);
    }
    return(ptr->wwwServiceIndex);
}

int
init_external_mib_modules(server_rec *s, pool *p)
{
covalent_snmp_sconfig *sconf_ptr;
array_header *external_subtrees;
external_mib_subtree *subtree;
int i;

    sconf_ptr = (covalent_snmp_sconfig *)
                ap_get_module_config(s->module_config, &snmp_agt_module);
    external_subtrees = sconf_ptr->external_mib_subtrees;
    subtree = (external_mib_subtree *) external_subtrees->elts;
    for (i = 0 ; i < external_subtrees->nelts ; i++, subtree++) {
	if (register_mib("external subtree",
                        (struct variable *) subtree->variables,
                        subtree->variable_size, subtree->variables_amount,
                        subtree->base_oid, subtree->base_oid_length)
                                        != MIB_REGISTERED_OK ) {
	    /* What will we do now?? */
        } else {
            if (subtree->init) {
                subtree->init(s, p);
            }
        }
    }
    return(0);
}
