/*
 * This module implements for the COVALENT-APACHE-MODULES-MIB module.
 */
#include <stdio.h>
#include <sys/types.h>

/* Apache includes */
#define CORE_PRIVATE
#include <httpd.h>
#include <http_config.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <var_struct.h>

#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "apache-modules-mib.h"

#ifndef SNMP_MIN
#define SNMP_MIN(a,b)   (((a)<(b)) ? (a) : (b))
#endif

#define NEXT    FALSE
#define EXACT   TRUE
#define INDEX   2

#define CTAPACHEMODULECMDSNAME       2
#define CTAPACHEMODULECMDSARGUMENTS  3
#define CTAPACHEMODULECMDSUSAGE      4

#ifdef COVALENT_APACHE_MODULES_COMMANDS_GROUP

static const command_rec * get_ctApacheModuleCmdsIndex(struct variable *vp,
	oid *name, size_t *namelength, int exact);

static const command_rec *
get_ctApacheModuleCmdsIndex(struct variable *vp,
	oid *name, size_t *namelength,
	int exact)
{
oid *ptr;
module *module_ptr;
const command_rec *cmd_ptr;
int result;

    DEBUGTRACE;
    module_ptr = get_ctModuleIndex(vp, name, namelength, INDEX, ap_top_module);
    while (module_ptr) {
        DEBUGMSGTL(("modules", "have module %s\n", module_ptr->name));
        ptr = &(vp->name[ vp->namelen++ ]);
        *ptr = 1;
        cmd_ptr = module_ptr->cmds;
        while ((cmd_ptr) && (cmd_ptr->name)) {
            result = snmp_oid_compare(name, *namelength, vp->name, vp->namelen);
            if ((exact && (result == 0)) || (!exact && (result < 0))) {
                 return(cmd_ptr);
            }
            (*ptr)++;
            ++cmd_ptr;
        }
        vp->namelen -= 2;
        module_ptr = get_ctModuleIndex(vp, name, namelength, INDEX, module_ptr->next);
    }
    return(NULL);
}

static unsigned long
map_arguments(enum cmd_how type)
{
    switch (type) {
    case RAW_ARGS: return(1);
    case TAKE1:    return(5);
    case TAKE2:    return(6);
    case ITERATE:  return(3);
    case ITERATE2: return(4);
    case FLAG:     return(2);
    case NO_ARGS:  return(0);
    case TAKE12:   return(8);
    case TAKE3:    return(7);
    case TAKE23:   return(9);
    case TAKE123:  return(10);
    case TAKE13:   return(11);
    }
    return(-1);
}

static unsigned char *
var_ctApacheModuleCmdsEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len,
    WriteMethod **write_method)
{
const command_rec *cmds;

    vp->name[ vp->namelen++ ] = get_appl_index();
    cmds = get_ctApacheModuleCmdsIndex(vp, name, length, exact);
    if (!cmds) {
	return(NULL);
    }

    *length = vp->namelen;
    memcpy( (char *)name,(char *)vp->name, *length * sizeof(oid));
    *write_method = 0;

    switch (vp->magic) {
    case CTAPACHEMODULECMDSNAME:
        *var_len = strlen(cmds->name);
        return (unsigned char *) cmds->name;
    case CTAPACHEMODULECMDSARGUMENTS:
        *var_len = sizeof(long);
	long_return = map_arguments(cmds->args_how);
        return (unsigned char *) &long_return;
    case CTAPACHEMODULECMDSUSAGE:
        *var_len = strlen(cmds->errmsg);
        return (unsigned char *) cmds->errmsg;
    default:
         ERROR_MSG("");
    }

    return NULL;
}


static oid ctApacheModuleCmdsEntry_oid[] = {1, 3, 6, 1, 4, 1, 6100, 6, 1, 2, 1};
static struct variable2 ctApacheModuleCmdsEntry_variables[] = {
    { CTAPACHEMODULECMDSNAME, ASN_OCTET_STR, RONLY, var_ctApacheModuleCmdsEntry, 1, {2} },
    { CTAPACHEMODULECMDSARGUMENTS, ASN_INTEGER, RONLY, var_ctApacheModuleCmdsEntry, 1, {3} },
    { CTAPACHEMODULECMDSUSAGE, ASN_OCTET_STR, RONLY, var_ctApacheModuleCmdsEntry, 1, {4} }
};


void init_covalent_apache_modules_cmds_group()
{
    REGISTER_MIB("modules-mib/ctApacheModuleCmdsTable",
                 ctApacheModuleCmdsEntry_variables, variable2,
                 ctApacheModuleCmdsEntry_oid);
};

#endif /* COVALENT_APACHE_MODULES_CMDS_GROUP */

