#ifndef __LOGGING_H__
#define __LOGGING_H__

typedef struct {
    unsigned int        wwwServiceIndex;
    unsigned int        wwwProtocol;
    apr_time_t          wwwRequestTime;
    unsigned long       wwwRequestInType;
    unsigned long       wwwResponseOutType;
    unsigned long       wwwBytesIn;
    unsigned long       wwwBytesOut;
    char                wwwDocName[ MAX_WWWDOCNAME ];
    char                wwwStatusMsg[ MAX_WWWDOCLASTNSTATUSMSG ];
} www_log_t;

typedef struct {
    int www_service;
    int log_level;
    char log_message[ MAX_SNMPADMINSTRING ];
} error_log_t;

typedef enum {
    WWWLOGGING = 0,         /* Used for WWW-request/response (access logging). */
    APACHEERRORLOGGING = 1, /* Used for apache error logging. */
    NEXT_LOG_TYPE = 10
} snmpagent_log_type;

typedef struct {
    snmpagent_log_type type;
    union {
        www_log_t www;
        error_log_t error;
    } data;
} snmpagent_log_record_t;

APR_DECLARE_OPTIONAL_FN(int, covalent_snmp_generic_logger,
                             (snmpagent_log_record_t *data));

int snmpagent_logpath_is_open(void);
int covalent_snmp_generic_logger(snmpagent_log_record_t *data);

#endif /* __LOGGING_H__ */
