/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.core;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.plugin.rabbitmq.core.MessageStats;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitChannel;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitConnection;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitExchange;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitNode;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitOverview;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitQueue;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitVirtualHost;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HypericRabbitAdmin {
    private static final Log logger = LogFactory.getLog(HypericRabbitAdmin.class);
    private final DefaultHttpClient client;
    private String user;
    private String pass;
    private BasicHttpContext localcontext;
    private HttpHost targetHost;

    public HypericRabbitAdmin(Properties props) throws PluginException {
        int port = Integer.parseInt(props.getProperty("port"));
        String addr = props.getProperty("addr");
        boolean https = "true".equals(props.getProperty("https"));
        this.user = props.getProperty("username");
        this.pass = props.getProperty("password");
        this.targetHost = new HttpHost(addr, port, https ? "https" : "http");
        AgentKeystoreConfig config = new AgentKeystoreConfig();
        this.client = new HQHttpClient((KeystoreConfig)config, new HttpConfig(5000, 5000, null, 0), config.isAcceptUnverifiedCert());
        this.client.getCredentialsProvider().setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort(), "Management: Web UI"), (Credentials)new UsernamePasswordCredentials(this.user, this.pass));
        ArrayList<String> authPrefs = new ArrayList<String>(1);
        authPrefs.add("Management: Web UI");
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, (AuthScheme)basicAuth);
        this.localcontext = new BasicHttpContext();
        this.localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    public HypericRabbitAdmin(ConfigResponse props) throws PluginException {
        this(props.toProperties());
    }

    public RabbitOverview getOverview() throws PluginException {
        return this.get("/api/overview", RabbitOverview.class);
    }

    public List<RabbitVirtualHost> getVirtualHosts() throws PluginException {
        List<Object> res;
        try {
            res = Arrays.asList((Object[])this.get("/api/vhosts", RabbitVirtualHost[].class));
        }
        catch (PluginException ex) {
            logger.debug((Object)("[getVirtualHosts] " + ex.getLocalizedMessage()), (Throwable)ex);
            res = new ArrayList<Object>();
            List<Object> names = Arrays.asList((Object[])this.get("/api/vhosts", String[].class));
            for (String string : names) {
                res.add(new RabbitVirtualHost(string));
            }
        }
        return res;
    }

    public List<RabbitQueue> getQueues(RabbitVirtualHost vh) throws PluginException {
        try {
            return Arrays.asList((Object[])this.get("/api/queues/" + URLEncoder.encode(vh.getName(), "UTF-8"), RabbitQueue[].class));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<RabbitExchange> getExchanges(RabbitVirtualHost vh) throws PluginException {
        try {
            return Arrays.asList((Object[])this.get("/api/exchanges/" + URLEncoder.encode(vh.getName(), "UTF-8"), RabbitExchange[].class));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<RabbitConnection> getConnections() throws PluginException {
        return Arrays.asList((Object[])this.get("/api/connections", RabbitConnection[].class));
    }

    public RabbitConnection getConnection(String cName) throws PluginException {
        try {
            cName = URLEncoder.encode(cName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return this.get("/api/connections/" + cName, RabbitConnection.class);
    }

    public List<RabbitChannel> getChannels() throws PluginException {
        return Arrays.asList((Object[])this.get("/api/channels", RabbitChannel[].class));
    }

    public RabbitChannel getChannel(String chName) throws PluginException {
        try {
            chName = URLEncoder.encode(chName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return this.get("/api/channels/" + chName, RabbitChannel.class);
    }

    public RabbitVirtualHost getVirtualHost(String vhName) throws PluginException {
        RabbitVirtualHost res;
        try {
            vhName = URLEncoder.encode(vhName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        try {
            res = this.get("/api/vhosts/" + vhName, RabbitVirtualHost.class);
        }
        catch (PluginException ex) {
            logger.debug((Object)("[getVirtualHost] " + ex.getLocalizedMessage()), (Throwable)ex);
            String name = this.get("/api/vhosts/" + vhName, String.class);
            res = new RabbitVirtualHost(name);
        }
        return res;
    }

    public RabbitQueue getVirtualQueue(String vhName, String qName) throws PluginException {
        try {
            vhName = URLEncoder.encode(vhName, "UTF-8");
            qName = URLEncoder.encode(qName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return this.get("/api/queues/" + vhName + "/" + qName, RabbitQueue.class);
    }

    public RabbitExchange getExchange(String vhost, String exch) throws PluginException {
        try {
            vhost = URLEncoder.encode(vhost, "UTF-8");
            exch = URLEncoder.encode(exch, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return this.get("/api/exchanges/" + vhost + "/" + exch, RabbitExchange.class);
    }

    public RabbitNode getNode(String node) throws PluginException {
        RabbitNode res;
        try {
            node = URLEncoder.encode(node, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        try {
            res = this.get("/api/nodes/" + node, RabbitNode.class);
        }
        catch (PluginException ex) {
            logger.debug((Object)("[getVirtualHost] " + ex.getLocalizedMessage()), (Throwable)ex);
            res = this.get("/api/overview/", RabbitNode.class);
            res.setName(node);
            res.setRunning(true);
        }
        return res;
    }

    private <T> T get(String api, Class<T> classOfT) throws PluginException {
        Object res = null;
        try {
            HttpGet get = new HttpGet(this.targetHost.toURI() + api);
            HttpResponse response = this.client.execute((HttpUriRequest)get, (HttpContext)this.localcontext);
            int r = response.getStatusLine().getStatusCode();
            String responseBody = HypericRabbitAdmin.readInputString(response.getEntity().getContent());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + api + "] -(" + r + ")-> " + responseBody));
            }
            if (r != 200) {
                throw new PluginException("[" + api + "] http error code: '" + r + "'");
            }
            GsonBuilder gsb = new GsonBuilder();
            gsb.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
            gsb.registerTypeAdapter(Integer.class, (Object)new IntegerDeserializer());
            gsb.registerTypeAdapter(Integer.TYPE, (Object)new IntegerDeserializer());
            gsb.registerTypeAdapter(Date.class, (Object)new DateTimeDeserializer());
            gsb.registerTypeAdapter(MessageStats.class, (Object)new MessageStatsDeserializer());
            Gson gson = gsb.create();
            res = gson.fromJson(responseBody, classOfT);
            if (logger.isDebugEnabled()) {
                if (res.getClass().isArray()) {
                    logger.debug((Object)("[" + api + "] -(" + r + ")*> " + Arrays.asList((Object[])res)));
                } else {
                    logger.debug((Object)("[" + api + "] -(" + r + ")-> " + res));
                }
            }
        }
        catch (IOException ex) {
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return (T)res;
    }

    public static String readInputString(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageStatsDeserializer
    implements JsonDeserializer<MessageStats> {
        private MessageStatsDeserializer() {
        }

        public MessageStats deserialize(JsonElement je, Type Type2, JsonDeserializationContext jdc) throws JsonParseException {
            MessageStats res = null;
            if (je.isJsonArray()) {
                res = new MessageStats();
            } else {
                GsonBuilder gsb = new GsonBuilder();
                gsb.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
                Gson gson = gsb.create();
                res = (MessageStats)gson.fromJson(je, Type2);
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerDeserializer
    implements JsonDeserializer<Integer> {
        private IntegerDeserializer() {
        }

        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException ex) {
                if (json.getAsString().equals("install_handle_from_sysinternals")) {
                    logger.debug((Object)("'Handle V3.42 (sysinternals)' is required by 'rabbitmq-management-agent' plugin on Windows Platforms. " + ex.getMessage()));
                    return null;
                }
                throw new JsonParseException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateTimeDeserializer
    implements JsonDeserializer<Date> {
        private DateTimeDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return formatter.parse(json.getAsString());
            }
            catch (ParseException ex) {
                throw new JsonParseException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

