/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.FileData;
import org.hyperic.hq.agent.FileDataResult;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.commands.AgentReceiveFileData_args;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.transport.util.RemoteInputStream;
import org.hyperic.util.JDK;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.file.FileWriter;
import org.hyperic.util.math.MathUtil;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentCommandsService
implements AgentCommandsClient {
    private static final String AGENT_BUNDLE_HOME = "agent.bundle.home";
    private static final Log _log = LogFactory.getLog(AgentCommandsService.class);
    private final AgentDaemon _agent;
    private final AgentTransportLifecycle _agentTransportLifecycle;

    public AgentCommandsService(AgentDaemon agent) throws AgentRunningException {
        this._agent = agent;
        this._agentTransportLifecycle = this._agent.getAgentTransportLifecycle();
    }

    public FileDataResult[] agentSendFileData(FileData[] destFiles, InputStream[] streams) throws AgentRemoteException {
        if (streams.length != 1) {
            throw new AgentRemoteException("streams array should only contain one input stream");
        }
        RemoteInputStream inStream = (RemoteInputStream)streams[0];
        try {
            inStream.setRemoteSourceInvokerLocator(this._agentTransportLifecycle.getRemoteTransportLocator());
        }
        catch (Exception e) {
            throw new AgentRemoteException("failed to set the remote source invoker locator", e);
        }
        this.readFilesFromStream(destFiles, (InputStream)inStream);
        return new FileDataResult[0];
    }

    void agentSendFileData(AgentReceiveFileData_args args, InputStream inStream) throws AgentRemoteException {
        int numFiles = args.getNumFiles();
        FileData[] destFiles = new FileData[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            destFiles[i] = args.getFile(i);
        }
        this.readFilesFromStream(destFiles, inStream);
    }

    private String resolveAgentBundleHomePath(String path) throws AgentRemoteException {
        String agentBundleHome = System.getProperty(AGENT_BUNDLE_HOME);
        if (agentBundleHome == null) {
            throw new AgentRemoteException("Could not resolve system property agent.bundle.home");
        }
        return StringUtil.replace((String)path, (String)"${agent.bundle.home}", (String)agentBundleHome);
    }

    private void readFilesFromStream(FileData[] destFiles, InputStream inStream) throws AgentRemoteException {
        String destFile;
        int i;
        ArrayList<FileWriter> fList = new ArrayList<FileWriter>();
        String errorMessage = null;
        for (i = 0; i < destFiles.length; ++i) {
            FileData data = destFiles[i];
            destFile = this.resolveAgentBundleHomePath(data.getDestFile());
            _log.info((Object)("Preparing to write " + data.getSize() + " bytes to " + destFile + " (type=" + data.getWriteType() + ")"));
            FileWriter writer = new FileWriter(new File(destFile), inStream, data.getSize());
            writer.setVerifyMD5CheckSumOnWrite(data.getMD5CheckSum());
            switch (data.getWriteType()) {
                case 1: {
                    writer.setCreateOnly();
                    break;
                }
                case 2: {
                    writer.setCreateOrOverwrite();
                    break;
                }
                case 3: {
                    writer.setRewrite();
                    break;
                }
                default: {
                    throw new AgentRemoteException("Unknown control write type: " + data.getWriteType());
                }
            }
            fList.add(writer);
        }
        boolean checkSumFailed = false;
        for (i = 0; i < fList.size(); ++i) {
            FileWriter writer = (FileWriter)fList.get(i);
            try {
                _log.info((Object)("Writing to '" + writer.getDestFile().getAbsolutePath() + "'"));
                writer.write();
                try {
                    writer.verifyMD5CheckSum();
                    continue;
                }
                catch (IOException e) {
                    checkSumFailed = true;
                    throw e;
                }
            }
            catch (IOException exc) {
                errorMessage = "Error writing to '" + writer.getDestFile().getAbsolutePath() + "': " + exc.getMessage();
                _log.error((Object)errorMessage, (Throwable)exc);
                break;
            }
        }
        for (int j = i; j < fList.size(); ++j) {
            if (checkSumFailed && j == i) continue;
            FileData data = destFiles[j];
            _log.debug((Object)("Resynching stream:  Reading " + data.getSize() + " bytes"));
            try {
                this.byteChomper(inStream, data.getSize());
                continue;
            }
            catch (IOException exc) {
                _log.error((Object)("Error occurred while chomping stream: " + exc.getMessage()));
            }
        }
        if (errorMessage != null) {
            while (true) {
                int n = ++i;
                --i;
                if (n == 0) break;
                FileWriter writer = (FileWriter)fList.get(i);
                destFile = writer.getDestFile().getAbsolutePath();
                _log.info((Object)("Rolling back '" + destFile + "'"));
                try {
                    writer.rollback();
                }
                catch (IOException exc) {
                    _log.error((Object)("Error rolling back '" + destFile + ": " + exc.getMessage()));
                }
            }
            throw new AgentRemoteException(errorMessage);
        }
        for (i = 0; i < fList.size(); ++i) {
            FileWriter writer = (FileWriter)fList.get(i);
            writer.cleanup();
            destFile = writer.getDestFile().getAbsolutePath();
            _log.info((Object)("Successfully wrote: " + destFile));
        }
    }

    private void byteChomper(InputStream inStream, long nBytes) throws IOException {
        byte[] buf = new byte[8192];
        while (nBytes != 0L) {
            int nToRead = (int)MathUtil.clamp((long)nBytes, (long)1L, (long)buf.length);
            int nRead = inStream.read(buf, 0, nToRead);
            if (nRead == -1) {
                throw new IOException("Unable to chomp " + nBytes + " EOF reached");
            }
            nBytes -= (long)nRead;
        }
    }

    public void die() throws AgentRemoteException {
        try {
            this._agent.die();
        }
        catch (AgentRunningException exc) {
            _log.error((Object)"Killing a running agent!");
        }
    }

    public long ping() throws AgentRemoteException {
        return 0L;
    }

    public void restart() throws AgentRemoteException {
        AgentUpgradeManager.restartJVM();
    }

    public String getCurrentAgentBundle() throws AgentRemoteException {
        return this._agent.getCurrentAgentBundle();
    }

    private void setExecuteBit(File file) throws AgentRemoteException {
        int rc;
        int timeout = 60000;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog watch = new ExecuteWatchdog(timeout);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), watch);
        try {
            String[] arguments = new String[]{"chmod", "+x", file.getCanonicalPath()};
            exec.setCommandline(arguments);
            _log.info((Object)("Running " + exec.getCommandLineString()));
            rc = exec.execute();
        }
        catch (Exception e) {
            rc = -1;
            _log.error((Object)e);
        }
        if (rc != 0) {
            String msg = output.toString().trim();
            if (msg.length() == 0) {
                msg = "timeout after " + timeout + "ms";
            }
            throw new AgentRemoteException("Failed to set permissions: [" + exec.getCommandLineString() + "] " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map upgrade(String bundle, String destination) throws AgentRemoteException {
        File bundleFile = new File(bundle);
        File workDir = new File(destination, "work");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            File bundleDir;
            String bundleHome;
            block25: {
                _log.info((Object)("Preparing to upgrade agent bundle from file " + bundle + " at destination " + destination));
                if (!WrapperManager.isControlledByNativeWrapper()) {
                    throw new AgentRemoteException("Upgrade command is not supported without the Java Service Wrapper.");
                }
                if (!bundleFile.isFile()) {
                    throw new AgentRemoteException("Upgrade agent bundle " + bundle + " is not a valid file");
                }
                bundleHome = this.getBundleHome(bundleFile);
                FileUtil.deleteDir((File)workDir);
                try {
                    FileUtil.decompress((File)bundleFile, (File)workDir);
                }
                catch (IOException e) {
                    _log.error((Object)("Failed to decompress " + bundle + " at destination " + workDir), (Throwable)e);
                    throw new AgentRemoteException("Failed to decompress " + bundle + " at destination " + workDir);
                }
                bundleDir = new File(destination, bundleHome);
                File extractedBundleDir = new File(workDir, bundleHome);
                if (!extractedBundleDir.isDirectory()) {
                    throw new AgentRemoteException("Invalid agent bundle file detected; missing top-level " + bundleDir + " directory");
                }
                if (bundleDir.exists()) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    bundleHome = bundleHome + "-" + dateFormat.format(new Date(System.currentTimeMillis()));
                    bundleDir = new File(destination, bundleHome);
                }
                if (!extractedBundleDir.renameTo(bundleDir)) {
                    throw new AgentRemoteException("Failed to copy agent bundle from " + extractedBundleDir + " to " + bundleDir);
                }
                if (!JDK.IS_WIN32) {
                    File[] scripts;
                    File pdkscriptsdir;
                    File[] libs;
                    File pdkdir = new File(bundleDir, "pdk");
                    File pdklibdir = new File(pdkdir, "lib");
                    File jredir = new File(pdkdir, "jre");
                    if (!pdklibdir.exists()) {
                        throw new AgentRemoteException("Invalid PDK library directory " + pdklibdir.getAbsolutePath());
                    }
                    for (File lib : libs = pdklibdir.listFiles()) {
                        if (!lib.getName().endsWith("sl")) continue;
                        this.setExecuteBit(lib);
                    }
                    if (jredir.exists()) {
                        File[] bins;
                        File jrebin = new File(jredir, "bin");
                        File[] arr$ = bins = jrebin.listFiles();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            File bin = arr$[i$];
                            this.setExecuteBit(bin);
                        }
                    }
                    if (!(pdkscriptsdir = new File(pdkdir, "scripts")).exists()) {
                        throw new AgentRemoteException("Invalid PDK scripts directory " + pdklibdir.getAbsolutePath());
                    }
                    for (File script : scripts = pdkscriptsdir.listFiles()) {
                        this.setExecuteBit(script);
                    }
                }
                boolean success = false;
                try {
                    success = AgentUpgradeManager.upgrade((String)bundleHome);
                }
                catch (IOException e) {
                    _log.error((Object)("Failed to write new bundle home " + bundleHome + " into rollback properties"), (Throwable)e);
                }
                finally {
                    if (success) break block25;
                    throw new AgentRemoteException("Failed to write new bundle home " + bundleHome + " into rollback properties");
                }
            }
            _log.info((Object)"Successfully upgraded to new agent bundle");
            try {
                _log.debug((Object)"Creating result map");
                File versionFile = new File(bundleDir, "lib/hq-version.properties");
                FileInputStream versionInputStream = new FileInputStream(versionFile);
                Properties newVersionProperties = new Properties();
                newVersionProperties.load(versionInputStream);
                String version = newVersionProperties.getProperty("version");
                _log.debug((Object)("VERSION: " + version));
                _log.debug((Object)("BUNDLE_NAME: " + bundleHome));
                result.put("version", version);
                result.put("bundleName", bundleHome);
            }
            catch (MalformedURLException e) {
                _log.warn((Object)"Could not access new hq-version.properties due to a malformed url, version value will not be updated in the database.", (Throwable)e);
            }
            catch (IOException e) {
                _log.warn((Object)"Could not read new hq-version.properties file, version value will not be updated in the database.", (Throwable)e);
            }
        }
        finally {
            this.doUpgradeCleanup(bundleFile, workDir);
        }
        return result;
    }

    private void doUpgradeCleanup(File bundleFile, File workDir) {
        bundleFile.delete();
        FileUtil.deleteDir((File)workDir);
    }

    private String getBundleHome(File bundleFile) throws AgentRemoteException {
        int index;
        String fileName = bundleFile.getName();
        if (fileName.endsWith(".tar.gz")) {
            index = fileName.lastIndexOf(".tar.gz");
        } else if (fileName.endsWith(".tgz")) {
            index = fileName.lastIndexOf(".tgz");
        } else if (fileName.endsWith(".zip")) {
            index = fileName.lastIndexOf(".zip");
        } else {
            throw new AgentRemoteException("Invalid file format for the agent bundle tar file (.zip, .tar.gz or .tgz expected)");
        }
        return fileName.substring(0, index);
    }

    public Map<String, Boolean> agentRemoveFile(Collection<String> files) {
        HashMap<String, Boolean> rtn = new HashMap<String, Boolean>();
        boolean debug = _log.isDebugEnabled();
        for (String filename : files) {
            if (filename == null) continue;
            try {
                File file = new File(this.resolveAgentBundleHomePath(filename));
                file.createNewFile();
                if (debug) {
                    _log.debug((Object)("removing file=" + file.getAbsolutePath()));
                }
                rtn.put(filename, file.exists());
            }
            catch (Exception e) {
                _log.warn((Object)("could not remove file " + filename + ": " + e));
                _log.debug((Object)e, (Throwable)e);
                rtn.put(filename, false);
            }
        }
        return rtn;
    }
}

