/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;
import org.hyperic.util.config.ConfigResponse;

public class ApacheSNMP {
    static final String COLUMN_VHOST_NAME = "wwwServiceName";
    static final String COLUMN_VHOST_PORT = "wwwServiceProtocol";
    static final String COLUMN_VHOST_DESC = "wwwServiceDescription";
    static final String COLUMN_VHOST_ADM = "wwwServiceContact";
    static final String TCP_PROTO_ID = "1.3.6.1.2.1.6.";
    private static final int TCP_PROTO_ID_LEN = "1.3.6.1.2.1.6.".length();
    private static HashMap configCache = null;
    private SNMPClient client = new SNMPClient();

    public List getServers(Properties config) throws SNMPException {
        return this.getServers(new ConfigResponse((Map)config));
    }

    public List getServers(ConfigResponse config) throws SNMPException {
        List admins;
        List ports;
        List names;
        String version;
        String description;
        ArrayList<Server> servers;
        block12: {
            SNMPSession session;
            servers = new ArrayList<Server>();
            description = null;
            version = null;
            try {
                session = this.client.getSession(config);
            }
            catch (SNMPException e) {
                throw new SNMPException("Error getting SNMP session: " + e.getMessage(), (Throwable)e);
            }
            try {
                names = session.getBulk(COLUMN_VHOST_NAME);
            }
            catch (SNMPException e) {
                throw new SNMPException("Error getting SNMP column: wwwServiceName: " + e.getMessage(), (Throwable)e);
            }
            try {
                ports = session.getBulk(COLUMN_VHOST_PORT);
            }
            catch (SNMPException e) {
                throw new SNMPException("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), (Throwable)e);
            }
            try {
                admins = session.getBulk(COLUMN_VHOST_ADM);
            }
            catch (SNMPException e) {
                throw new SNMPException("Error getting SNMP column: wwwServiceContact: " + e.getMessage(), (Throwable)e);
            }
            try {
                SNMPValue desc = session.getNextValue(COLUMN_VHOST_DESC);
                if (desc == null) break block12;
                description = desc.toString();
                StringTokenizer tok = new StringTokenizer(description);
                String ap = "Apache/";
                while (tok.hasMoreTokens()) {
                    String component = tok.nextToken();
                    if (!component.startsWith("Apache/")) continue;
                    version = component.substring("Apache/".length());
                    break;
                }
            }
            catch (SNMPException e) {
                throw new SNMPException("Error getting SNMP value: wwwServiceDescription: " + e.getMessage(), (Throwable)e);
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            Server server = new Server();
            server.port = ports.get(i).toString().substring(TCP_PROTO_ID_LEN);
            server.name = names.get(i).toString();
            server.admin = admins.get(i).toString();
            server.description = description;
            server.version = version;
            servers.add(server);
        }
        return servers;
    }

    static ConfigFile getConfig(String file) throws IOException {
        if (configCache == null) {
            configCache = new HashMap();
        }
        ConfigFile config = (ConfigFile)configCache.get(file);
        long lastModified = new File(file).lastModified();
        if (config == null || lastModified != config.lastModified) {
            config = new ConfigFile();
            config.lastModified = lastModified;
            ApacheSNMP.parse(file, config);
            configCache.put(file, config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(String file, ConfigFile config) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String portToken = "agentaddress";
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("agentaddress")) continue;
                config.port = line.substring("agentaddress".length()).trim();
                int ix = config.port.indexOf(64);
                if (ix == -1) continue;
                config.listen = config.port.substring(ix + 1);
                config.port = config.port.substring(0, ix);
            }
        }
        finally {
            reader.close();
        }
    }

    public static Properties getConfigProperties() {
        return ApacheSNMP.getConfigProperties(null);
    }

    public static Properties getConfigProperties(ConfigFile config) {
        Properties props = new Properties();
        if (config != null) {
            props.setProperty("snmpPort", config.port);
            props.setProperty("snmpIp", config.listen);
        }
        return props;
    }

    static class ConfigFile {
        long lastModified;
        String port;
        String listen = "127.0.0.1";

        ConfigFile() {
        }

        public String toString() {
            return this.listen + ":" + this.port;
        }
    }

    public class Server {
        String name;
        String port;
        String description;
        String version;
        String admin;

        public String toString() {
            return this.name + ":" + this.port;
        }
    }
}

