/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.ntds;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.IntegerConfigOption;

public class ActiveDirectoryDetector
extends ServerDetector
implements RegistryServerDetector {
    private static Log log = LogFactory.getLog((String)"ActiveDirectoryDetector");
    private static final String[] SERVICES = new String[]{"LDAP", "Authentication"};

    public List getServerResources(ConfigResponse platformConfig, String path, RegistryKey current) throws PluginException {
        String pluginServerVersionStr = this.getTypeInfo().getVersion();
        int pluginServerVersion = -1;
        if (pluginServerVersionStr != null) {
            try {
                pluginServerVersion = Integer.valueOf(pluginServerVersionStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!new File(path).exists()) {
            log.debug((Object)(path + " does not exist"));
            return null;
        }
        ConfigResponse cprops = new ConfigResponse();
        List cpropKeys = this.getCustomPropertiesSchema().getOptions();
        for (int i = 0; i < cpropKeys.size(); ++i) {
            String value;
            ConfigOption option = (ConfigOption)cpropKeys.get(i);
            String key = option.getName();
            try {
                value = option instanceof IntegerConfigOption ? String.valueOf(current.getIntValue(key)) : current.getStringValue(key).trim();
            }
            catch (Win32Exception e) {
                continue;
            }
            cprops.setValue(key, value);
        }
        int schemaVersion = -1;
        try {
            schemaVersion = Integer.valueOf(cprops.getValue("Schema Version"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        switch (schemaVersion) {
            case 13: {
                if (pluginServerVersion == 2000) break;
                return null;
            }
            case 30: 
            case 31: {
                if (pluginServerVersion == 2003) break;
                return null;
            }
            case 44: 
            case 47: 
            case 52: {
                if (pluginServerVersion == 2008) break;
                return null;
            }
            case 56: {
                if (pluginServerVersion == 2012) break;
                return null;
            }
            default: {
                log.error((Object)("unknown AD schema version number - " + schemaVersion));
            }
        }
        ServerResource server = this.createServerResource(path);
        server.setProductConfig();
        server.setMeasurementConfig();
        server.setCustomProperties(cprops);
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        servers.add(server);
        return servers;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        for (int i = 0; i < SERVICES.length; ++i) {
            ServiceResource service = new ServiceResource();
            service.setType((GenericPlugin)this, SERVICES[i]);
            service.setServiceName(SERVICES[i]);
            service.setProductConfig();
            service.setMeasurementConfig();
            services.add(service);
        }
        return services;
    }
}

