/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.Event;
import com.vmware.vim25.EventEx;
import com.vmware.vim25.KeyAnyValue;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VmEventArgument;
import com.vmware.vim25.mo.EventManager;
import java.util.Calendar;
import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class VCenterControlPlugin
extends ControlPlugin {
    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
    }

    public void doAction(String action, String[] args) throws PluginException {
        this.setResult(-1);
        if (args.length < 3) {
            this.setMessage("Expected at least 3 arguments for this action - 'VM moid', 'event type' and 'service name'");
            return;
        }
        String vmMoid = args[0];
        String eventType = args[1];
        String serviceName = args[2];
        String policyName = args[3];
        VSphereUtil vim = null;
        try {
            vim = VSphereUtil.getInstance(this.getConfig());
        }
        catch (PluginException ex) {
            this.setMessage("Unable to access VC: " + ex.getMessage());
            throw ex;
        }
        ManagedObjectReference morVM = new ManagedObjectReference();
        morVM.setVal(vmMoid);
        morVM.setType("VirtualMachine");
        EventManager eventManager = vim.getEventManager();
        Calendar calendar = Calendar.getInstance();
        EventEx eventEx = new EventEx();
        eventEx.setCreatedTime(calendar);
        eventEx.setEventTypeId(eventType);
        VmEventArgument vmEventArgument = new VmEventArgument();
        vmEventArgument.setName("vm");
        vmEventArgument.setVm(morVM);
        eventEx.setUserName("");
        eventEx.setVm(vmEventArgument);
        KeyAnyValue[] eventArgs = new KeyAnyValue[2];
        eventArgs[0] = new KeyAnyValue();
        eventArgs[0].setKey("serviceName");
        eventArgs[0].setValue((Object)serviceName);
        eventArgs[1] = new KeyAnyValue();
        eventArgs[1].setKey("policyName");
        eventArgs[1].setValue((Object)policyName);
        eventEx.setArguments(eventArgs);
        try {
            eventManager.postEvent((Event)eventEx, null);
            this.setResult(0);
        }
        catch (Exception ex) {
            this.setMessage("Failed to post VC event: " + ex.getMessage());
            throw new PluginException((Throwable)ex);
        }
    }
}

