/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.PluginException;

public class VSphereConnection {
    private static final Log _log = LogFactory.getLog(VSphereConnection.class);
    private static final Map<String, List<VSphereConnection>> _conns = new HashMap<String, List<VSphereConnection>>();
    private static final int POOL_SIZE = Integer.valueOf(System.getProperty("vsphere.pool.size", "2"));
    final Object LOCK = new Object();
    VSphereUtil vim;
    private String _user = "";
    private String _pass = "";
    private String url;

    public VSphereConnection(String url) {
        this.url = url;
    }

    private static String address(Object obj) {
        if (obj == null) {
            return "@NULL";
        }
        return "@" + Integer.toHexString(obj.hashCode());
    }

    private static String mask(String val) {
        return val.replaceAll(".", "*");
    }

    private static String diff(String old, String cur) {
        return "'" + old + "'->'" + cur + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VSphereConnection getPooledInstance(Properties props) throws PluginException {
        Map<String, List<VSphereConnection>> map = _conns;
        synchronized (map) {
            String url = VSphereUtil.getURL(props);
            List<VSphereConnection> tmp = _conns.get(url);
            if (null == tmp) {
                tmp = new ArrayList<VSphereConnection>();
                for (int ii = 0; ii < POOL_SIZE; ++ii) {
                    tmp.add(new VSphereConnection(url));
                }
                _conns.put(url, tmp);
            } else {
                while (tmp.size() == 0) {
                    try {
                        _conns.wait();
                    }
                    catch (InterruptedException e) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                }
            }
            VSphereConnection rtn = tmp.remove(0);
            rtn.validate(props);
            return rtn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evict(String url) throws PluginException {
        Map<String, List<VSphereConnection>> map = _conns;
        synchronized (map) {
            try {
                List<VSphereConnection> instances = _conns.get(url);
                if (instances != null) {
                    for (VSphereConnection v : instances) {
                        v.dispose();
                    }
                    _conns.remove(url);
                }
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<String, List<VSphereConnection>> map = _conns;
        synchronized (map) {
            List<VSphereConnection> tmp = _conns.get(this.getUrl());
            if (null != tmp) {
                tmp.add(this);
                _conns.notifyAll();
            }
        }
    }

    public void dispose() {
        if (this.vim != null) {
            VSphereUtil.dispose(this.vim);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Closed previous connection (" + VSphereConnection.address((Object)this.vim) + ") for: " + this.url));
            }
            this.vim = null;
        }
    }

    private String getUrl() {
        return this.url;
    }

    private void validate(Properties props) throws PluginException {
        boolean passwordChanged;
        String url = VSphereUtil.getURL(props);
        String username = props.getProperty("user", "");
        String password = props.getProperty("pass", "");
        boolean requiresReconnect = false;
        boolean usernameChanged = !username.equals(this._user);
        boolean bl = passwordChanged = !password.equals(this._pass);
        if (usernameChanged || passwordChanged) {
            requiresReconnect = true;
            if (_log.isDebugEnabled()) {
                String diff = "";
                if (usernameChanged) {
                    diff = diff + "user:" + VSphereConnection.diff(this._user, username);
                }
                if (passwordChanged) {
                    if (diff.length() != 0) {
                        diff = diff + ",";
                    }
                    diff = diff + "pass:" + VSphereConnection.diff(VSphereConnection.mask(this._pass), VSphereConnection.mask(password));
                }
                _log.debug((Object)("Credentials changed (" + diff + ") reconnecting cached connection for: " + url));
            }
        } else if (this.vim != null) {
            boolean bl2 = requiresReconnect = !this.vim.isSessionValid();
        }
        if (requiresReconnect) {
            this.dispose();
        }
        if (this.vim == null) {
            try {
                this.vim = VSphereUtil.getInstance(props);
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Opened new connection (" + VSphereConnection.address((Object)this.vim) + "/" + VSphereConnection.address(this.LOCK) + ") for: " + url));
            }
            this._user = username;
            this._pass = password;
        }
    }
}

