/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.db2jdbc.DB2JDBCProductPlugin;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public abstract class DefaultServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final Pattern regExpInstall = Pattern.compile("([^ ]*) *(\\d*\\.\\d*\\.\\d*\\.\\d*) *([^ ]*)");
    private static final Log log = LogFactory.getLog(DefaultServerDetector.class);

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
    }

    public List getServerResources(ConfigResponse conf) throws PluginException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("[getServerResources] conf=" + conf));
        }
        Iterator paths = DefaultServerDetector.getInstallPaths(conf.toProperties(), this.getTypeInfo().getVersion()).iterator();
        ArrayList res = new ArrayList();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            res.addAll(this.createServers(path));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getInstallPaths(Properties conf, String versionExp) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern regExpVersion = Pattern.compile(versionExp.replaceAll("[X|x]", "\\d*"));
        boolean debug = log.isDebugEnabled();
        if (DefaultServerDetector.isWin32()) {
            try {
                RegistryKey key = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\IBM\\DB2\\InstalledCopies");
                String[] instances = key.getSubKeyNames();
                key.close();
                for (int n = 0; n < instances.length; ++n) {
                    key = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\IBM\\DB2\\InstalledCopies\\" + instances[n] + "\\CurrentVersion");
                    String version = key.getStringValue("Version") + "." + key.getStringValue("Release") + "." + key.getStringValue("Modification") + "." + key.getStringValue("Fix Level");
                    key.close();
                    if (debug) {
                        log.debug((Object)(instances[n] + "-->" + version));
                    }
                    if (regExpVersion.matcher(version).find()) {
                        key = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\IBM\\DB2\\InstalledCopies\\" + instances[n]);
                        String path = key.getStringValue("DB2 Path Name");
                        key.close();
                        res.add(path.trim());
                        continue;
                    }
                    if (!debug) continue;
                    log.debug((Object)("[getInstallPaths] bad version: '" + instances[n] + " " + version + "'"));
                }
                return res;
            }
            catch (Win32Exception ex) {
                if (!debug) return res;
                log.debug((Object)("[getInstallPaths] error: " + ex.getMessage()), (Throwable)ex);
                return res;
            }
        }
        try {
            Process cmd = Runtime.getRuntime().exec(DB2JDBCProductPlugin.DB2LS);
            cmd.waitFor();
            String resultString = DefaultServerDetector.inputStreamAsString(cmd.getInputStream());
            if (debug) {
                log.debug((Object)("[getInstallPaths] command result=" + resultString));
            }
            String[] installs = resultString.split("\n");
            for (int n = 0; n < installs.length; ++n) {
                Matcher m = regExpInstall.matcher(installs[n]);
                if (!m.find()) continue;
                if (regExpVersion.matcher(m.group(2)).find()) {
                    if (debug) {
                        log.debug((Object)("[getInstallPaths] found: '" + m.group() + "'"));
                    }
                    res.add(m.group(1));
                    continue;
                }
                if (!debug) continue;
                log.debug((Object)("[getInstallPaths] bad version: '" + m.group() + "'"));
            }
            return res;
        }
        catch (IOException ex) {
            if (!debug) return res;
            log.debug((Object)("[getInstallPaths] " + ex.getMessage()));
            return res;
        }
        catch (Exception e) {
            if (!debug) return res;
            log.debug((Object)("[getInstallPaths] error: " + e.getMessage()), (Throwable)e);
        }
        return res;
    }

    protected boolean checkEntryTypes(String type) {
        boolean res;
        boolean bl = res = DB2JDBCProductPlugin.ENTRY_TYPES.contains("*") || DB2JDBCProductPlugin.ENTRY_TYPES.contains(type.toLowerCase());
        if (log.isDebugEnabled()) {
            log.debug((Object)("[checkEntryTypes] type='" + type + "' res='" + res + "'"));
        }
        return res;
    }

    protected String getListDatabaseCommand() {
        return DB2JDBCProductPlugin.LIST_DATABASE;
    }

    protected abstract List createServers(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    static final Connection getConnection(Properties props) throws SQLException, ClassNotFoundException {
        Class.forName("com.ibm.db2.jcc.DB2Driver");
        String url = "jdbc:db2://" + props.getProperty("db2.jdbc.hostname") + ":" + props.getProperty("db2.jdbc.port") + "/" + props.getProperty("db2.jdbc.database");
        String user = props.getProperty("db2.jdbc.user");
        String pass = props.getProperty("db2.jdbc.password");
        return DriverManager.getConnection(url, user, pass);
    }
}

