/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.plugin.db2jdbc.CachedJDBCMeasurement;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricValue;

public class Measurement
extends CachedJDBCMeasurement {
    private static final String JDBC_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String KEY = "key";

    protected String getQuery(Metric metric) {
        String sql;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("[getQuery] metric=" + metric));
        }
        if ((sql = metric.getObjectProperties().getProperty("sql")) == null) {
            String func = metric.getObjectProperties().getProperty("func") + "('" + metric.getProperties().getProperty("database");
            String where = metric.getObjectProperties().getProperty("where") != null ? " where " + metric.getObjectProperties().getProperty("where") : "";
            sql = "SELECT * FROM TABLE(" + func + "', -2)) as t" + where;
        }
        return sql;
    }

    protected void getDriver() throws ClassNotFoundException {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException ex) {
            this.getLog().debug((Object)("DB2 driver not found: " + ex.getMessage()));
            throw ex;
        }
    }

    protected Connection getConnection(String url, String user, String pass) throws SQLException {
        this.getLog().debug((Object)("[getConnection] url='" + url + "' user='" + user + "' pass='******'"));
        return DriverManager.getConnection(url, user, pass);
    }

    Map processResulSet(ResultSet rs, Metric metric) throws MetricNotFoundException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String prefix = "";
        try {
            if (rs.next()) {
                if (metric.getObjectProperty(KEY) != null) {
                    prefix = rs.getString(metric.getObjectProperty(KEY)) + ".";
                    res.put(prefix + "availability", new MetricValue(1L));
                }
                ResultSetMetaData md = rs.getMetaData();
                for (int c = 1; c <= md.getColumnCount(); ++c) {
                    String key = md.getColumnLabel(c);
                    double val = Double.NaN;
                    switch (md.getColumnType(c)) {
                        case -5: 
                        case 3: 
                        case 4: 
                        case 5: {
                            val = rs.getDouble(c);
                            break;
                        }
                        case 93: {
                            Timestamp ts = rs.getTimestamp(c);
                            val = ts != null ? (double)ts.getTime() : Double.NaN;
                            break;
                        }
                        case 1: 
                        case 12: {
                            String v = rs.getString(c);
                            if (v == null) break;
                            double d = v.equalsIgnoreCase("yes") ? 1.0 : (val = v.equalsIgnoreCase("no") ? 0.0 : Double.NaN);
                            if (!new Double(val).equals(new Double(Double.NaN))) break;
                            res.put("raw." + key, v);
                            if (!this.getLog().isTraceEnabled()) break;
                            this.getLog().trace((Object)("key='raw." + key + "'\tvalue='" + v + "'"));
                            break;
                        }
                        default: {
                            this.getLog().debug((Object)(key + "==>" + md.getColumnClassName(c)));
                            assert (false) : key + "==>" + "(type='" + md.getColumnType(c) + "')" + md.getColumnClassName(c);
                            break;
                        }
                    }
                    key = prefix + key;
                    if (this.getLog().isTraceEnabled()) {
                        this.getLog().trace((Object)("key='" + key + "'\tvalue='" + val + "'"));
                    }
                    res.put(key, new MetricValue(val));
                }
            } else {
                throw new MetricNotFoundException("No row selectd");
            }
            assert (!rs.next()) : this.getQuery(metric);
            try {
                this.postProcessResults(res);
            }
            catch (Throwable e) {
                assert (false) : e;
                this.getLog().debug((Object)("Error '" + e.getMessage() + "'"), e);
            }
        }
        catch (SQLException e) {
            throw new MetricNotFoundException(e.getMessage());
        }
        return res;
    }

    protected void postProcessResults(Map results) {
    }
}

