/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.util.InetPortPinger;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereControlPlugin
extends ServerControlPlugin {
    private static final String[] actions = new String[]{"start", "stop", "restart"};
    private static final List commands = Arrays.asList(actions);
    private InetPortPinger portPinger;
    private String[] ctlArgs = new String[0];

    protected String getAdminHost() {
        return this.getConfig().getValue("admin.host");
    }

    protected String getAdminPort() {
        return this.getConfig().getValue("admin.port");
    }

    protected String getServerNode() {
        return this.getConfig().getValue("server.node");
    }

    protected String getServerName() {
        return this.getConfig().getValue("server.name");
    }

    protected String getUsername() {
        return this.getConfig().getValue("username");
    }

    protected String getPassword() {
        return this.getConfig().getValue("password");
    }

    protected String getRunningHost() {
        return this.getAdminHost();
    }

    protected String getRunningPort() {
        return this.getAdminPort();
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        String username = this.getUsername();
        String password = this.getPassword();
        this.ctlArgs = username != null && password != null ? new String[]{this.getServerName(), "-username", username, "-password", password} : new String[]{this.getServerName()};
        try {
            int iport = Integer.parseInt(this.getRunningPort());
            this.portPinger = new InetPortPinger(this.getRunningHost(), iport, 30000);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    protected boolean isRunning() {
        if (this.portPinger == null) {
            return false;
        }
        return this.portPinger.check();
    }

    protected int checkIsRunning(String action) {
        if (action.equals("start")) {
            if (this.isRunning()) {
                this.setMessage("Server already running on port " + this.getRunningPort());
                return -1;
            }
        } else if (action.equals("stop") && !this.isRunning()) {
            this.setMessage("No server running on port " + this.getRunningPort());
            return -1;
        }
        return 0;
    }

    public List getActions() {
        return commands;
    }

    public void doAction(String action, String[] args) throws PluginException {
        if (action.equals("start")) {
            this.setResult(this.start(args));
        } else if (action.equals("stop")) {
            this.setResult(this.stop(args));
        } else if (action.equals("restart")) {
            this.setResult(this.restart(args));
        } else {
            throw new PluginException("Action '" + action + "' not supported");
        }
    }

    protected int doCommand(String action, String[] args) {
        String script = this.getConfig().getValue("program." + action);
        this.setControlProgram(script);
        this.getLog().debug((Object)("command script=" + script));
        if (args == null || args.length == 0) {
            args = this.ctlArgs;
        }
        return super.doCommand(script, args);
    }

    private int start(String[] args) {
        int res = this.doCommand("start", args);
        if (res == 0) {
            this.waitForState("started");
        }
        return res;
    }

    private int stop(String[] args) {
        int res = this.doCommand("stop", args);
        if (res == 0) {
            this.waitForState("stopped");
        }
        return res;
    }

    private int restart(String[] args) {
        int res = this.stop(args);
        if (res != 0) {
            return res;
        }
        return this.start(args);
    }
}

